/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.model.Country;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.CountryServiceUtil;
import com.liferay.portal.service.http.TunnelUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CountryServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(CountryServiceHttp.class);

    public static Country addCountry(HttpPrincipal httpPrincipal, String name, String a2, String a3, String number, String idd, boolean active) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CountryServiceUtil.class.getName(), "addCountry", new Class[]{String.class, String.class, String.class, String.class, String.class, Boolean.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{name, a2, a3, number, idd, active});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Country)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Country> getCountries(HttpPrincipal httpPrincipal) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(CountryServiceUtil.class.getName(), "getCountries", new Class[0]);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[0]);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Country> getCountries(HttpPrincipal httpPrincipal, boolean active) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(CountryServiceUtil.class.getName(), "getCountries", new Class[]{Boolean.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{active});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Country getCountry(HttpPrincipal httpPrincipal, long countryId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CountryServiceUtil.class.getName(), "getCountry", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{countryId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Country)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Country getCountryByA2(HttpPrincipal httpPrincipal, String a2) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CountryServiceUtil.class.getName(), "getCountryByA2", new Class[]{String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{a2});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Country)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Country getCountryByA3(HttpPrincipal httpPrincipal, String a3) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CountryServiceUtil.class.getName(), "getCountryByA3", new Class[]{String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{a3});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Country)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Country getCountryByName(HttpPrincipal httpPrincipal, String name) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CountryServiceUtil.class.getName(), "getCountryByName", new Class[]{String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{name});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Country)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

