/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.Address;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.EmailAddress;
import com.liferay.portal.model.Phone;
import com.liferay.portal.model.Website;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.CompanyServiceUtil;
import com.liferay.portal.service.http.TunnelUtil;
import java.io.File;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompanyServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(CompanyServiceHttp.class);

    public static Company addCompany(HttpPrincipal httpPrincipal, String webId, String virtualHost, String mx, String shardName, boolean system, int maxUsers) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CompanyServiceUtil.class.getName(), "addCompany", new Class[]{String.class, String.class, String.class, String.class, Boolean.TYPE, Integer.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{webId, virtualHost, mx, shardName, system, maxUsers});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Company)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteLogo(HttpPrincipal httpPrincipal, long companyId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CompanyServiceUtil.class.getName(), "deleteLogo", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Company getCompanyById(HttpPrincipal httpPrincipal, long companyId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CompanyServiceUtil.class.getName(), "getCompanyById", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Company)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Company getCompanyByLogoId(HttpPrincipal httpPrincipal, long logoId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CompanyServiceUtil.class.getName(), "getCompanyByLogoId", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{logoId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Company)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Company getCompanyByMx(HttpPrincipal httpPrincipal, String mx) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CompanyServiceUtil.class.getName(), "getCompanyByMx", new Class[]{String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{mx});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Company)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Company getCompanyByVirtualHost(HttpPrincipal httpPrincipal, String virtualHost) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CompanyServiceUtil.class.getName(), "getCompanyByVirtualHost", new Class[]{String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{virtualHost});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Company)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Company getCompanyByWebId(HttpPrincipal httpPrincipal, String webId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CompanyServiceUtil.class.getName(), "getCompanyByWebId", new Class[]{String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{webId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Company)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void removePreferences(HttpPrincipal httpPrincipal, long companyId, String[] keys) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CompanyServiceUtil.class.getName(), "removePreferences", new Class[]{Long.TYPE, String[].class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, keys});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Company updateCompany(HttpPrincipal httpPrincipal, long companyId, String virtualHost, String mx, int maxUsers) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CompanyServiceUtil.class.getName(), "updateCompany", new Class[]{Long.TYPE, String.class, String.class, Integer.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, virtualHost, mx, maxUsers});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Company)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Company updateCompany(HttpPrincipal httpPrincipal, long companyId, String virtualHost, String mx, String homeURL, String name, String legalName, String legalId, String legalType, String sicCode, String tickerSymbol, String industry, String type, String size) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CompanyServiceUtil.class.getName(), "updateCompany", new Class[]{Long.TYPE, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, virtualHost, mx, homeURL, name, legalName, legalId, legalType, sicCode, tickerSymbol, industry, type, size});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Company)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Company updateCompany(HttpPrincipal httpPrincipal, long companyId, String virtualHost, String mx, String homeURL, String name, String legalName, String legalId, String legalType, String sicCode, String tickerSymbol, String industry, String type, String size, String languageId, String timeZoneId, List<Address> addresses, List<EmailAddress> emailAddresses, List<Phone> phones, List<Website> websites, UnicodeProperties properties) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CompanyServiceUtil.class.getName(), "updateCompany", new Class[]{Long.TYPE, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, List.class, List.class, List.class, List.class, UnicodeProperties.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, virtualHost, mx, homeURL, name, legalName, legalId, legalType, sicCode, tickerSymbol, industry, type, size, languageId, timeZoneId, addresses, emailAddresses, phones, websites, properties});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Company)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void updateDisplay(HttpPrincipal httpPrincipal, long companyId, String languageId, String timeZoneId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CompanyServiceUtil.class.getName(), "updateDisplay", new Class[]{Long.TYPE, String.class, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, languageId, timeZoneId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void updateLogo(HttpPrincipal httpPrincipal, long companyId, File file) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CompanyServiceUtil.class.getName(), "updateLogo", new Class[]{Long.TYPE, File.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, file});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void updatePreferences(HttpPrincipal httpPrincipal, long companyId, UnicodeProperties properties) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CompanyServiceUtil.class.getName(), "updatePreferences", new Class[]{Long.TYPE, UnicodeProperties.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, properties});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void updateSecurity(HttpPrincipal httpPrincipal, long companyId, String authType, boolean autoLogin, boolean sendPassword, boolean strangers, boolean strangersWithMx, boolean strangersVerify, boolean communityLogo) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CompanyServiceUtil.class.getName(), "updateSecurity", new Class[]{Long.TYPE, String.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, authType, autoLogin, sendPassword, strangers, strangersWithMx, strangersVerify, communityLogo});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

