/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.portal.NoSuchResourceActionException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.PasswordPolicy;
import com.liferay.portal.model.Permission;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.ResourceAction;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletResourceBundles;
import com.liferay.portlet.expando.model.ExpandoColumn;
import com.liferay.portlet.social.model.SocialEquityActionMapping;
import com.liferay.util.UniqueList;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.jsp.PageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceActionsUtil {
    public static final String ACTION_NAME_PREFIX = "action.";
    public static final String MODEL_RESOURCE_NAME_PREFIX = "model.resource.";
    public static final String[] ORGANIZATION_MODEL_RESOURCES = new String[]{Organization.class.getName(), PasswordPolicy.class.getName(), User.class.getName()};
    public static final String[] PORTAL_MODEL_RESOURCES = new String[]{ExpandoColumn.class.getName(), Organization.class.getName(), PasswordPolicy.class.getName(), Role.class.getName(), User.class.getName(), UserGroup.class.getName()};
    private static Log _log = LogFactoryUtil.getLog(ResourceActionsUtil.class);
    private static ResourceActionsUtil _instance = new ResourceActionsUtil();
    private Map<String, Set<String>> _modelPortletResources;
    private Map<String, List<String>> _modelResourceActions;
    private Map<String, List<String>> _modelResourceCommunityDefaultActions;
    private Map<String, List<String>> _modelResourceGuestDefaultActions;
    private Map<String, List<String>> _modelResourceGuestUnsupportedActions;
    private Map<String, List<String>> _modelResourceOwnerDefaultActions;
    private Set<String> _organizationModelResources = new HashSet<String>();
    private Set<String> _portalModelResources;
    private Map<String, Set<String>> _portletModelResources;
    private Map<String, List<String>> _portletResourceActions;
    private Map<String, List<String>> _portletResourceCommunityDefaultActions;
    private Map<String, List<String>> _portletResourceGuestDefaultActions;
    private Map<String, List<String>> _portletResourceGuestUnsupportedActions;
    private Map<String, List<String>> _portletResourceLayoutManagerActions;
    private Map<String, Map<String, SocialEquityActionMapping>> _socialEquityActionMappings;

    public static void checkAction(String name, String actionId) throws NoSuchResourceActionException {
        List<String> resourceActions = ResourceActionsUtil.getResourceActions(name);
        if (!resourceActions.contains(actionId)) {
            throw new NoSuchResourceActionException(name.concat("#").concat(actionId));
        }
    }

    public static String getAction(Locale locale, String action) {
        String key = ACTION_NAME_PREFIX + action;
        String value = LanguageUtil.get((Locale)locale, (String)key, null);
        if (value == null || value.equals(key)) {
            value = PortletResourceBundles.getString(locale, key);
        }
        if (value == null) {
            value = key;
        }
        return value;
    }

    public static String getAction(PageContext pageContext, String action) {
        String key = ACTION_NAME_PREFIX + action;
        String value = LanguageUtil.get((PageContext)pageContext, (String)key, null);
        if (value == null || value.equals(key)) {
            value = PortletResourceBundles.getString(pageContext, key);
        }
        if (value == null) {
            value = key;
        }
        return value;
    }

    public static List<String> getActions(List<Permission> permissions) {
        UniqueList actions = new UniqueList();
        for (Permission permission : permissions) {
            actions.add(permission.getActionId());
        }
        return actions;
    }

    public static List<String> getActionsNames(PageContext pageContext, List<String> actions) {
        UniqueList uniqueList = new UniqueList();
        for (String action : actions) {
            uniqueList.add(ResourceActionsUtil.getAction(pageContext, action));
        }
        ArrayList<String> list = new ArrayList<String>();
        list.addAll((Collection<String>)uniqueList);
        return list;
    }

    public static List<String> getActionsNames(PageContext pageContext, String name, long actionIds) {
        try {
            List resourceActions = ResourceActionLocalServiceUtil.getResourceActions((String)name);
            ArrayList<String> actions = new ArrayList<String>();
            for (ResourceAction resourceAction : resourceActions) {
                long bitwiseValue = resourceAction.getBitwiseValue();
                if ((actionIds & bitwiseValue) != bitwiseValue) continue;
                actions.add(resourceAction.getActionId());
            }
            return ResourceActionsUtil.getActionsNames(pageContext, actions);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }

    public static List<String> getModelNames() {
        return _instance._getModelNames();
    }

    public static List<String> getModelPortletResources(String name) {
        return _instance._getModelPortletResources(name);
    }

    public static String getModelResource(Locale locale, String name) {
        String key = MODEL_RESOURCE_NAME_PREFIX + name;
        String value = LanguageUtil.get((Locale)locale, (String)key, null);
        if (value == null || value.equals(key)) {
            value = PortletResourceBundles.getString(locale, key);
        }
        if (value == null) {
            value = key;
        }
        return value;
    }

    public static String getModelResource(PageContext pageContext, String name) {
        String key = MODEL_RESOURCE_NAME_PREFIX + name;
        String value = LanguageUtil.get((PageContext)pageContext, (String)key, null);
        if (value == null || value.equals(key)) {
            value = PortletResourceBundles.getString(pageContext, key);
        }
        if (value == null) {
            value = key;
        }
        return value;
    }

    public static List<String> getModelResourceActions(String name) {
        return _instance._getModelResourceActions(name);
    }

    public static List<String> getModelResourceCommunityDefaultActions(String name) {
        return _instance._getModelResourceCommunityDefaultActions(name);
    }

    public static List<String> getModelResourceGuestDefaultActions(String name) {
        return _instance._getModelResourceGuestDefaultActions(name);
    }

    public static List<String> getModelResourceGuestUnsupportedActions(String name) {
        return _instance._getModelResourceGuestUnsupportedActions(name);
    }

    public static List<String> getModelResourceOwnerDefaultActions(String name) {
        return _instance._getModelResourceOwnerDefaultActions(name);
    }

    public static String getPortletBaseResource(String portletName) {
        return _instance._getPortletBaseResource(portletName);
    }

    public static List<String> getPortletModelResources(String portletName) {
        return _instance._getPortletModelResources(portletName);
    }

    public static List<String> getPortletNames() {
        return _instance._getPortletNames();
    }

    public static List<String> getPortletResourceActions(String name) {
        return _instance._getPortletResourceActions(name);
    }

    public static List<String> getPortletResourceCommunityDefaultActions(String name) {
        return _instance._getPortletResourceCommunityDefaultActions(name);
    }

    public static List<String> getPortletResourceGuestDefaultActions(String name) {
        return _instance._getPortletResourceGuestDefaultActions(name);
    }

    public static List<String> getPortletResourceGuestUnsupportedActions(String name) {
        return _instance._getPortletResourceGuestUnsupportedActions(name);
    }

    public static List<String> getPortletResourceLayoutManagerActions(String name) {
        return _instance._getPortletResourceLayoutManagerActions(name);
    }

    public static List<String> getResourceActions(String name) {
        if (name.contains(".")) {
            return ResourceActionsUtil.getModelResourceActions(name);
        }
        return ResourceActionsUtil.getPortletResourceActions(name);
    }

    public static List<String> getResourceActions(String portletResource, String modelResource) {
        List<String> actions = null;
        actions = Validator.isNull((String)modelResource) ? ResourceActionsUtil.getPortletResourceActions(portletResource) : ResourceActionsUtil.getModelResourceActions(modelResource);
        return actions;
    }

    public static List<String> getResourceCommunityDefaultActions(String name) {
        if (name.contains(".")) {
            return ResourceActionsUtil.getModelResourceCommunityDefaultActions(name);
        }
        return ResourceActionsUtil.getPortletResourceCommunityDefaultActions(name);
    }

    public static List<String> getResourceGuestUnsupportedActions(String portletResource, String modelResource) {
        List<String> actions = null;
        actions = Validator.isNull((String)modelResource) ? ResourceActionsUtil.getPortletResourceGuestUnsupportedActions(portletResource) : ResourceActionsUtil.getModelResourceGuestUnsupportedActions(modelResource);
        return actions;
    }

    public static List<Role> getRoles(long companyId, Group group, String modelResource) throws SystemException {
        List allRoles = RoleLocalServiceUtil.getRoles((long)companyId);
        int[] types = new int[]{1, 2};
        if (ResourceActionsUtil.isPortalModelResource(modelResource)) {
            types = modelResource.equals(Organization.class.getName()) || modelResource.equals(User.class.getName()) ? new int[]{1, 3} : new int[]{1};
        } else if (group != null) {
            if (group.isOrganization()) {
                types = new int[]{1, 3};
            } else if (group.isUser()) {
                types = new int[]{1};
            }
        }
        ArrayList<Role> roles = new ArrayList<Role>();
        int[] nArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            int type = nArray[n2];
            for (Role role : allRoles) {
                if (role.getType() != type) continue;
                roles.add(role);
            }
            ++n2;
        }
        return roles;
    }

    public static SocialEquityActionMapping getSocialEquityActionMapping(String name, String actionId) {
        return _instance._getSocialEquityActionMapping(name, actionId);
    }

    public static List<SocialEquityActionMapping> getSocialEquityActionMappings(String name) {
        return _instance._getSocialEquityActionMappings(name);
    }

    public static String[] getSocialEquityClassNames() {
        return _instance._getSocialEquityClassNames();
    }

    public static boolean hasModelResourceActions(String name) {
        return _instance._hasModelResourceActions(name);
    }

    public static void init() {
        _instance._init();
    }

    public static boolean isOrganizationModelResource(String modelResource) {
        return _instance._isOrganizationModelResource(modelResource);
    }

    public static boolean isPortalModelResource(String modelResource) {
        return _instance._isPortalModelResource(modelResource);
    }

    public static void read(String servletContextName, ClassLoader classLoader, String source) throws Exception {
        _instance._read(servletContextName, classLoader, source);
    }

    public static void read(String servletContextName, InputStream inputStream) throws Exception {
        _instance._read(servletContextName, inputStream);
    }

    private ResourceActionsUtil() {
        String resource;
        String[] stringArray = ORGANIZATION_MODEL_RESOURCES;
        int n = ORGANIZATION_MODEL_RESOURCES.length;
        int n2 = 0;
        while (n2 < n) {
            resource = stringArray[n2];
            this._organizationModelResources.add(resource);
            ++n2;
        }
        this._portalModelResources = new HashSet<String>();
        stringArray = PORTAL_MODEL_RESOURCES;
        n = PORTAL_MODEL_RESOURCES.length;
        n2 = 0;
        while (n2 < n) {
            resource = stringArray[n2];
            this._portalModelResources.add(resource);
            ++n2;
        }
        this._portletModelResources = new HashMap<String, Set<String>>();
        this._portletResourceActions = new HashMap<String, List<String>>();
        this._portletResourceCommunityDefaultActions = new HashMap<String, List<String>>();
        this._portletResourceGuestDefaultActions = new HashMap<String, List<String>>();
        this._portletResourceGuestUnsupportedActions = new HashMap<String, List<String>>();
        this._portletResourceLayoutManagerActions = new HashMap<String, List<String>>();
        this._modelPortletResources = new HashMap<String, Set<String>>();
        this._modelResourceActions = new HashMap<String, List<String>>();
        this._modelResourceCommunityDefaultActions = new HashMap<String, List<String>>();
        this._modelResourceGuestDefaultActions = new HashMap<String, List<String>>();
        this._modelResourceGuestUnsupportedActions = new HashMap<String, List<String>>();
        this._modelResourceOwnerDefaultActions = new HashMap<String, List<String>>();
        this._socialEquityActionMappings = new HashMap<String, Map<String, SocialEquityActionMapping>>();
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            String[] stringArray2 = PropsValues.RESOURCE_ACTIONS_CONFIGS;
            int n3 = PropsValues.RESOURCE_ACTIONS_CONFIGS.length;
            n = 0;
            while (n < n3) {
                String config = stringArray2[n];
                this._read(null, classLoader, config);
                ++n;
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    private void _checkGuestUnsupportedActions(List<String> guestUnsupportedActions, List<String> guestDefaultActions) {
        Iterator<String> itr = guestDefaultActions.iterator();
        while (itr.hasNext()) {
            String actionId = itr.next();
            if (!guestUnsupportedActions.contains(actionId)) continue;
            itr.remove();
        }
    }

    private void _checkModelActions(List<String> actions) {
        if (!actions.contains("PERMISSIONS")) {
            actions.add("PERMISSIONS");
        }
    }

    private void _checkPortletActions(List<String> actions) {
        if (!actions.contains("ACCESS_IN_CONTROL_PANEL") && !actions.contains("ADD_TO_PAGE")) {
            actions.add("ADD_TO_PAGE");
        }
        if (!actions.contains("CONFIGURATION")) {
            actions.add("CONFIGURATION");
        }
        if (!actions.contains("VIEW")) {
            actions.add("VIEW");
        }
    }

    private void _checkPortletCommunityDefaultActions(List<String> actions) {
        if (actions.size() == 0) {
            actions.add("VIEW");
        }
    }

    private void _checkPortletGuestDefaultActions(List<String> actions) {
        if (actions.size() == 0) {
            actions.add("VIEW");
        }
    }

    private void _checkPortletLayoutManagerActions(List<String> actions) {
        if (!actions.contains("CONFIGURATION")) {
            actions.add("CONFIGURATION");
        }
        if (!actions.contains("PREFERENCES")) {
            actions.add("PREFERENCES");
        }
        if (!actions.contains("VIEW")) {
            actions.add("VIEW");
        }
    }

    private List<String> _getActions(Map<String, List<String>> actionsMap, String name) {
        UniqueList actions = actionsMap.get(name);
        if (actions == null) {
            actions = new UniqueList();
            actionsMap.put(name, (List<String>)actions);
        }
        return actions;
    }

    private List<String> _getModelNames() {
        return ListUtil.fromCollection(this._modelPortletResources.keySet());
    }

    private List<String> _getModelPortletResources(String name) {
        Set<String> resources = this._modelPortletResources.get(name);
        if (resources == null) {
            return new UniqueList();
        }
        return Collections.list(Collections.enumeration(resources));
    }

    private List<String> _getModelResourceActions(String name) {
        return this._getActions(this._modelResourceActions, name);
    }

    private List<String> _getModelResourceCommunityDefaultActions(String name) {
        return this._getActions(this._modelResourceCommunityDefaultActions, name);
    }

    private List<String> _getModelResourceGuestDefaultActions(String name) {
        return this._getActions(this._modelResourceGuestDefaultActions, name);
    }

    private List<String> _getModelResourceGuestUnsupportedActions(String name) {
        return this._getActions(this._modelResourceGuestUnsupportedActions, name);
    }

    private List<String> _getModelResourceOwnerDefaultActions(String name) {
        return this._getActions(this._modelResourceOwnerDefaultActions, name);
    }

    private Element _getPermissionsChildElement(Element parentElement, String childElementName) {
        Element permissionsElement = parentElement.element("permissions");
        if (permissionsElement != null) {
            return permissionsElement.element(childElementName);
        }
        return parentElement.element(childElementName);
    }

    private String _getPortletBaseResource(String portletName) {
        List<String> modelNames = this._getPortletModelResources(portletName);
        for (String modelName : modelNames) {
            if (modelName.contains(".model.")) continue;
            return modelName;
        }
        return null;
    }

    private List<String> _getPortletMimeTypeActions(String name) {
        UniqueList actions = new UniqueList();
        Portlet portlet = PortletLocalServiceUtil.getPortletById((String)name);
        if (portlet != null) {
            Map portletModes = portlet.getPortletModes();
            Set mimeTypePortletModes = (Set)portletModes.get("text/html");
            if (mimeTypePortletModes != null) {
                for (String actionId : mimeTypePortletModes) {
                    if (actionId.equalsIgnoreCase("edit")) {
                        actions.add("PREFERENCES");
                        continue;
                    }
                    if (actionId.equalsIgnoreCase("edit_guest")) {
                        actions.add("GUEST_PREFERENCES");
                        continue;
                    }
                    actions.add(actionId.toUpperCase());
                }
            }
        } else if (_log.isDebugEnabled()) {
            _log.debug((Object)("Unable to obtain resource actions for unknown portlet " + name));
        }
        return actions;
    }

    private List<String> _getPortletModelResources(String portletName) {
        Set<String> resources = this._portletModelResources.get(portletName = PortletConstants.getRootPortletId((String)portletName));
        if (resources == null) {
            return new UniqueList();
        }
        return Collections.list(Collections.enumeration(resources));
    }

    private List<String> _getPortletNames() {
        return ListUtil.fromCollection(this._portletModelResources.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> _getPortletResourceActions(String name) {
        List<String> actions = this._getActions(this._portletResourceActions, name = PortletConstants.getRootPortletId((String)name));
        if (actions.size() == 0) {
            ResourceActionsUtil resourceActionsUtil = this;
            synchronized (resourceActionsUtil) {
                UniqueList layoutManagerActions;
                UniqueList guestDefaultActions;
                UniqueList communityDefaultActions;
                actions = this._getPortletMimeTypeActions(name);
                if (!name.equals("90")) {
                    this._checkPortletActions(actions);
                }
                if ((communityDefaultActions = this._portletResourceCommunityDefaultActions.get(name)) == null) {
                    communityDefaultActions = new UniqueList();
                    this._portletResourceCommunityDefaultActions.put(name, (List<String>)communityDefaultActions);
                    this._checkPortletCommunityDefaultActions((List<String>)communityDefaultActions);
                }
                if ((guestDefaultActions = this._portletResourceGuestDefaultActions.get(name)) == null) {
                    guestDefaultActions = new UniqueList();
                    this._portletResourceGuestDefaultActions.put(name, (List<String>)guestDefaultActions);
                    this._checkPortletGuestDefaultActions((List<String>)guestDefaultActions);
                }
                if ((layoutManagerActions = this._portletResourceLayoutManagerActions.get(name)) == null) {
                    layoutManagerActions = new UniqueList();
                    this._portletResourceLayoutManagerActions.put(name, (List<String>)layoutManagerActions);
                    this._checkPortletLayoutManagerActions((List<String>)layoutManagerActions);
                }
            }
        }
        return actions;
    }

    private List<String> _getPortletResourceCommunityDefaultActions(String name) {
        name = PortletConstants.getRootPortletId((String)name);
        return this._getActions(this._portletResourceCommunityDefaultActions, name);
    }

    private List<String> _getPortletResourceGuestDefaultActions(String name) {
        name = PortletConstants.getRootPortletId((String)name);
        return this._getActions(this._portletResourceGuestDefaultActions, name);
    }

    private List<String> _getPortletResourceGuestUnsupportedActions(String name) {
        name = PortletConstants.getRootPortletId((String)name);
        return this._getActions(this._portletResourceGuestUnsupportedActions, name);
    }

    private List<String> _getPortletResourceLayoutManagerActions(String name) {
        List<String> actions = this._getActions(this._portletResourceLayoutManagerActions, name = PortletConstants.getRootPortletId((String)name));
        if (actions.size() < 1) {
            actions.add("CONFIGURATION");
            actions.add("PREFERENCES");
            actions.add("VIEW");
        }
        return actions;
    }

    private SocialEquityActionMapping _getSocialEquityActionMapping(String name, String actionId) {
        Map<String, SocialEquityActionMapping> socialEquityActionMappings = this._socialEquityActionMappings.get(name);
        if (socialEquityActionMappings == null) {
            return null;
        }
        return socialEquityActionMappings.get(actionId);
    }

    private List<SocialEquityActionMapping> _getSocialEquityActionMappings(String name) {
        Map<String, SocialEquityActionMapping> socialEquityActionMappings = this._socialEquityActionMappings.get(name);
        if (socialEquityActionMappings == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<SocialEquityActionMapping> socialEquityActionMappingList = new ArrayList<SocialEquityActionMapping>();
        for (Map.Entry<String, SocialEquityActionMapping> entry : socialEquityActionMappings.entrySet()) {
            socialEquityActionMappingList.add(entry.getValue());
        }
        return socialEquityActionMappingList;
    }

    private String[] _getSocialEquityClassNames() {
        Set<String> classNames = this._socialEquityActionMappings.keySet();
        return classNames.toArray(new String[classNames.size()]);
    }

    private boolean _hasModelResourceActions(String name) {
        List<String> actions = this._modelResourceActions.get(name);
        return actions != null && !actions.isEmpty();
    }

    private void _init() {
    }

    private boolean _isOrganizationModelResource(String modelResource) {
        return this._organizationModelResources.contains(modelResource);
    }

    private boolean _isPortalModelResource(String modelResource) {
        return this._portalModelResources.contains(modelResource);
    }

    private void _read(String servletContextName, ClassLoader classLoader, String source) throws Exception {
        InputStream inputStream = classLoader.getResourceAsStream(source);
        if (inputStream == null) {
            if (_log.isWarnEnabled() && !source.endsWith("-ext.xml")) {
                _log.warn((Object)("Cannot load " + source));
            }
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Loading " + source));
        }
        Document document = SAXReaderUtil.read((InputStream)inputStream);
        Element rootElement = document.getRootElement();
        for (Element resourceElement : rootElement.elements("resource")) {
            String file = resourceElement.attributeValue("file").trim();
            this._read(servletContextName, classLoader, file);
            String extFile = StringUtil.replace((String)file, (String)".xml", (String)"-ext.xml");
            this._read(servletContextName, classLoader, extFile);
        }
        this._read(servletContextName, document);
    }

    private void _read(String servletContextName, Document document) throws Exception {
        Element rootElement = document.getRootElement();
        if (PropsValues.RESOURCE_ACTIONS_READ_PORTLET_RESOURCES) {
            for (Element portletResourceElement : rootElement.elements("portlet-resource")) {
                this._readPortletResource(servletContextName, portletResourceElement);
            }
        }
        for (Element modelResourceElement : rootElement.elements("model-resource")) {
            this._readModelResource(servletContextName, modelResourceElement);
        }
    }

    private void _read(String servletContextName, InputStream inputStream) throws Exception {
        Document document = SAXReaderUtil.read((InputStream)inputStream);
        this._read(servletContextName, document);
    }

    private void _readActionKeys(Element parentElement, List<String> actions) {
        for (Element actionKeyElement : parentElement.elements("action-key")) {
            String actionKey = actionKeyElement.getTextTrim();
            if (Validator.isNull((String)actionKey)) continue;
            actions.add(actionKey);
        }
    }

    private void _readCommunityDefaultActions(Element parentElement, Map<String, List<String>> actionsMap, String name) {
        List<String> communityDefaultActions = this._getActions(actionsMap, name);
        Element communityDefaultsElement = this._getPermissionsChildElement(parentElement, "community-defaults");
        this._readActionKeys(communityDefaultsElement, communityDefaultActions);
    }

    private List<String> _readGuestDefaultActions(Element parentElement, Map<String, List<String>> actionsMap, String name) {
        List<String> guestDefaultActions = this._getActions(actionsMap, name);
        Element guestDefaultsElement = this._getPermissionsChildElement(parentElement, "guest-defaults");
        this._readActionKeys(guestDefaultsElement, guestDefaultActions);
        return guestDefaultActions;
    }

    private void _readGuestUnsupportedActions(Element parentElement, Map<String, List<String>> actionsMap, String name, List<String> guestDefaultActions) {
        List<String> guestUnsupportedActions = this._getActions(actionsMap, name);
        Element guestUnsupportedElement = this._getPermissionsChildElement(parentElement, "guest-unsupported");
        this._readActionKeys(guestUnsupportedElement, guestUnsupportedActions);
        this._checkGuestUnsupportedActions(guestUnsupportedActions, guestDefaultActions);
    }

    private void _readLayoutManagerActions(Element parentElement, Map<String, List<String>> actionsMap, String name, List<String> supportsActions) {
        List<String> layoutManagerActions = this._getActions(actionsMap, name);
        Element layoutManagerElement = this._getPermissionsChildElement(parentElement, "layout-manager");
        if (layoutManagerElement != null) {
            this._readActionKeys(layoutManagerElement, layoutManagerActions);
        } else {
            layoutManagerActions.addAll(supportsActions);
        }
    }

    private void _readModelResource(String servletContextName, Element modelResourceElement) {
        String name = modelResourceElement.elementTextTrim("model-name");
        Element portletRefElement = modelResourceElement.element("portlet-ref");
        for (Element portletNameElement : portletRefElement.elements("portlet-name")) {
            Set<String> modelResources;
            String portletName = portletNameElement.getTextTrim();
            if (servletContextName != null) {
                portletName = portletName.concat("_WAR_").concat(servletContextName);
            }
            if ((modelResources = this._portletModelResources.get(portletName = PortalUtil.getJsSafePortletId((String)portletName))) == null) {
                modelResources = new HashSet<String>();
                this._portletModelResources.put(portletName, modelResources);
            }
            modelResources.add(name);
            Set<String> portletResources = this._modelPortletResources.get(name);
            if (portletResources == null) {
                portletResources = new HashSet<String>();
                this._modelPortletResources.put(name, portletResources);
            }
            portletResources.add(portletName);
        }
        List<String> supportsActions = this._readSupportsActions(modelResourceElement, this._modelResourceActions, name);
        this._checkModelActions(supportsActions);
        this._readCommunityDefaultActions(modelResourceElement, this._modelResourceCommunityDefaultActions, name);
        List<String> guestDefaultActions = this._readGuestDefaultActions(modelResourceElement, this._modelResourceGuestDefaultActions, name);
        this._readGuestUnsupportedActions(modelResourceElement, this._modelResourceGuestUnsupportedActions, name, guestDefaultActions);
        this._readOwnerDefaultActions(modelResourceElement, this._modelResourceOwnerDefaultActions, name);
        this._readSocialEquity(modelResourceElement, name);
    }

    private void _readOwnerDefaultActions(Element parentElement, Map<String, List<String>> actionsMap, String name) {
        List<String> ownerDefaultActions = this._getActions(actionsMap, name);
        Element ownerDefaultsElement = this._getPermissionsChildElement(parentElement, "owner-defaults");
        if (ownerDefaultsElement == null) {
            return;
        }
        this._readActionKeys(ownerDefaultsElement, ownerDefaultActions);
    }

    private void _readPortletResource(String servletContextName, Element portletResourceElement) {
        String name = portletResourceElement.elementTextTrim("portlet-name");
        if (servletContextName != null) {
            name = name.concat("_WAR_").concat(servletContextName);
        }
        name = PortalUtil.getJsSafePortletId((String)name);
        List<String> supportsActions = this._readSupportsActions(portletResourceElement, this._portletResourceActions, name);
        supportsActions.addAll(this._getPortletMimeTypeActions(name));
        if (!name.equals("90")) {
            this._checkPortletActions(supportsActions);
        }
        this._readCommunityDefaultActions(portletResourceElement, this._portletResourceCommunityDefaultActions, name);
        List<String> guestDefaultActions = this._readGuestDefaultActions(portletResourceElement, this._portletResourceGuestDefaultActions, name);
        this._readGuestUnsupportedActions(portletResourceElement, this._portletResourceGuestUnsupportedActions, name, guestDefaultActions);
        this._readLayoutManagerActions(portletResourceElement, this._portletResourceLayoutManagerActions, name, supportsActions);
    }

    private void _readSocialEquity(Element parentElement, String name) {
        Element socialEquityElement = parentElement.element("social-equity");
        if (socialEquityElement == null) {
            return;
        }
        for (Element socialEquityMappingElement : socialEquityElement.elements("social-equity-mapping")) {
            this._readSocialEquityMapping(socialEquityMappingElement, name);
        }
    }

    private void _readSocialEquityMapping(Element socialEquityMappingElement, String name) {
        Element actionKeyElement = socialEquityMappingElement.element("action-key");
        if (actionKeyElement == null) {
            return;
        }
        String actionKey = actionKeyElement.getTextTrim();
        if (Validator.isNull((String)actionKey)) {
            return;
        }
        int informationDailyLimit = GetterUtil.getInteger((String)socialEquityMappingElement.elementText("information-daily-limit"));
        int informationLifespan = GetterUtil.getInteger((String)socialEquityMappingElement.elementText("information-lifespan"));
        int informationValue = GetterUtil.getInteger((String)socialEquityMappingElement.elementText("information-value"));
        int participationDailyLimit = GetterUtil.getInteger((String)socialEquityMappingElement.elementText("participation-daily-limit"));
        int participationLifespan = GetterUtil.getInteger((String)socialEquityMappingElement.elementText("participation-lifespan"));
        int participationValue = GetterUtil.getInteger((String)socialEquityMappingElement.elementText("participation-value"));
        boolean unique = GetterUtil.getBoolean((String)actionKeyElement.attributeValue("unique"));
        SocialEquityActionMapping socialEquityActionMapping = new SocialEquityActionMapping();
        socialEquityActionMapping.setActionId(actionKey);
        socialEquityActionMapping.setClassName(name);
        socialEquityActionMapping.setInformationDailyLimit(informationDailyLimit);
        socialEquityActionMapping.setInformationLifespan(informationLifespan);
        socialEquityActionMapping.setInformationValue(informationValue);
        socialEquityActionMapping.setParticipationDailyLimit(participationDailyLimit);
        socialEquityActionMapping.setParticipationLifespan(participationLifespan);
        socialEquityActionMapping.setParticipationValue(participationValue);
        socialEquityActionMapping.setUnique(unique);
        Map<String, SocialEquityActionMapping> socialEquityActionMappings = this._socialEquityActionMappings.get(name);
        if (socialEquityActionMappings == null) {
            socialEquityActionMappings = new HashMap<String, SocialEquityActionMapping>();
            this._socialEquityActionMappings.put(name, socialEquityActionMappings);
        }
        socialEquityActionMappings.put(actionKey, socialEquityActionMapping);
    }

    private List<String> _readSupportsActions(Element parentElement, Map<String, List<String>> actionsMap, String name) {
        List<String> supportsActions = this._getActions(actionsMap, name);
        Element supportsElement = this._getPermissionsChildElement(parentElement, "supports");
        this._readActionKeys(supportsElement, supportsActions);
        return supportsActions;
    }
}

