/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.InlineSQLHelper;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.dao.orm.CustomSQLUtil;

public class InlineSQLHelperImpl
implements InlineSQLHelper {
    public static final String JOIN_RESOURCE_PERMISSION = String.valueOf(InlineSQLHelper.class.getName()) + ".joinResourcePermission";
    private static final String _ORDER_BY_CLAUSE = " ORDER BY ";
    private static final String _WHERE_CLAUSE = " WHERE ";

    public boolean isEnabled() {
        return this.isEnabled(0L);
    }

    public boolean isEnabled(long groupId) {
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM != 6) {
            return false;
        }
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker == null) {
            return false;
        }
        return !(groupId > 0L ? permissionChecker.isCommunityAdmin(groupId) || permissionChecker.isCommunityOwner(groupId) : permissionChecker.isCompanyAdmin());
    }

    public boolean isEnabled(long[] groupIds) {
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM != 6) {
            return false;
        }
        long[] lArray = groupIds;
        int n = groupIds.length;
        int n2 = 0;
        while (n2 < n) {
            long groupId = lArray[n2];
            if (!this.isEnabled(groupId)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, String userIdField) {
        return this.replacePermissionCheck(sql, className, classPKField, userIdField, new long[1], null);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, String userIdField, long groupId) {
        return this.replacePermissionCheck(sql, className, classPKField, userIdField, new long[]{groupId}, null);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, String userIdField, long groupId, String bridgeJoin) {
        return this.replacePermissionCheck(sql, className, classPKField, userIdField, new long[]{groupId}, bridgeJoin);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, String userIdField, long[] groupIds) {
        return this.replacePermissionCheck(sql, className, classPKField, userIdField, groupIds, null);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, String userIdField, long[] groupIds, String bridgeJoin) {
        if (!this.isEnabled(groupIds)) {
            return sql;
        }
        if (Validator.isNull((String)className)) {
            throw new IllegalArgumentException("className is null");
        }
        if (Validator.isNull((String)classPKField)) {
            throw new IllegalArgumentException("classPKField is null");
        }
        if (Validator.isNull((String)sql)) {
            return sql;
        }
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        String permissionJoin = "";
        if (Validator.isNotNull((String)bridgeJoin)) {
            permissionJoin = bridgeJoin;
        }
        permissionJoin = String.valueOf(permissionJoin) + CustomSQLUtil.get((String)JOIN_RESOURCE_PERMISSION);
        StringBundler ownerSQL = new StringBundler(5);
        if (Validator.isNotNull((String)userIdField)) {
            ownerSQL.append("(");
            ownerSQL.append(userIdField);
            ownerSQL.append(" = ");
            ownerSQL.append(String.valueOf(this.getUserId()));
            ownerSQL.append(") OR ");
        }
        permissionJoin = StringUtil.replace((String)permissionJoin, (String[])new String[]{"[$CLASS_NAME$]", "[$CLASS_PK_FIELD$]", "[$COMPANY_ID$]", "[$GROUP_IDS$]", "[$OWNER_CHECK$]", "[$ROLE_IDS$]"}, (String[])new String[]{className, classPKField, String.valueOf(permissionChecker.getCompanyId()), StringUtil.merge((long[])groupIds, (String)"','"), ownerSQL.toString(), StringUtil.merge((long[])this.getRoleIds(groupIds))});
        int pos = sql.indexOf(_WHERE_CLAUSE);
        if (pos != -1) {
            return sql.substring(0, pos + 1).concat(permissionJoin).concat(sql.substring(pos + 1));
        }
        pos = sql.indexOf(_ORDER_BY_CLAUSE);
        if (pos != -1) {
            return sql.substring(0, pos + 1).concat(permissionJoin).concat(sql.substring(pos + 1));
        }
        return sql.concat(" ").concat(permissionJoin);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, String userIdField, String bridgeJoin) {
        return this.replacePermissionCheck(sql, className, classPKField, userIdField, 0L, bridgeJoin);
    }

    protected long[] getRoleIds(long groupId) {
        long[] roleIds = PermissionChecker.DEFAULT_ROLE_IDS;
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker != null) {
            roleIds = permissionChecker.getRoleIds(permissionChecker.getUserId(), groupId);
        }
        return roleIds;
    }

    protected long[] getRoleIds(long[] groupIds) {
        long[] roleIds = PermissionChecker.DEFAULT_ROLE_IDS;
        long[] lArray = groupIds;
        int n = groupIds.length;
        int n2 = 0;
        while (n2 < n) {
            long groupId = lArray[n2];
            long[] lArray2 = this.getRoleIds(groupId);
            int n3 = lArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                long roleId = lArray2[n4];
                if (!ArrayUtil.contains((long[])roleIds, (long)roleId)) {
                    roleIds = ArrayUtil.append((long[])roleIds, (long)roleId);
                }
                ++n4;
            }
            ++n2;
        }
        return roleIds;
    }

    protected long getUserId() {
        long userId = 0L;
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker != null) {
            userId = permissionChecker.getUserId();
        }
        return userId;
    }
}

