/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.AuthToken;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.Encryptor;
import com.liferay.util.PwdGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionAuthToken
implements AuthToken {
    private static final String _PORTAL = "PORTAL";
    private Set<String> _ignoreActions = SetUtil.fromArray((Object[])PropsUtil.getArray("auth.token.ignore.actions"));

    public void check(HttpServletRequest request) throws PrincipalException {
        if (this.isIgnoreAction(request)) {
            return;
        }
        String requestAuthenticationToken = ParamUtil.getString((HttpServletRequest)request, (String)"p_auth");
        String sessionAuthenticationToken = this.getSessionAuthenticationToken(request, _PORTAL);
        String propertiesAuthenticatonTokenSharedSecret = Encryptor.digest((String)PropsValues.AUTH_TOKEN_SHARED_SECRET);
        String requestAuthenticatonTokenSharedSecret = ParamUtil.getString((HttpServletRequest)request, (String)"p_auth_secret");
        if (!requestAuthenticationToken.equals(sessionAuthenticationToken) && !requestAuthenticatonTokenSharedSecret.equals(propertiesAuthenticatonTokenSharedSecret)) {
            throw new PrincipalException("Invalid authentication token");
        }
    }

    public String getToken(HttpServletRequest request) {
        return this.getSessionAuthenticationToken(request, _PORTAL);
    }

    public String getToken(HttpServletRequest request, long plid, String portletId) {
        return this.getSessionAuthenticationToken(request, PortletPermissionUtil.getPrimaryKey((long)plid, (String)portletId));
    }

    protected String getSessionAuthenticationToken(HttpServletRequest request, String key) {
        Map<String, String> sessionAuthenticationTokensMap = this.getSessionAuthenticationTokensMap(request);
        String sessionAuthenticationToken = sessionAuthenticationTokensMap.get(key);
        if (Validator.isNull((String)sessionAuthenticationToken)) {
            sessionAuthenticationToken = PwdGenerator.getPassword();
            sessionAuthenticationTokensMap.put(key, sessionAuthenticationToken);
        }
        return sessionAuthenticationToken;
    }

    protected Map<String, String> getSessionAuthenticationTokensMap(HttpServletRequest request) {
        HttpSession session = request.getSession();
        HashMap sessionAuthenticationTokensMap = (HashMap)session.getAttribute("LIFERAY_SHARED_AUTHENTICATION_TOKEN");
        if (sessionAuthenticationTokensMap == null) {
            sessionAuthenticationTokensMap = new HashMap();
            session.setAttribute("LIFERAY_SHARED_AUTHENTICATION_TOKEN", sessionAuthenticationTokensMap);
        }
        return sessionAuthenticationTokensMap;
    }

    protected boolean isIgnoreAction(HttpServletRequest request) {
        String ppid = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id");
        String portletNamespace = PortalUtil.getPortletNamespace((String)ppid);
        String strutsAction = ParamUtil.getString((HttpServletRequest)request, (String)(String.valueOf(portletNamespace) + "struts_action"));
        return this.isIgnoreAction(strutsAction);
    }

    protected boolean isIgnoreAction(String strutsAction) {
        return this._ignoreActions.contains(strutsAction);
    }
}

