/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scheduler.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.sender.MessageSender;
import com.liferay.portal.kernel.scheduler.SchedulerEngine;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerRequest;
import java.util.List;

public class SchedulerMessageListener
implements MessageListener {
    private static Log _log = LogFactoryUtil.getLog(SchedulerMessageListener.class);
    private MessageSender _messageSender;
    private SchedulerEngine _schedulerEngine;

    public SchedulerMessageListener() {
    }

    public SchedulerMessageListener(MessageSender messageSender, SchedulerEngine schedulerEngine) {
        this._messageSender = messageSender;
        this._schedulerEngine = schedulerEngine;
    }

    public void receive(Message message) {
        try {
            this.doReceive(message);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to process message " + message), (Throwable)e);
        }
    }

    public void setMessageSender(MessageSender messageSender) {
        this._messageSender = messageSender;
    }

    public void setSchedulerEngine(SchedulerEngine schedulerEngine) {
        this._schedulerEngine = schedulerEngine;
    }

    protected void doReceive(Message message) throws Exception {
        SchedulerRequest schedulerRequest = (SchedulerRequest)message.getPayload();
        String command = schedulerRequest.getCommand();
        if (command.equals("REGISTER")) {
            this._schedulerEngine.schedule(schedulerRequest.getTrigger(), schedulerRequest.getDescription(), schedulerRequest.getDestination(), schedulerRequest.getMessage());
        } else if (command.equals("RETRIEVE")) {
            this.doCommandRetrieve(message, schedulerRequest);
        } else if (command.equals("SHUTDOWN")) {
            this._schedulerEngine.shutdown();
        } else if (command.equals("STARTUP")) {
            this._schedulerEngine.start();
        } else if (command.equals("UNREGISTER")) {
            this._schedulerEngine.unschedule(schedulerRequest.getTrigger());
        }
    }

    protected void doCommandRetrieve(Message message, SchedulerRequest schedulerRequest) throws Exception {
        List schedulerRequests = this._schedulerEngine.getScheduledJobs(schedulerRequest.getTrigger().getGroupName());
        Message responseMessage = MessageBusUtil.createResponseMessage((Message)message, (Object)schedulerRequests);
        this._messageSender.send(responseMessage.getDestinationName(), responseMessage);
    }
}

