/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.statistics.service;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.monitoring.statistics.DataSampleProcessor;
import com.liferay.portal.monitoring.statistics.service.ServiceRequestDataSample;
import com.liferay.portal.monitoring.statistics.service.ServiceStatistics;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerStatistics
implements DataSampleProcessor<ServiceRequestDataSample> {
    private Map<String, ServiceStatistics> _serviceStatistics = new ConcurrentHashMap<String, ServiceStatistics>();

    public long getAverageTime(String className, String methodName, String[] parameterTypes) throws SystemException {
        ServiceStatistics serviceStatistics = this._serviceStatistics.get(className);
        if (serviceStatistics != null) {
            return serviceStatistics.getAverageTime(methodName, parameterTypes);
        }
        return -1L;
    }

    public long getErrorCount(String className, String methodName, String[] parameterTypes) throws SystemException {
        ServiceStatistics serviceStatistics = this._serviceStatistics.get(className);
        if (serviceStatistics != null) {
            return serviceStatistics.getErrorCount(methodName, parameterTypes);
        }
        return -1L;
    }

    public long getMaxTime(String className, String methodName, String[] parameterTypes) throws SystemException {
        ServiceStatistics serviceStatistics = this._serviceStatistics.get(className);
        if (serviceStatistics != null) {
            return serviceStatistics.getMaxTime(methodName, parameterTypes);
        }
        return -1L;
    }

    public long getMinTime(String className, String methodName, String[] parameterTypes) throws SystemException {
        ServiceStatistics serviceStatistics = this._serviceStatistics.get(className);
        if (serviceStatistics != null) {
            return serviceStatistics.getMinTime(methodName, parameterTypes);
        }
        return -1L;
    }

    public long getRequestCount(String className, String methodName, String[] parameterTypes) throws SystemException {
        ServiceStatistics serviceStatistics = this._serviceStatistics.get(className);
        if (serviceStatistics != null) {
            return serviceStatistics.getRequestCount(methodName, parameterTypes);
        }
        return -1L;
    }

    @Override
    public void processDataSample(ServiceRequestDataSample serviceRequestDataSample) {
        MethodKey methodKey = serviceRequestDataSample.getMethodKey();
        String className = methodKey.getClassName();
        ServiceStatistics serviceStatistics = this._serviceStatistics.get(className);
        if (serviceStatistics == null) {
            serviceStatistics = new ServiceStatistics(className);
            this._serviceStatistics.put(className, serviceStatistics);
        }
        serviceStatistics.processDataSample(serviceRequestDataSample);
    }
}

