/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Namespace;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.WebDAVProps;
import com.liferay.portal.model.impl.WebDAVPropsModelImpl;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDAVPropsImpl
extends WebDAVPropsModelImpl
implements WebDAVProps {
    private static final String _PROPS = "<properties />";
    private Document _document = null;

    @Override
    public String getProps() {
        String props = super.getProps();
        if (Validator.isNull((String)props)) {
            return _PROPS;
        }
        return props;
    }

    public Set<Tuple> getPropsSet() throws Exception {
        HashSet<Tuple> propsSet = new HashSet<Tuple>();
        Document doc = this._getPropsDocument();
        Element root = doc.getRootElement();
        for (Element el : root.elements()) {
            String prefix = el.getNamespacePrefix();
            String uri = el.getNamespaceURI();
            Namespace namespace = null;
            namespace = uri.equals(WebDAVUtil.DAV_URI.getURI()) ? WebDAVUtil.DAV_URI : (Validator.isNull((String)prefix) ? SAXReaderUtil.createNamespace((String)uri) : SAXReaderUtil.createNamespace((String)prefix, (String)uri));
            propsSet.add(new Tuple(new Object[]{el.getName(), namespace}));
        }
        return propsSet;
    }

    public String getText(String name, String prefix, String uri) throws Exception {
        Namespace namespace = null;
        namespace = Validator.isNull((String)prefix) ? SAXReaderUtil.createNamespace((String)uri) : SAXReaderUtil.createNamespace((String)prefix, (String)uri);
        QName qname = SAXReaderUtil.createQName((String)name, (Namespace)namespace);
        Document doc = this._getPropsDocument();
        Element root = doc.getRootElement();
        Element prop = root.element(qname);
        return prop.getText();
    }

    public void addProp(String name, String prefix, String uri) throws Exception {
        Namespace namespace = null;
        namespace = Validator.isNull((String)prefix) ? SAXReaderUtil.createNamespace((String)uri) : SAXReaderUtil.createNamespace((String)prefix, (String)uri);
        QName qname = SAXReaderUtil.createQName((String)name, (Namespace)namespace);
        Element root = this._removeExisting(qname);
        root.addElement(qname);
    }

    public void addProp(String name, String prefix, String uri, String text) throws Exception {
        Namespace namespace = null;
        namespace = Validator.isNull((String)prefix) ? SAXReaderUtil.createNamespace((String)uri) : SAXReaderUtil.createNamespace((String)prefix, (String)uri);
        QName qname = SAXReaderUtil.createQName((String)name, (Namespace)namespace);
        Element root = this._removeExisting(qname);
        root.addElement(qname).addText(text);
    }

    public void removeProp(String name, String prefix, String uri) throws Exception {
        Namespace namespace = null;
        namespace = Validator.isNull((String)prefix) ? SAXReaderUtil.createNamespace((String)uri) : SAXReaderUtil.createNamespace((String)prefix, (String)uri);
        QName qname = SAXReaderUtil.createQName((String)name, (Namespace)namespace);
        this._removeExisting(qname);
    }

    public void store() throws Exception {
        if (this._document != null) {
            String xml = this._document.formattedString("    ");
            this.setProps(xml);
            this._document = null;
        }
    }

    private Document _getPropsDocument() throws DocumentException {
        if (this._document == null) {
            this._document = SAXReaderUtil.read((String)this.getProps());
        }
        return this._document;
    }

    private Element _removeExisting(QName qname) throws Exception {
        Document doc = this._getPropsDocument();
        Element root = doc.getRootElement();
        for (Element el : root.elements(qname)) {
            root.remove(el);
        }
        return root;
    }
}

