/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.ColorScheme;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.Theme;
import com.liferay.portal.model.impl.LayoutSetModelImpl;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ThemeLocalServiceUtil;
import java.io.IOException;

public class LayoutSetImpl
extends LayoutSetModelImpl
implements LayoutSet {
    private static Log _log = LogFactoryUtil.getLog(LayoutSetImpl.class);
    private UnicodeProperties _settingsProperties;

    public Theme getTheme() throws SystemException {
        return ThemeLocalServiceUtil.getTheme((long)this.getCompanyId(), (String)this.getThemeId(), (boolean)false);
    }

    public ColorScheme getColorScheme() throws SystemException {
        return ThemeLocalServiceUtil.getColorScheme((long)this.getCompanyId(), (String)this.getTheme().getThemeId(), (String)this.getColorSchemeId(), (boolean)false);
    }

    public Group getGroup() throws PortalException, SystemException {
        return GroupLocalServiceUtil.getGroup((long)this.getGroupId());
    }

    public String getSettings() {
        if (this._settingsProperties == null) {
            return super.getSettings();
        }
        return this._settingsProperties.toString();
    }

    public UnicodeProperties getSettingsProperties() {
        if (this._settingsProperties == null) {
            this._settingsProperties = new UnicodeProperties(true);
            try {
                this._settingsProperties.load(super.getSettings());
            }
            catch (IOException ioe) {
                _log.error((Object)ioe, (Throwable)ioe);
            }
        }
        return this._settingsProperties;
    }

    public String getSettingsProperty(String key) {
        UnicodeProperties settingsProperties = this.getSettingsProperties();
        return settingsProperties.getProperty(key);
    }

    public Theme getWapTheme() throws SystemException {
        return ThemeLocalServiceUtil.getTheme((long)this.getCompanyId(), (String)this.getWapThemeId(), (boolean)true);
    }

    public ColorScheme getWapColorScheme() throws SystemException {
        return ThemeLocalServiceUtil.getColorScheme((long)this.getCompanyId(), (String)this.getWapTheme().getThemeId(), (String)this.getWapColorSchemeId(), (boolean)true);
    }

    public void setSettings(String settings) {
        this._settingsProperties = null;
        super.setSettings(settings);
    }

    public void setSettingsProperties(UnicodeProperties settingsProperties) {
        this._settingsProperties = settingsProperties;
        super.setSettings(this._settingsProperties.toString());
    }
}

