/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.liveusers.messaging;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.liveusers.LiveUsers;

public class LiveUsersMessageListener
implements MessageListener {
    private static Log _log = LogFactoryUtil.getLog(LiveUsersMessageListener.class);

    public void receive(Message message) {
        try {
            this.doReceive(message);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to process message " + message), (Throwable)e);
        }
    }

    protected void doCommandSignIn(JSONObject jsonObject) throws Exception {
        long companyId = jsonObject.getLong("companyId");
        long userId = jsonObject.getLong("userId");
        String sessionId = jsonObject.getString("sessionId");
        String remoteAddr = jsonObject.getString("remoteAddr");
        String remoteHost = jsonObject.getString("remoteHost");
        String userAgent = jsonObject.getString("userAgent");
        LiveUsers.signIn(companyId, userId, sessionId, remoteAddr, remoteHost, userAgent);
    }

    protected void doCommandSignOut(JSONObject jsonObject) throws Exception {
        long companyId = jsonObject.getLong("companyId");
        long userId = jsonObject.getLong("userId");
        String sessionId = jsonObject.getString("sessionId");
        LiveUsers.signOut(companyId, userId, sessionId);
    }

    protected void doReceive(Message message) throws Exception {
        String payload = (String)message.getPayload();
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)payload);
        String command = jsonObject.getString("command");
        if (command.equals("signIn")) {
            this.doCommandSignIn(jsonObject);
        } else if (command.equals("signOut")) {
            this.doCommandSignOut(jsonObject);
        }
    }
}

