/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.LARFileException;
import com.liferay.portal.LARTypeException;
import com.liferay.portal.LayoutImportException;
import com.liferay.portal.PortletIdException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandler;
import com.liferay.portal.kernel.lar.UserIdStrategy;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipReaderFactoryUtil;
import com.liferay.portal.lar.AlwaysCurrentUserIdStrategy;
import com.liferay.portal.lar.CurrentUserIdStrategy;
import com.liferay.portal.lar.PermissionImporter;
import com.liferay.portal.lar.PortletDataContextImpl;
import com.liferay.portal.lar.PortletDataContextListenerImpl;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Lock;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.PortletItem;
import com.liferay.portal.model.User;
import com.liferay.portal.model.impl.PortletPreferencesImpl;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.PortletItemLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.persistence.PortletPreferencesUtil;
import com.liferay.portal.service.persistence.UserUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.PortletPreferencesSerializer;
import com.liferay.portlet.asset.NoSuchCategoryException;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetVocabularyLocalServiceUtil;
import com.liferay.portlet.asset.service.persistence.AssetCategoryUtil;
import com.liferay.portlet.asset.service.persistence.AssetVocabularyUtil;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.ratings.model.RatingsEntry;
import com.liferay.portlet.social.util.SocialActivityThreadLocal;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;
import org.apache.commons.lang.time.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletImporter {
    private static Log _log = LogFactoryUtil.getLog(PortletImporter.class);
    private PermissionImporter _permissionImporter = new PermissionImporter();

    public void importPortletInfo(long userId, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, File file) throws PortalException, SystemException {
        boolean deletePortletData = MapUtil.getBoolean(parameterMap, (String)"DELETE_PORTLET_DATA");
        boolean importPermissions = MapUtil.getBoolean(parameterMap, (String)"PERMISSIONS");
        boolean importPortletData = MapUtil.getBoolean(parameterMap, (String)"PORTLET_DATA");
        boolean importPortletArchivedSetups = MapUtil.getBoolean(parameterMap, (String)"PORTLET_ARCHIVED_SETUPS");
        boolean importPortletSetup = MapUtil.getBoolean(parameterMap, (String)"PORTLET_SETUP");
        boolean importUserPreferences = MapUtil.getBoolean(parameterMap, (String)"PORTLET_USER_PREFERENCES");
        String userIdStrategy = MapUtil.getString(parameterMap, (String)"USER_ID_STRATEGY");
        StopWatch stopWatch = null;
        if (_log.isInfoEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        long companyId = layout.getCompanyId();
        User user = UserUtil.findByPrimaryKey((long)userId);
        UserIdStrategy strategy = this.getUserIdStrategy(user, userIdStrategy);
        ZipReader zipReader = ZipReaderFactoryUtil.getZipReader((File)file);
        PortletDataContextImpl context = new PortletDataContextImpl(companyId, groupId, parameterMap, new HashSet<String>(), strategy, zipReader);
        context.setPortetDataContextListener(new PortletDataContextListenerImpl(context));
        context.setPlid(plid);
        context.setPrivateLayout(layout.isPrivateLayout());
        Element root = null;
        String xml = context.getZipEntryAsString("/manifest.xml");
        try {
            Document doc = SAXReaderUtil.read((String)xml);
            root = doc.getRootElement();
        }
        catch (Exception exception) {
            throw new LARFileException("Cannot locate a manifest in this LAR file.");
        }
        Element header = root.element("header");
        int buildNumber = ReleaseInfo.getBuildNumber();
        int importBuildNumber = GetterUtil.getInteger((String)header.attributeValue("build-number"));
        if (buildNumber != importBuildNumber) {
            throw new LayoutImportException("LAR build number " + importBuildNumber + " does not match " + "portal build number " + buildNumber);
        }
        String type = header.attributeValue("type");
        if (!type.equals("portlet")) {
            throw new LARTypeException("Invalid type of LAR file (" + type + ")");
        }
        String rootPortletId = header.attributeValue("root-portlet-id");
        if (!PortletConstants.getRootPortletId((String)portletId).equals(rootPortletId)) {
            throw new PortletIdException("Invalid portlet id " + rootPortletId);
        }
        long sourceGroupId = GetterUtil.getLong((String)header.attributeValue("group-id"));
        context.setSourceGroupId(sourceGroupId);
        if (importPermissions) {
            this._permissionImporter.readPortletDataPermissions(context);
        }
        this.readCategories(context);
        this.readComments(context, root);
        this.readLocks(context, root);
        this.readRatings(context, root);
        this.readTags(context, root);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Deleting portlet data");
        }
        if (deletePortletData) {
            this.deletePortletData((PortletDataContext)context, portletId, plid);
        }
        Element portletRefEl = root.element("portlet");
        Element portletEl = null;
        try {
            Document portletDoc = SAXReaderUtil.read((String)context.getZipEntryAsString(portletRefEl.attributeValue("path")));
            portletEl = portletDoc.getRootElement();
        }
        catch (DocumentException de) {
            throw new SystemException((Throwable)de);
        }
        this.importPortletPreferences(context, layout.getCompanyId(), groupId, layout, portletId, portletEl, importPortletSetup, importPortletArchivedSetups, importUserPreferences, true);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Importing portlet data");
        }
        if (importPortletData) {
            Element portletDataRefEl = portletEl.element("portlet-data");
            if (portletDataRefEl != null) {
                this.importPortletData((PortletDataContext)context, portletId, plid, portletDataRefEl);
            } else if (_log.isWarnEnabled()) {
                _log.warn((Object)"Could not import portlet data because it cannot be found in the input");
            }
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Importing portlet data takes " + stopWatch.getTime() + " ms"));
        }
        zipReader.close();
    }

    protected void deletePortletData(PortletDataContext context, String portletId, long plid) throws SystemException {
        String xml;
        long ownerId = 0L;
        int ownerType = 3;
        com.liferay.portal.model.PortletPreferences portletPreferences = PortletPreferencesUtil.fetchByO_O_P_P((long)ownerId, (int)ownerType, (long)plid, (String)portletId);
        if (portletPreferences == null) {
            portletPreferences = new PortletPreferencesImpl();
        }
        if ((xml = this.deletePortletData(context, portletId, portletPreferences)) != null) {
            PortletPreferencesLocalServiceUtil.updatePreferences((long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        }
    }

    protected String deletePortletData(PortletDataContext context, String portletId, com.liferay.portal.model.PortletPreferences portletPreferences) throws SystemException {
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)context.getCompanyId(), (String)portletId);
        if (portlet == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Do not delete portlet data for " + portletId + " because the portlet does not exist"));
            }
            return null;
        }
        PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
        if (portletDataHandler == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Do not delete portlet data for " + portletId + " because the portlet does not have a " + "PortletDataHandler"));
            }
            return null;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Deleting data for " + portletId));
        }
        com.liferay.portlet.PortletPreferencesImpl preferencesImpl = (com.liferay.portlet.PortletPreferencesImpl)PortletPreferencesSerializer.fromDefaultXML(portletPreferences.getPreferences());
        try {
            try {
                preferencesImpl = (com.liferay.portlet.PortletPreferencesImpl)portletDataHandler.deleteData(context, portletId, (PortletPreferences)preferencesImpl);
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        }
        finally {
            context.setGroupId(context.getScopeGroupId());
        }
        if (preferencesImpl == null) {
            return null;
        }
        return PortletPreferencesSerializer.toXML(preferencesImpl);
    }

    protected String getCategoryPath(PortletDataContext context, long categoryId) {
        StringBundler sb = new StringBundler(6);
        sb.append(context.getSourceRootPath());
        sb.append("/categories/");
        sb.append(categoryId);
        sb.append(".xml");
        return sb.toString();
    }

    protected UserIdStrategy getUserIdStrategy(User user, String userIdStrategy) {
        if ("ALWAYS_CURRENT_USER_ID".equals(userIdStrategy)) {
            return new AlwaysCurrentUserIdStrategy(user);
        }
        return new CurrentUserIdStrategy(user);
    }

    protected void importCategory(PortletDataContext context, Map<Long, Long> vocabularyPKs, Map<Long, Long> categoryPKs, Element categoryEl, AssetCategory category) throws Exception {
        long userId = context.getUserId(category.getUserUuid());
        long vocabularyId = MapUtil.getLong(vocabularyPKs, (long)category.getVocabularyId(), (long)category.getVocabularyId());
        long parentCategoryId = MapUtil.getLong(categoryPKs, (long)category.getParentCategoryId(), (long)category.getParentCategoryId());
        if (parentCategoryId != 0L && parentCategoryId == category.getParentCategoryId()) {
            String path = this.getCategoryPath(context, parentCategoryId);
            AssetCategory parentCategory = (AssetCategory)context.getZipEntryAsObject(path);
            Node parentCategoryNode = categoryEl.getParent().selectSingleNode("./category[@path='" + path + "']");
            if (parentCategoryNode != null) {
                this.importCategory(context, vocabularyPKs, categoryPKs, (Element)parentCategoryNode, parentCategory);
                parentCategoryId = MapUtil.getLong(categoryPKs, (long)category.getParentCategoryId(), (long)category.getParentCategoryId());
            }
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setCreateDate(category.getCreateDate());
        serviceContext.setModifiedDate(category.getModifiedDate());
        serviceContext.setScopeGroupId(context.getScopeGroupId());
        AssetCategory importedCategory = null;
        try {
            if (parentCategoryId != 0L) {
                AssetCategoryUtil.findByPrimaryKey((long)parentCategoryId);
            }
            List propertyEls = categoryEl.elements("property");
            String[] properties = new String[propertyEls.size()];
            int i = 0;
            while (i < properties.length) {
                Element propertyEl = (Element)propertyEls.get(i);
                String key = propertyEl.attributeValue("key");
                String value = propertyEl.attributeValue("value");
                properties[i] = key.concat(":").concat(value);
                ++i;
            }
            AssetCategory existingCategory = AssetCategoryUtil.fetchByP_N_V((long)parentCategoryId, (String)category.getName(), (long)vocabularyId);
            if (existingCategory == null) {
                serviceContext.setUuid(category.getUuid());
                importedCategory = AssetCategoryLocalServiceUtil.addCategory((long)userId, (long)parentCategoryId, (Map)category.getTitleMap(), (long)vocabularyId, (String[])properties, (ServiceContext)serviceContext);
            } else {
                importedCategory = AssetCategoryLocalServiceUtil.updateCategory((long)userId, (long)existingCategory.getCategoryId(), (long)parentCategoryId, (Map)category.getTitleMap(), (long)vocabularyId, (String[])properties, (ServiceContext)serviceContext);
            }
            categoryPKs.put(category.getCategoryId(), importedCategory.getCategoryId());
            context.importPermissions(AssetCategory.class, category.getCategoryId(), importedCategory.getCategoryId());
        }
        catch (NoSuchCategoryException noSuchCategoryException) {
            _log.error((Object)("Could not find the parent category for category " + category.getCategoryId()));
        }
    }

    protected void importVocabulary(PortletDataContext context, Map<Long, Long> vocabularyPKs, Element vocabularyEl, AssetVocabulary vocabulary) throws Exception {
        long userId = context.getUserId(vocabulary.getUserUuid());
        long groupId = context.getScopeGroupId();
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setCreateDate(vocabulary.getCreateDate());
        serviceContext.setModifiedDate(vocabulary.getModifiedDate());
        serviceContext.setScopeGroupId(context.getScopeGroupId());
        AssetVocabulary importedVocabulary = null;
        AssetVocabulary existingVocabulary = AssetVocabularyUtil.fetchByG_N((long)groupId, (String)vocabulary.getName());
        if (existingVocabulary == null) {
            serviceContext.setUuid(vocabulary.getUuid());
            importedVocabulary = AssetVocabularyLocalServiceUtil.addVocabulary((long)userId, (Map)vocabulary.getTitleMap(), (Map)vocabulary.getDescriptionMap(), (String)vocabulary.getSettings(), (ServiceContext)serviceContext);
        } else {
            importedVocabulary = AssetVocabularyLocalServiceUtil.updateVocabulary((long)existingVocabulary.getVocabularyId(), (Map)vocabulary.getTitleMap(), (Map)vocabulary.getDescriptionMap(), (String)vocabulary.getSettings(), (ServiceContext)serviceContext);
        }
        vocabularyPKs.put(vocabulary.getVocabularyId(), importedVocabulary.getVocabularyId());
        context.importPermissions(AssetVocabulary.class, vocabulary.getVocabularyId(), importedVocabulary.getVocabularyId());
    }

    protected void importPortletData(PortletDataContext context, String portletId, long plid, Element portletDataRefEl) throws SystemException {
        String xml;
        long ownerId = 0L;
        int ownerType = 3;
        com.liferay.portal.model.PortletPreferences portletPreferences = PortletPreferencesUtil.fetchByO_O_P_P((long)ownerId, (int)ownerType, (long)plid, (String)portletId);
        if (portletPreferences == null) {
            portletPreferences = new PortletPreferencesImpl();
        }
        if ((xml = this.importPortletData(context, portletId, portletPreferences, portletDataRefEl)) != null) {
            PortletPreferencesLocalServiceUtil.updatePreferences((long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        }
    }

    protected String importPortletData(PortletDataContext context, String portletId, com.liferay.portal.model.PortletPreferences portletPreferences, Element portletDataRefEl) throws SystemException {
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)context.getCompanyId(), (String)portletId);
        if (portlet == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Do not import portlet data for " + portletId + " because the portlet does not exist"));
            }
            return null;
        }
        PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
        if (portletDataHandler == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Do not import portlet data for " + portletId + " because the portlet does not have a " + "PortletDataHandler"));
            }
            return null;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Importing data for " + portletId));
        }
        long groupId = context.getGroupId();
        String scopeLayoutUuid = context.getScopeLayoutUuid();
        if (Validator.isNull((String)scopeLayoutUuid)) {
            scopeLayoutUuid = GetterUtil.getString((String)portletDataRefEl.getParent().attributeValue("scope-layout-uuid"));
        }
        if (Validator.isNotNull((String)scopeLayoutUuid)) {
            try {
                Layout scopeLayout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId((String)scopeLayoutUuid, (long)groupId);
                Group scopeGroup = null;
                if (scopeLayout.hasScopeGroup()) {
                    scopeGroup = scopeLayout.getScopeGroup();
                } else {
                    String name = String.valueOf(scopeLayout.getPlid());
                    scopeGroup = GroupLocalServiceUtil.addGroup((long)context.getUserId(null), (String)Layout.class.getName(), (long)scopeLayout.getPlid(), (String)name, null, (int)0, null, (boolean)true, null);
                }
                context.setScopeGroupId(scopeGroup.getGroupId());
            }
            catch (PortalException portalException) {}
        }
        com.liferay.portlet.PortletPreferencesImpl preferencesImpl = null;
        if (portletPreferences != null) {
            preferencesImpl = (com.liferay.portlet.PortletPreferencesImpl)PortletPreferencesSerializer.fromDefaultXML(portletPreferences.getPreferences());
        }
        String portletData = context.getZipEntryAsString(portletDataRefEl.attributeValue("path"));
        try {
            try {
                SocialActivityThreadLocal.setEnabled(false);
                WorkflowThreadLocal.setEnabled((boolean)false);
                preferencesImpl = (com.liferay.portlet.PortletPreferencesImpl)portletDataHandler.importData(context, portletId, (PortletPreferences)preferencesImpl, portletData);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
                throw new SystemException((Throwable)e);
            }
        }
        finally {
            context.setScopeGroupId(groupId);
            SocialActivityThreadLocal.setEnabled(true);
            WorkflowThreadLocal.setEnabled((boolean)true);
        }
        if (preferencesImpl == null) {
            return null;
        }
        return PortletPreferencesSerializer.toXML(preferencesImpl);
    }

    protected void importPortletPreferences(PortletDataContext context, long companyId, long groupId, Layout layout, String portletId, Element parentEl, boolean importPortletSetup, boolean importPortletArchivedSetups, boolean importUserPreferences, boolean preserveScopeLayoutId) throws PortalException, SystemException {
        long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
        long plid = 0L;
        String scopeLayoutUuid = "";
        if (layout != null) {
            plid = layout.getPlid();
            if (preserveScopeLayoutId && portletId != null) {
                PortletPreferences jxPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletId);
                scopeLayoutUuid = GetterUtil.getString((String)jxPreferences.getValue("lfr-scope-layout-uuid", null));
                context.setScopeLayoutUuid(scopeLayoutUuid);
            }
        }
        List preferencesEls = parentEl.elements("portlet-preferences");
        for (Element preferencesEl : preferencesEls) {
            String path = preferencesEl.attributeValue("path");
            if (!context.isPathNotProcessed(path)) continue;
            Element el = null;
            String xml = null;
            try {
                xml = context.getZipEntryAsString(path);
                Document preferencesDoc = SAXReaderUtil.read((String)xml);
                el = preferencesDoc.getRootElement();
            }
            catch (DocumentException de) {
                throw new SystemException((Throwable)de);
            }
            long ownerId = GetterUtil.getLong((String)el.attributeValue("owner-id"));
            int ownerType = GetterUtil.getInteger((String)el.attributeValue("owner-type"));
            if (ownerType == 1 || (ownerType == 2 || ownerType == 3) && !importPortletSetup || ownerType == 5 && !importPortletArchivedSetups || ownerType == 4 && ownerId != 0L && !importUserPreferences) continue;
            if (ownerType == 2) {
                plid = 0L;
                ownerId = context.getGroupId();
            }
            boolean defaultUser = GetterUtil.getBoolean((String)el.attributeValue("default-user"));
            if (portletId == null) {
                portletId = el.attributeValue("portlet-id");
            }
            if (ownerType == 5) {
                portletId = PortletConstants.getRootPortletId((String)portletId);
                String userUuid = el.attributeValue("archive-user-uuid");
                String name = el.attributeValue("archive-name");
                long userId = context.getUserId(userUuid);
                PortletItem portletItem = PortletItemLocalServiceUtil.updatePortletItem((long)userId, (long)groupId, (String)name, (String)portletId, (String)com.liferay.portal.model.PortletPreferences.class.getName());
                plid = 0L;
                ownerId = portletItem.getPortletItemId();
            }
            if (defaultUser) {
                ownerId = defaultUserId;
            }
            PortletPreferencesLocalServiceUtil.updatePreferences((long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        }
        if (preserveScopeLayoutId && layout != null) {
            PortletPreferences jxPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletId);
            try {
                try {
                    jxPreferences.setValue("lfr-scope-layout-uuid", scopeLayoutUuid);
                    jxPreferences.store();
                }
                catch (Exception e) {
                    throw new PortalException((Throwable)e);
                }
            }
            finally {
                context.setScopeLayoutUuid(scopeLayoutUuid);
            }
        }
    }

    protected void readComments(PortletDataContext context, Element parentEl) throws SystemException {
        try {
            String xml = context.getZipEntryAsString(String.valueOf(context.getSourceRootPath()) + "/comments.xml");
            if (xml == null) {
                return;
            }
            Document doc = SAXReaderUtil.read((String)xml);
            Element root = doc.getRootElement();
            List assets = root.elements("asset");
            for (Element asset : assets) {
                String path = asset.attributeValue("path");
                String className = asset.attributeValue("class-name");
                long classPK = GetterUtil.getLong((String)asset.attributeValue("class-pk"));
                List zipFolderEntries = context.getZipFolderEntries(path);
                ArrayList<MBMessage> messages = new ArrayList<MBMessage>();
                for (String zipFolderEntry : zipFolderEntries) {
                    MBMessage message = (MBMessage)context.getZipEntryAsObject(zipFolderEntry);
                    if (message == null) continue;
                    messages.add(message);
                }
                context.addComments(className, classPK, messages);
            }
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    protected void readLocks(PortletDataContext context, Element parentEl) throws SystemException {
        try {
            String xml = context.getZipEntryAsString(String.valueOf(context.getSourceRootPath()) + "/locks.xml");
            if (xml == null) {
                return;
            }
            Document doc = SAXReaderUtil.read((String)xml);
            Element root = doc.getRootElement();
            List assets = root.elements("asset");
            for (Element asset : assets) {
                String className = asset.attributeValue("class-name");
                String key = asset.attributeValue("key");
                String path = asset.attributeValue("path");
                Lock lock = (Lock)context.getZipEntryAsObject(path);
                if (lock == null) continue;
                context.addLocks(className, key, lock);
            }
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    protected void readRatings(PortletDataContext context, Element parentEl) throws SystemException {
        try {
            String xml = context.getZipEntryAsString(String.valueOf(context.getSourceRootPath()) + "/ratings.xml");
            if (xml == null) {
                return;
            }
            Document doc = SAXReaderUtil.read((String)xml);
            Element root = doc.getRootElement();
            List assets = root.elements("asset");
            for (Element asset : assets) {
                String path = asset.attributeValue("path");
                String className = asset.attributeValue("class-name");
                long classPK = GetterUtil.getLong((String)asset.attributeValue("class-pk"));
                List zipFolderEntries = context.getZipFolderEntries(path);
                ArrayList<RatingsEntry> ratingsEntries = new ArrayList<RatingsEntry>();
                for (String zipFolderEntry : zipFolderEntries) {
                    RatingsEntry ratingsEntry = (RatingsEntry)context.getZipEntryAsObject(zipFolderEntry);
                    if (ratingsEntry == null) continue;
                    ratingsEntries.add(ratingsEntry);
                }
                context.addRatingsEntries(className, classPK, ratingsEntries);
            }
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    protected void readCategories(PortletDataContext context) throws SystemException {
        try {
            String xml = context.getZipEntryAsString(String.valueOf(context.getSourceRootPath()) + "/categories-hierarchy.xml");
            if (xml == null) {
                return;
            }
            Document doc = SAXReaderUtil.read((String)xml);
            Element root = doc.getRootElement();
            List vocabularyEls = root.element("vocabularies").elements("vocabulary");
            Map vocabularyPKs = context.getNewPrimaryKeysMap(AssetVocabulary.class);
            for (Element vocabularyEl : vocabularyEls) {
                String path = vocabularyEl.attributeValue("path");
                if (!context.isPathNotProcessed(path)) continue;
                AssetVocabulary vocabulary = (AssetVocabulary)context.getZipEntryAsObject(path);
                this.importVocabulary(context, vocabularyPKs, vocabularyEl, vocabulary);
            }
            List categoryEls = root.element("categories").elements("category");
            Map categoryPKs = context.getNewPrimaryKeysMap(AssetCategory.class);
            for (Element categoryEl : categoryEls) {
                String path = categoryEl.attributeValue("path");
                if (!context.isPathNotProcessed(path)) continue;
                AssetCategory category = (AssetCategory)context.getZipEntryAsObject(path);
                this.importCategory(context, vocabularyPKs, categoryPKs, categoryEl, category);
            }
            List assets = root.element("assets").elements("asset");
            for (Element asset : assets) {
                String className = GetterUtil.getString((String)asset.attributeValue("class-name"));
                long classPK = GetterUtil.getLong((String)asset.attributeValue("class-pk"));
                String[] assetCategoryUuids = StringUtil.split((String)GetterUtil.getString((String)asset.attributeValue("category-uuids")));
                long[] assetCategoryIds = new long[]{};
                String[] stringArray = assetCategoryUuids;
                int n = assetCategoryUuids.length;
                int n2 = 0;
                while (n2 < n) {
                    String assetCategoryUuid = stringArray[n2];
                    AssetCategory assetCategory = AssetCategoryUtil.fetchByUUID_G((String)assetCategoryUuid, (long)context.getScopeGroupId());
                    if (assetCategory != null) {
                        assetCategoryIds = ArrayUtil.append((long[])assetCategoryIds, (long)assetCategory.getCategoryId());
                    }
                    ++n2;
                }
                context.addAssetCategories(className, classPK, assetCategoryIds);
            }
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    protected void readTags(PortletDataContext context, Element parentEl) throws SystemException {
        try {
            String xml = context.getZipEntryAsString(String.valueOf(context.getSourceRootPath()) + "/tags.xml");
            if (xml == null) {
                return;
            }
            Document doc = SAXReaderUtil.read((String)xml);
            Element root = doc.getRootElement();
            List assets = root.elements("asset");
            for (Element asset : assets) {
                String className = GetterUtil.getString((String)asset.attributeValue("class-name"));
                long classPK = GetterUtil.getLong((String)asset.attributeValue("class-pk"));
                String assetTagNames = GetterUtil.getString((String)asset.attributeValue("tags"));
                context.addAssetTags(className, classPK, StringUtil.split((String)assetTagNames));
            }
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }
}

