/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.lar.LayoutCache;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.Resource;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.PermissionLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionImporter {
    private static Log _log = LogFactoryUtil.getLog(PermissionImporter.class);

    protected List<String> getActions(Element el) {
        ArrayList<String> actions = new ArrayList<String>();
        for (Element actionEl : el.elements("action-key")) {
            actions.add(actionEl.getText());
        }
        return actions;
    }

    protected void importGroupPermissions(LayoutCache layoutCache, long companyId, long groupId, String resourceName, String resourcePrimKey, Element parentEl, String elName, boolean portletActions) throws PortalException, SystemException {
        Element actionEl = parentEl.element(elName);
        if (actionEl == null) {
            return;
        }
        List<String> actions = this.getActions(actionEl);
        Resource resource = layoutCache.getResource(companyId, groupId, resourceName, 4, resourcePrimKey, portletActions);
        PermissionLocalServiceUtil.setGroupPermissions((long)groupId, (String[])actions.toArray(new String[actions.size()]), (long)resource.getResourceId());
    }

    protected void importGroupRoles(LayoutCache layoutCache, long companyId, long groupId, String resourceName, String entityName, Element parentEl) throws PortalException, SystemException {
        Element entityRolesEl = parentEl.element(String.valueOf(entityName) + "-roles");
        if (entityRolesEl == null) {
            return;
        }
        this.importRolePermissions(layoutCache, companyId, resourceName, 2, String.valueOf(groupId), entityRolesEl, true);
    }

    protected void importInheritedPermissions(LayoutCache layoutCache, long companyId, String resourceName, String resourcePrimKey, Element permissionsEl, String entityName, boolean portletActions) throws PortalException, SystemException {
        Element entityPermissionsEl = permissionsEl.element(String.valueOf(entityName) + "-permissions");
        if (entityPermissionsEl == null) {
            return;
        }
        List actionsEls = entityPermissionsEl.elements(String.valueOf(entityName) + "-actions");
        int i = 0;
        while (i < actionsEls.size()) {
            Element actionEl = (Element)actionsEls.get(i);
            String name = actionEl.attributeValue("name");
            long entityGroupId = layoutCache.getEntityGroupId(companyId, entityName, name);
            if (entityGroupId == 0L) {
                _log.warn((Object)("Ignore inherited permissions for entity " + entityName + " with name " + name));
            } else {
                Element parentEl = SAXReaderUtil.createElement((String)"parent");
                parentEl.add(actionEl.createCopy());
                this.importGroupPermissions(layoutCache, companyId, entityGroupId, resourceName, resourcePrimKey, parentEl, String.valueOf(entityName) + "-actions", portletActions);
            }
            ++i;
        }
    }

    protected void importInheritedRoles(LayoutCache layoutCache, long companyId, long groupId, String resourceName, String entityName, Element parentEl) throws PortalException, SystemException {
        Element entityRolesEl = parentEl.element(String.valueOf(entityName) + "-roles");
        if (entityRolesEl == null) {
            return;
        }
        List entityEls = entityRolesEl.elements(entityName);
        int i = 0;
        while (i < entityEls.size()) {
            Element entityEl = (Element)entityEls.get(i);
            String name = entityEl.attributeValue("name");
            long entityGroupId = layoutCache.getEntityGroupId(companyId, entityName, name);
            if (entityGroupId == 0L) {
                _log.warn((Object)("Ignore inherited roles for entity " + entityName + " with name " + name));
            } else {
                this.importRolePermissions(layoutCache, companyId, resourceName, 2, String.valueOf(groupId), entityEl, false);
            }
            ++i;
        }
    }

    protected void importLayoutPermissions(LayoutCache layoutCache, long companyId, long groupId, long userId, Layout layout, Element layoutEl, Element parentEl, boolean importUserPermissions) throws PortalException, SystemException {
        Element permissionsEl = layoutEl.element("permissions");
        if (permissionsEl != null) {
            String resourceName = Layout.class.getName();
            String resourcePrimKey = String.valueOf(layout.getPlid());
            if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
                this.importPermissions_5(layoutCache, companyId, groupId, userId, resourceName, resourcePrimKey, permissionsEl, false);
            } else if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
                this.importPermissions_6(layoutCache, companyId, groupId, userId, resourceName, resourcePrimKey, permissionsEl, false);
            } else {
                Group guestGroup = GroupLocalServiceUtil.getGroup((long)companyId, (String)"Guest");
                this.importLayoutPermissions_1to4(layoutCache, companyId, groupId, guestGroup, layout, resourceName, resourcePrimKey, permissionsEl, importUserPermissions);
            }
        }
        Element rolesEl = parentEl.element("roles");
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM < 5 && rolesEl != null) {
            this.importLayoutRoles(layoutCache, companyId, groupId, rolesEl);
        }
    }

    protected void importLayoutPermissions_1to4(LayoutCache layoutCache, long companyId, long groupId, Group guestGroup, Layout layout, String resourceName, String resourcePrimKey, Element permissionsEl, boolean importUserPermissions) throws PortalException, SystemException {
        this.importGroupPermissions(layoutCache, companyId, groupId, resourceName, resourcePrimKey, permissionsEl, "community-actions", false);
        if (groupId != guestGroup.getGroupId()) {
            this.importGroupPermissions(layoutCache, companyId, guestGroup.getGroupId(), resourceName, resourcePrimKey, permissionsEl, "guest-actions", false);
        }
        if (importUserPermissions) {
            this.importUserPermissions(layoutCache, companyId, groupId, resourceName, resourcePrimKey, permissionsEl, false);
        }
        this.importInheritedPermissions(layoutCache, companyId, resourceName, resourcePrimKey, permissionsEl, "organization", false);
        this.importInheritedPermissions(layoutCache, companyId, resourceName, resourcePrimKey, permissionsEl, "user-group", false);
    }

    protected void importLayoutRoles(LayoutCache layoutCache, long companyId, long groupId, Element rolesEl) throws PortalException, SystemException {
        String resourceName = Layout.class.getName();
        this.importGroupRoles(layoutCache, companyId, groupId, resourceName, "community", rolesEl);
        this.importUserRoles(layoutCache, companyId, groupId, resourceName, rolesEl);
        this.importInheritedRoles(layoutCache, companyId, groupId, resourceName, "organization", rolesEl);
        this.importInheritedRoles(layoutCache, companyId, groupId, resourceName, "user-group", rolesEl);
    }

    protected void importPermissions_5(LayoutCache layoutCache, long companyId, long groupId, long userId, String resourceName, String resourcePrimKey, Element permissionsEl, boolean portletActions) throws PortalException, SystemException {
        Resource resource = layoutCache.getResource(companyId, groupId, resourceName, 4, resourcePrimKey, portletActions);
        List roleEls = permissionsEl.elements("role");
        for (Element roleEl : roleEls) {
            String name = roleEl.attributeValue("name");
            Role role = layoutCache.getRole(companyId, name);
            if (role == null) {
                String description = roleEl.attributeValue("description");
                int type = Integer.valueOf(roleEl.attributeValue("type"));
                role = RoleLocalServiceUtil.addRole((long)userId, (long)companyId, (String)name, null, (String)description, (int)type);
            }
            List<String> actions = this.getActions(roleEl);
            PermissionLocalServiceUtil.setRolePermissions((long)role.getRoleId(), (String[])actions.toArray(new String[actions.size()]), (long)resource.getResourceId());
        }
    }

    protected void importPermissions_6(LayoutCache layoutCache, long companyId, long groupId, long userId, String resourceName, String resourcePrimKey, Element permissionsEl, boolean portletActions) throws PortalException, SystemException {
        List roleEls = permissionsEl.elements("role");
        for (Element roleEl : roleEls) {
            String name = roleEl.attributeValue("name");
            Role role = layoutCache.getRole(companyId, name);
            if (role == null) {
                String description = roleEl.attributeValue("description");
                int type = Integer.valueOf(roleEl.attributeValue("type"));
                role = RoleLocalServiceUtil.addRole((long)userId, (long)companyId, (String)name, null, (String)description, (int)type);
            }
            List<String> actions = this.getActions(roleEl);
            ResourcePermissionLocalServiceUtil.setResourcePermissions((long)companyId, (String)resourceName, (int)4, (String)resourcePrimKey, (long)role.getRoleId(), (String[])actions.toArray(new String[actions.size()]));
        }
    }

    protected void importPortletPermissions(LayoutCache layoutCache, long companyId, long groupId, long userId, Layout layout, Element portletEl, String portletId, boolean importUserPermissions) throws PortalException, SystemException {
        Element permissionsEl = portletEl.element("permissions");
        if (permissionsEl != null) {
            String resourceName = PortletConstants.getRootPortletId((String)portletId);
            String resourcePrimKey = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId);
            if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
                this.importPermissions_5(layoutCache, companyId, groupId, userId, resourceName, resourcePrimKey, permissionsEl, true);
            } else if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
                this.importPermissions_6(layoutCache, companyId, groupId, userId, resourceName, resourcePrimKey, permissionsEl, true);
            } else {
                Group guestGroup = GroupLocalServiceUtil.getGroup((long)companyId, (String)"Guest");
                this.importPortletPermissions_1to4(layoutCache, companyId, groupId, guestGroup, layout, permissionsEl, importUserPermissions);
            }
        }
        Element rolesEl = portletEl.element("roles");
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM < 5 && rolesEl != null) {
            this.importPortletRoles(layoutCache, companyId, groupId, portletEl);
            this.importPortletRoles(layoutCache, companyId, groupId, portletId, rolesEl);
        }
    }

    protected void importPortletPermissions_1to4(LayoutCache layoutCache, long companyId, long groupId, Group guestGroup, Layout layout, Element permissionsEl, boolean importUserPermissions) throws PortalException, SystemException {
        for (Element portletEl : permissionsEl.elements("portlet")) {
            String portletId = portletEl.attributeValue("portlet-id");
            String resourceName = PortletConstants.getRootPortletId((String)portletId);
            String resourcePrimKey = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId);
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)resourceName);
            if (portlet == null) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Do not import portlet permissions for " + portletId + " because the portlet does not exist"));
                continue;
            }
            this.importGroupPermissions(layoutCache, companyId, groupId, resourceName, resourcePrimKey, portletEl, "community-actions", true);
            if (groupId != guestGroup.getGroupId()) {
                this.importGroupPermissions(layoutCache, companyId, guestGroup.getGroupId(), resourceName, resourcePrimKey, portletEl, "guest-actions", true);
            }
            if (importUserPermissions) {
                this.importUserPermissions(layoutCache, companyId, groupId, resourceName, resourcePrimKey, portletEl, true);
            }
            this.importInheritedPermissions(layoutCache, companyId, resourceName, resourcePrimKey, portletEl, "organization", true);
            this.importInheritedPermissions(layoutCache, companyId, resourceName, resourcePrimKey, portletEl, "user-group", true);
        }
    }

    protected void importPortletRoles(LayoutCache layoutCache, long companyId, long groupId, String portletId, Element rolesEl) throws PortalException, SystemException {
        String resourceName = PortletConstants.getRootPortletId((String)portletId);
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)resourceName);
        if (portlet == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Do not import portlet roles for " + portletId + " because the portlet does not exist"));
            }
        } else {
            this.importGroupRoles(layoutCache, companyId, groupId, resourceName, "community", rolesEl);
            this.importUserRoles(layoutCache, companyId, groupId, resourceName, rolesEl);
            this.importInheritedRoles(layoutCache, companyId, groupId, resourceName, "organization", rolesEl);
            this.importInheritedRoles(layoutCache, companyId, groupId, resourceName, "user-group", rolesEl);
        }
    }

    protected void importPortletRoles(LayoutCache layoutCache, long companyId, long groupId, Element rolesEl) throws PortalException, SystemException {
        for (Element portletEl : rolesEl.elements("portlet")) {
            String portletId = portletEl.attributeValue("portlet-id");
            String resourceName = PortletConstants.getRootPortletId((String)portletId);
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)resourceName);
            if (portlet == null) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Do not import portlet roles for " + portletId + " because the portlet does not exist"));
                continue;
            }
            this.importGroupRoles(layoutCache, companyId, groupId, resourceName, "community", portletEl);
            this.importUserRoles(layoutCache, companyId, groupId, resourceName, portletEl);
            this.importInheritedRoles(layoutCache, companyId, groupId, resourceName, "organization", portletEl);
            this.importInheritedRoles(layoutCache, companyId, groupId, resourceName, "user-group", portletEl);
        }
    }

    protected void importRolePermissions(LayoutCache layoutCache, long companyId, String resourceName, int scope, String resourcePrimKey, Element parentEl, boolean communityRole) throws PortalException, SystemException {
        List roleEls = parentEl.elements("role");
        int i = 0;
        while (i < roleEls.size()) {
            Element roleEl = (Element)roleEls.get(i);
            String roleName = roleEl.attributeValue("name");
            Role role = layoutCache.getRole(companyId, roleName);
            if (role == null) {
                _log.warn((Object)("Ignoring permissions for role with name " + roleName));
            } else {
                List<String> actions = this.getActions(roleEl);
                PermissionLocalServiceUtil.setRolePermissions((long)role.getRoleId(), (long)companyId, (String)resourceName, (int)scope, (String)resourcePrimKey, (String[])actions.toArray(new String[actions.size()]));
                if (communityRole) {
                    long[] groupIds = new long[]{GetterUtil.getLong((String)resourcePrimKey)};
                    GroupLocalServiceUtil.addRoleGroups((long)role.getRoleId(), (long[])groupIds);
                }
            }
            ++i;
        }
    }

    protected void importUserPermissions(LayoutCache layoutCache, long companyId, long groupId, String resourceName, String resourcePrimKey, Element parentEl, boolean portletActions) throws PortalException, SystemException {
        Element userPermissionsEl = parentEl.element("user-permissions");
        if (userPermissionsEl == null) {
            return;
        }
        List userActionsEls = userPermissionsEl.elements("user-actions");
        int i = 0;
        while (i < userActionsEls.size()) {
            Element userActionsEl = (Element)userActionsEls.get(i);
            String uuid = userActionsEl.attributeValue("uuid");
            User user = layoutCache.getUser(companyId, groupId, uuid);
            if (user == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Ignoring permissions for user with uuid " + uuid));
                }
            } else {
                List<String> actions = this.getActions(userActionsEl);
                Resource resource = layoutCache.getResource(companyId, groupId, resourceName, 4, resourcePrimKey, portletActions);
                PermissionLocalServiceUtil.setUserPermissions((long)user.getUserId(), (String[])actions.toArray(new String[actions.size()]), (long)resource.getResourceId());
            }
            ++i;
        }
    }

    protected void importUserRoles(LayoutCache layoutCache, long companyId, long groupId, String resourceName, Element parentEl) throws PortalException, SystemException {
        Element userRolesEl = parentEl.element("user-roles");
        if (userRolesEl == null) {
            return;
        }
        List userEls = userRolesEl.elements("user");
        int i = 0;
        while (i < userEls.size()) {
            Element userEl = (Element)userEls.get(i);
            String uuid = userEl.attributeValue("uuid");
            User user = layoutCache.getUser(companyId, groupId, uuid);
            if (user == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Ignoring roles for user with uuid " + uuid));
                }
            } else {
                this.importRolePermissions(layoutCache, companyId, resourceName, 2, String.valueOf(groupId), userEl, false);
            }
            ++i;
        }
    }

    protected void readPortletDataPermissions(PortletDataContext context) throws SystemException {
        try {
            String xml = context.getZipEntryAsString(String.valueOf(context.getSourceRootPath()) + "/portlet-data-permissions.xml");
            if (xml == null) {
                return;
            }
            Document doc = SAXReaderUtil.read((String)xml);
            Element root = doc.getRootElement();
            List portletDataEls = root.elements("portlet-data");
            for (Element portletDataEl : portletDataEls) {
                String resourceName = portletDataEl.attributeValue("resource-name");
                long resourcePK = GetterUtil.getLong((String)portletDataEl.attributeValue("resource-pk"));
                ArrayList<KeyValuePair> permissions = new ArrayList<KeyValuePair>();
                List permissionsEls = portletDataEl.elements("permissions");
                for (Element permissionsEl : permissionsEls) {
                    String roleName = permissionsEl.attributeValue("role-name");
                    String actions = permissionsEl.attributeValue("actions");
                    KeyValuePair permission = new KeyValuePair(roleName, actions);
                    permissions.add(permission);
                }
                context.addPermissions(resourceName, resourcePK, permissions);
            }
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }
}

