/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.dialect.SQLServerDialect;

public class SQLServer2008Dialect
extends SQLServerDialect {
    private static final boolean _SUPPORTS_LIMIT_OFFSET = true;

    public String getLimitString(String sql, int offset, int limit) {
        String sqlLowerCase = sql.toLowerCase();
        String limitString = null;
        limitString = sqlLowerCase.contains(" union ") ? this.getLimitStringUnion(sql, sqlLowerCase, offset, limit) : this.getLimitString(sql, sqlLowerCase, offset, limit);
        return limitString;
    }

    public boolean supportsLimitOffset() {
        return true;
    }

    protected String getLimitString(String sql, String sqlLowerCase, int offset, int limit) {
        int orderByPos = sqlLowerCase.lastIndexOf(" order by ");
        if (orderByPos < 0) {
            return super.getLimitString(sql, offset, limit);
        }
        String orderByString = sql.substring(orderByPos + 9, sql.length());
        Object[] orderByArray = StringUtil.split((String)orderByString, (String)",");
        int fromPos = sqlLowerCase.indexOf(" from ");
        String selectFrom = sql.substring(0, fromPos);
        int i = 0;
        while (i < orderByArray.length) {
            String orderBy = orderByArray[i].trim();
            String orderByColumn = null;
            String orderByType = null;
            int columnPos = orderBy.indexOf(32);
            if (columnPos == -1) {
                orderByColumn = orderBy;
                orderByType = "ASC";
            } else {
                orderByColumn = orderBy.substring(0, columnPos);
                orderByType = orderBy.substring(columnPos + 1);
            }
            Pattern pattern = Pattern.compile("(\\S+) as \\Q".concat(orderByColumn).concat("\\E\\W"), 2);
            Matcher matcher = pattern.matcher(selectFrom);
            if (matcher.find()) {
                orderByColumn = matcher.group(1);
            }
            orderByArray[i] = orderByColumn.concat(" ").concat(orderByType);
            ++i;
        }
        String selectFromWhere = sql.substring(fromPos, orderByPos);
        StringBundler sb = new StringBundler(11);
        sb.append("select * from (");
        sb.append(selectFrom);
        sb.append(", row_number() over (order by ");
        sb.append(StringUtil.merge((Object[])orderByArray, (String)","));
        sb.append(") as _page_row_num ");
        sb.append(selectFromWhere);
        sb.append(" ) temp where _page_row_num between ");
        sb.append(offset + 1);
        sb.append(" and ");
        sb.append(limit);
        sb.append(" order by _page_row_num");
        return sb.toString();
    }

    protected String getLimitStringUnion(String sql, String sqlLowerCase, int offset, int limit) {
        int orderByPos = sqlLowerCase.lastIndexOf(" order by ");
        if (orderByPos < 0) {
            return super.getLimitString(sql, offset, limit);
        }
        String orderByString = sql.substring(orderByPos + 9, sql.length());
        Object[] orderByArray = StringUtil.split((String)orderByString, (String)",");
        int fromPos = sqlLowerCase.indexOf(" from ");
        String selectFrom = sql.substring(0, fromPos);
        int i = 0;
        while (i < orderByArray.length) {
            String orderBy = orderByArray[i].trim();
            String orderByColumn = null;
            String orderByType = null;
            int columnPos = orderBy.indexOf(32);
            if (columnPos == -1) {
                orderByColumn = orderBy;
                orderByType = "ASC";
            } else {
                orderByColumn = orderBy.substring(0, columnPos);
                orderByType = orderBy.substring(columnPos + 1);
            }
            Pattern pattern = Pattern.compile("\\Q".concat(orderByColumn).concat("\\E as (\\w+)"), 2);
            Matcher matcher = pattern.matcher(selectFrom);
            if (matcher.find()) {
                orderByColumn = matcher.group(1);
            }
            orderByArray[i] = orderByColumn.concat(" ").concat(orderByType);
            ++i;
        }
        String selectFromWhere = sql.substring(fromPos, orderByPos);
        StringBundler sb = new StringBundler(10);
        sb.append("select * from (select *, row_number() over (order by ");
        sb.append(StringUtil.merge((Object[])orderByArray, (String)","));
        sb.append(") as _page_row_num from (");
        sb.append(selectFrom);
        sb.append(selectFromWhere);
        sb.append(" ) temp ) temp2 where _page_row_num between ");
        sb.append(offset + 1);
        sb.append(" and ");
        sb.append(limit);
        sb.append(" order by _page_row_num");
        return sb.toString();
    }
}

