/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.captcha.simplecaptcha;

import com.liferay.portal.kernel.captcha.CaptchaException;
import com.liferay.portal.kernel.captcha.CaptchaMaxChallengesException;
import com.liferay.portal.kernel.captcha.CaptchaTextException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Randomizer;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.captcha.Captcha;
import nl.captcha.backgrounds.BackgroundProducer;
import nl.captcha.gimpy.GimpyRenderer;
import nl.captcha.noise.NoiseProducer;
import nl.captcha.servlet.CaptchaServletUtil;
import nl.captcha.text.producer.TextProducer;
import nl.captcha.text.renderer.WordRenderer;

public class SimpleCaptchaImpl
implements com.liferay.portal.kernel.captcha.Captcha {
    private static final String _TAGLIB_PATH = "/html/taglib/ui/captcha/simplecaptcha.jsp";
    private static Log _log = LogFactoryUtil.getLog(SimpleCaptchaImpl.class);
    private BackgroundProducer[] _backgroundProducers;
    private GimpyRenderer[] _gimpyRenderers;
    private NoiseProducer[] _noiseProducers;
    private TextProducer[] _textProducers;
    private WordRenderer[] _wordRenderers;

    public SimpleCaptchaImpl() {
        this.initBackgroundProducers();
        this.initGimpyRenderers();
        this.initNoiseProducers();
        this.initTextProducers();
        this.initWordRenderers();
    }

    public void check(HttpServletRequest request) throws CaptchaException {
        if (!this.isEnabled(request)) {
            return;
        }
        HttpSession session = request.getSession();
        String captchaText = (String)session.getAttribute("CAPTCHA_TEXT");
        if (captchaText == null) {
            _log.error((Object)("Captcha text is null. User " + request.getRemoteUser() + " may be trying to circumvent the captcha."));
            throw new CaptchaTextException();
        }
        if (!captchaText.equals(ParamUtil.getString((HttpServletRequest)request, (String)"captchaText"))) {
            if (PropsValues.CAPTCHA_MAX_CHALLENGES > 0 && Validator.isNotNull((String)request.getRemoteUser())) {
                Integer count = (Integer)session.getAttribute("CAPTCHA_COUNT");
                count = count == null ? new Integer(1) : new Integer(count + 1);
                session.setAttribute("CAPTCHA_COUNT", (Object)count);
            }
            throw new CaptchaTextException();
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Captcha text is valid");
        }
        session.removeAttribute("CAPTCHA_TEXT");
    }

    public void check(PortletRequest portletRequest) throws CaptchaException {
        if (!this.isEnabled(portletRequest)) {
            return;
        }
        PortletSession portletSession = portletRequest.getPortletSession();
        String captchaText = (String)portletSession.getAttribute("CAPTCHA_TEXT");
        if (captchaText == null) {
            _log.error((Object)("Captcha text is null. User " + portletRequest.getRemoteUser() + " may be trying to circumvent the captcha."));
            throw new CaptchaTextException();
        }
        if (!captchaText.equals(ParamUtil.getString((PortletRequest)portletRequest, (String)"captchaText"))) {
            if (PropsValues.CAPTCHA_MAX_CHALLENGES > 0 && Validator.isNotNull((String)portletRequest.getRemoteUser())) {
                Integer count = (Integer)portletSession.getAttribute("CAPTCHA_COUNT");
                count = count == null ? new Integer(1) : new Integer(count + 1);
                portletSession.setAttribute("CAPTCHA_COUNT", (Object)count);
            }
            throw new CaptchaTextException();
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Captcha text is valid");
        }
        portletSession.removeAttribute("CAPTCHA_TEXT");
    }

    public String getTaglibPath() {
        return _TAGLIB_PATH;
    }

    public boolean isEnabled(HttpServletRequest request) throws CaptchaException {
        if (PropsValues.CAPTCHA_MAX_CHALLENGES > 0) {
            HttpSession session = request.getSession();
            Integer count = (Integer)session.getAttribute("CAPTCHA_COUNT");
            if (count != null && count >= PropsValues.CAPTCHA_MAX_CHALLENGES) {
                throw new CaptchaMaxChallengesException();
            }
            return count == null || PropsValues.CAPTCHA_MAX_CHALLENGES > count;
        }
        return PropsValues.CAPTCHA_MAX_CHALLENGES >= 0;
    }

    public boolean isEnabled(PortletRequest portletRequest) throws CaptchaException {
        if (PropsValues.CAPTCHA_MAX_CHALLENGES > 0) {
            PortletSession portletSession = portletRequest.getPortletSession();
            Integer count = (Integer)portletSession.getAttribute("CAPTCHA_COUNT");
            if (count != null && count >= PropsValues.CAPTCHA_MAX_CHALLENGES) {
                throw new CaptchaMaxChallengesException();
            }
            return count == null || PropsValues.CAPTCHA_MAX_CHALLENGES > count;
        }
        return PropsValues.CAPTCHA_MAX_CHALLENGES >= 0;
    }

    public void serveImage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession();
        Captcha simpleCaptcha = this.getSimpleCaptcha();
        session.setAttribute("CAPTCHA_TEXT", (Object)simpleCaptcha.getAnswer());
        response.setContentType("image/jpeg");
        CaptchaServletUtil.writeImage((OutputStream)response.getOutputStream(), (BufferedImage)simpleCaptcha.getImage());
    }

    public void serveImage(PortletRequest portletRequest, PortletResponse portletResponse) throws IOException {
        PortletSession portletSession = portletRequest.getPortletSession();
        Captcha simpleCaptcha = this.getSimpleCaptcha();
        portletSession.setAttribute("CAPTCHA_TEXT", (Object)simpleCaptcha.getAnswer());
        HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)portletResponse);
        CaptchaServletUtil.writeImage((OutputStream)response.getOutputStream(), (BufferedImage)simpleCaptcha.getImage());
    }

    protected BackgroundProducer getBackgroundProducer() {
        if (this._backgroundProducers.length == 1) {
            return this._backgroundProducers[0];
        }
        Randomizer randomizer = Randomizer.getInstance();
        int pos = randomizer.nextInt(this._backgroundProducers.length);
        return this._backgroundProducers[pos];
    }

    protected GimpyRenderer getGimpyRenderer() {
        if (this._gimpyRenderers.length == 1) {
            return this._gimpyRenderers[0];
        }
        Randomizer randomizer = Randomizer.getInstance();
        int pos = randomizer.nextInt(this._gimpyRenderers.length);
        return this._gimpyRenderers[pos];
    }

    protected int getHeight() {
        return PropsValues.CAPTCHA_ENGINE_SIMPLECAPTCHA_HEIGHT;
    }

    protected NoiseProducer getNoiseProducer() {
        if (this._noiseProducers.length == 1) {
            return this._noiseProducers[0];
        }
        Randomizer randomizer = Randomizer.getInstance();
        int pos = randomizer.nextInt(this._noiseProducers.length);
        return this._noiseProducers[pos];
    }

    protected Captcha getSimpleCaptcha() {
        Captcha.Builder captchaBuilder = new Captcha.Builder(this.getWidth(), this.getHeight());
        captchaBuilder.addText(this.getTextProducer(), this.getWordRenderer());
        captchaBuilder.addBackground(this.getBackgroundProducer());
        captchaBuilder.gimp(this.getGimpyRenderer());
        captchaBuilder.addNoise(this.getNoiseProducer());
        captchaBuilder.addBorder();
        return captchaBuilder.build();
    }

    protected TextProducer getTextProducer() {
        if (this._textProducers.length == 1) {
            return this._textProducers[0];
        }
        Randomizer randomizer = Randomizer.getInstance();
        int pos = randomizer.nextInt(this._textProducers.length);
        return this._textProducers[pos];
    }

    protected int getWidth() {
        return PropsValues.CAPTCHA_ENGINE_SIMPLECAPTCHA_WIDTH;
    }

    protected WordRenderer getWordRenderer() {
        if (this._wordRenderers.length == 1) {
            return this._wordRenderers[0];
        }
        Randomizer randomizer = Randomizer.getInstance();
        int pos = randomizer.nextInt(this._wordRenderers.length);
        return this._wordRenderers[pos];
    }

    protected void initBackgroundProducers() {
        String[] backgroundProducerClassNames = PropsValues.CAPTCHA_ENGINE_SIMPLECAPTCHA_BACKGROUND_PRODUCERS;
        this._backgroundProducers = new BackgroundProducer[backgroundProducerClassNames.length];
        int i = 0;
        while (i < backgroundProducerClassNames.length) {
            String backgroundProducerClassName = backgroundProducerClassNames[i];
            this._backgroundProducers[i] = (BackgroundProducer)InstancePool.get((String)backgroundProducerClassName);
            ++i;
        }
    }

    protected void initGimpyRenderers() {
        String[] gimpyRendererClassNames = PropsValues.CAPTCHA_ENGINE_SIMPLECAPTCHA_GIMPY_RENDERERS;
        this._gimpyRenderers = new GimpyRenderer[gimpyRendererClassNames.length];
        int i = 0;
        while (i < gimpyRendererClassNames.length) {
            String gimpyRendererClassName = gimpyRendererClassNames[i];
            this._gimpyRenderers[i] = (GimpyRenderer)InstancePool.get((String)gimpyRendererClassName);
            ++i;
        }
    }

    protected void initNoiseProducers() {
        String[] noiseProducerClassNames = PropsValues.CAPTCHA_ENGINE_SIMPLECAPTCHA_NOISE_PRODUCERS;
        this._noiseProducers = new NoiseProducer[noiseProducerClassNames.length];
        int i = 0;
        while (i < noiseProducerClassNames.length) {
            String noiseProducerClassName = noiseProducerClassNames[i];
            this._noiseProducers[i] = (NoiseProducer)InstancePool.get((String)noiseProducerClassName);
            ++i;
        }
    }

    protected void initTextProducers() {
        String[] textProducerClassNames = PropsValues.CAPTCHA_ENGINE_SIMPLECAPTCHA_TEXT_PRODUCERS;
        this._textProducers = new TextProducer[textProducerClassNames.length];
        int i = 0;
        while (i < textProducerClassNames.length) {
            String textProducerClassName = textProducerClassNames[i];
            this._textProducers[i] = (TextProducer)InstancePool.get((String)textProducerClassName);
            ++i;
        }
    }

    protected void initWordRenderers() {
        String[] wordRendererClassNames = PropsValues.CAPTCHA_ENGINE_SIMPLECAPTCHA_WORD_RENDERERS;
        this._wordRenderers = new WordRenderer[wordRendererClassNames.length];
        int i = 0;
        while (i < wordRendererClassNames.length) {
            String wordRendererClassName = wordRendererClassNames[i];
            this._wordRenderers[i] = (WordRenderer)InstancePool.get((String)wordRendererClassName);
            ++i;
        }
    }
}

