/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.memcached;

import com.liferay.portal.cache.memcached.MemcachedClientFactory;
import com.liferay.portal.cache.memcached.PooledMemcachePortalCache;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class PooledMemcachePortalCacheManager
implements PortalCacheManager {
    private boolean _debug;
    private MemcachedClientFactory _memcachedClientFactory;
    private Map<String, PortalCache> _portalCaches = new ConcurrentHashMap<String, PortalCache>();
    private int _timeout;
    private TimeUnit _timeoutTimeUnit;

    public void afterPropertiesSet() {
    }

    public void destroy() throws Exception {
        for (PortalCache portalCache : this._portalCaches.values()) {
            portalCache.destroy();
        }
    }

    public void clearAll() {
        this._portalCaches.clear();
    }

    public PortalCache getCache(String name) {
        return this.getCache(name, false);
    }

    public PortalCache getCache(String name, boolean blocking) {
        Object portalCache = this._portalCaches.get(name);
        if (portalCache == null) {
            portalCache = new PooledMemcachePortalCache(name, this._memcachedClientFactory, this._timeout, this._timeoutTimeUnit);
            portalCache.setDebug(this._debug);
            this._portalCaches.put(name, (PortalCache)portalCache);
        }
        return portalCache;
    }

    public void removeCache(String name) {
        this._portalCaches.remove(name);
    }

    public void setDebug(boolean debug) {
        this._debug = debug;
    }

    public void setMemcachedClientPool(MemcachedClientFactory memcachedClientFactory) {
        this._memcachedClientFactory = memcachedClientFactory;
    }

    public void setTimeout(int timeout) {
        this._timeout = timeout;
    }

    public void setTimeoutTimeUnit(String timeoutTimeUnit) {
        this._timeoutTimeUnit = TimeUnit.valueOf(timeoutTimeUnit);
    }
}

