/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import java.util.ArrayList;
import java.util.HashSet;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.api.jsr283.nodetype.NodeTypeDefinition;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.value.ValueHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeTypeImpl
implements NodeType,
NodeTypeDefinition {
    private static Logger log = LoggerFactory.getLogger((Class)NodeTypeImpl.class);
    private final NodeTypeDef ntd;
    private final EffectiveNodeType ent;
    private final NodeTypeManagerImpl ntMgr;
    private final NamePathResolver resolver;
    private final ValueFactory valueFactory;
    private final DataStore store;

    NodeTypeImpl(EffectiveNodeType ent, NodeTypeDef ntd, NodeTypeManagerImpl ntMgr, NamePathResolver resolver, ValueFactory valueFactory, DataStore store) {
        this.ent = ent;
        this.ntMgr = ntMgr;
        this.resolver = resolver;
        this.valueFactory = valueFactory;
        this.ntd = ntd;
        this.store = store;
    }

    public boolean isNodeType(Name nodeTypeName) {
        return this.ent.includesNodeType(nodeTypeName);
    }

    public boolean isDerivedFrom(Name nodeTypeName) {
        return !nodeTypeName.equals(this.ntd.getName()) && this.ent.includesNodeType(nodeTypeName);
    }

    public NodeTypeDef getDefinition() {
        return (NodeTypeDef)this.ntd.clone();
    }

    public NodeDefinition[] getAutoCreatedNodeDefinitions() {
        NodeDef[] cnda = this.ent.getAutoCreateNodeDefs();
        NodeDefinition[] nodeDefs = new NodeDefinition[cnda.length];
        for (int i = 0; i < cnda.length; ++i) {
            nodeDefs[i] = this.ntMgr.getNodeDefinition(cnda[i].getId());
        }
        return nodeDefs;
    }

    public PropertyDefinition[] getAutoCreatedPropertyDefinitions() {
        PropDef[] pda = this.ent.getAutoCreatePropDefs();
        PropertyDefinition[] propDefs = new PropertyDefinition[pda.length];
        for (int i = 0; i < pda.length; ++i) {
            propDefs[i] = this.ntMgr.getPropertyDefinition(pda[i].getId());
        }
        return propDefs;
    }

    public PropertyDefinition[] getMandatoryPropertyDefinitions() {
        PropDef[] pda = this.ent.getMandatoryPropDefs();
        PropertyDefinition[] propDefs = new PropertyDefinition[pda.length];
        for (int i = 0; i < pda.length; ++i) {
            propDefs[i] = this.ntMgr.getPropertyDefinition(pda[i].getId());
        }
        return propDefs;
    }

    public NodeDefinition[] getMandatoryNodeDefinitions() {
        NodeDef[] cnda = this.ent.getMandatoryNodeDefs();
        NodeDefinition[] nodeDefs = new NodeDefinition[cnda.length];
        for (int i = 0; i < cnda.length; ++i) {
            nodeDefs[i] = this.ntMgr.getNodeDefinition(cnda[i].getId());
        }
        return nodeDefs;
    }

    public Name getQName() {
        return this.ntd.getName();
    }

    public NodeType[] getInheritedSupertypes() {
        Name[] ntNames = this.ntd.getSupertypes();
        HashSet<Name> declared = new HashSet<Name>();
        for (int i = 0; i < ntNames.length; ++i) {
            declared.add(ntNames[i]);
        }
        ntNames = this.ent.getInheritedNodeTypes();
        ArrayList<NodeTypeImpl> inherited = new ArrayList<NodeTypeImpl>();
        for (int i = 0; i < ntNames.length; ++i) {
            if (declared.contains(ntNames[i])) continue;
            try {
                inherited.add(this.ntMgr.getNodeType(ntNames[i]));
                continue;
            }
            catch (NoSuchNodeTypeException e) {
                log.error("undefined supertype", (Throwable)e);
                return new NodeType[0];
            }
        }
        return inherited.toArray(new NodeType[inherited.size()]);
    }

    public String getName() {
        try {
            return this.resolver.getJCRName(this.ntd.getName());
        }
        catch (NamespaceException e) {
            log.error("encountered unregistered namespace in node type name", (Throwable)e);
            return this.ntd.getName().toString();
        }
    }

    public String[] getDeclaredSupertypeNames() {
        Name[] ntNames = this.ntd.getSupertypes();
        String[] supertypes = new String[ntNames.length];
        for (int i = 0; i < ntNames.length; ++i) {
            try {
                supertypes[i] = this.resolver.getJCRName(this.ntd.getName());
                continue;
            }
            catch (NamespaceException e) {
                log.error("encountered unregistered namespace in node type name", (Throwable)e);
                supertypes[i] = this.ntd.getName().toString();
            }
        }
        return supertypes;
    }

    public boolean isAbstract() {
        return this.ntd.isAbstract();
    }

    public boolean isMixin() {
        return this.ntd.isMixin();
    }

    public boolean hasOrderableChildNodes() {
        return this.ntd.hasOrderableChildNodes();
    }

    public String getPrimaryItemName() {
        try {
            Name piName = this.ntd.getPrimaryItemName();
            if (piName != null) {
                return this.resolver.getJCRName(piName);
            }
            return null;
        }
        catch (NamespaceException e) {
            log.error("encountered unregistered namespace in name of primary item", (Throwable)e);
            return this.ntd.getName().toString();
        }
    }

    public NodeType[] getDeclaredSupertypes() {
        Name[] ntNames = this.ntd.getSupertypes();
        NodeType[] supertypes = new NodeType[ntNames.length];
        for (int i = 0; i < ntNames.length; ++i) {
            try {
                supertypes[i] = this.ntMgr.getNodeType(ntNames[i]);
                continue;
            }
            catch (NoSuchNodeTypeException e) {
                log.error("undefined supertype", (Throwable)e);
                return new NodeType[0];
            }
        }
        return supertypes;
    }

    public NodeDefinition[] getDeclaredChildNodeDefinitions() {
        NodeDef[] cnda = this.ntd.getChildNodeDefs();
        NodeDefinition[] nodeDefs = new NodeDefinition[cnda.length];
        for (int i = 0; i < cnda.length; ++i) {
            nodeDefs[i] = this.ntMgr.getNodeDefinition(cnda[i].getId());
        }
        return nodeDefs;
    }

    public boolean isNodeType(String nodeTypeName) {
        Name ntName;
        try {
            ntName = this.resolver.getQName(nodeTypeName);
        }
        catch (NamespaceException e) {
            log.warn("invalid node type name: " + nodeTypeName, (Throwable)e);
            return false;
        }
        catch (NameException e) {
            log.warn("invalid node type name: " + nodeTypeName, (Throwable)e);
            return false;
        }
        return this.isNodeType(ntName);
    }

    public NodeType[] getSupertypes() {
        Name[] ntNames = this.ent.getInheritedNodeTypes();
        NodeType[] supertypes = new NodeType[ntNames.length];
        for (int i = 0; i < ntNames.length; ++i) {
            try {
                supertypes[i] = this.ntMgr.getNodeType(ntNames[i]);
                continue;
            }
            catch (NoSuchNodeTypeException e) {
                log.error("undefined supertype", (Throwable)e);
                return new NodeType[0];
            }
        }
        return supertypes;
    }

    public NodeDefinition[] getChildNodeDefinitions() {
        NodeDef[] cnda = this.ent.getAllNodeDefs();
        NodeDefinition[] nodeDefs = new NodeDefinition[cnda.length];
        for (int i = 0; i < cnda.length; ++i) {
            nodeDefs[i] = this.ntMgr.getNodeDefinition(cnda[i].getId());
        }
        return nodeDefs;
    }

    public PropertyDefinition[] getPropertyDefinitions() {
        PropDef[] pda = this.ent.getAllPropDefs();
        PropertyDefinition[] propDefs = new PropertyDefinition[pda.length];
        for (int i = 0; i < pda.length; ++i) {
            propDefs[i] = this.ntMgr.getPropertyDefinition(pda[i].getId());
        }
        return propDefs;
    }

    public boolean canSetProperty(String propertyName, Value value) {
        if (value == null) {
            return this.canRemoveItem(propertyName);
        }
        try {
            InternalValue internalValue;
            PropDef def;
            Name name = this.resolver.getQName(propertyName);
            try {
                def = this.ent.getApplicablePropertyDef(name, value.getType(), false);
            }
            catch (ConstraintViolationException cve) {
                def = this.ent.getApplicablePropertyDef(name, 0, false);
            }
            if (def.isProtected()) {
                return false;
            }
            if (def.isMultiple()) {
                return false;
            }
            int targetType = def.getRequiredType() != 0 && def.getRequiredType() != value.getType() ? def.getRequiredType() : value.getType();
            if (targetType != value.getType()) {
                Value targetVal = ValueHelper.convert((Value)value, (int)targetType, (ValueFactory)this.valueFactory);
                internalValue = InternalValue.create(targetVal, this.resolver, this.store);
            } else {
                internalValue = InternalValue.create(value, this.resolver, this.store);
            }
            EffectiveNodeType.checkSetPropertyValueConstraints(def, new InternalValue[]{internalValue});
            return true;
        }
        catch (NameException be) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    public boolean canSetProperty(String propertyName, Value[] values) {
        if (values == null) {
            return this.canRemoveItem(propertyName);
        }
        try {
            PropDef def;
            Name name = this.resolver.getQName(propertyName);
            int type = 0;
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                if (type == 0) {
                    type = values[i].getType();
                    continue;
                }
                if (type == values[i].getType()) continue;
                return false;
            }
            try {
                def = this.ent.getApplicablePropertyDef(name, type, true);
            }
            catch (ConstraintViolationException cve) {
                def = this.ent.getApplicablePropertyDef(name, 0, true);
            }
            if (def.isProtected()) {
                return false;
            }
            if (!def.isMultiple()) {
                return false;
            }
            int targetType = def.getRequiredType() != 0 && def.getRequiredType() != type ? def.getRequiredType() : type;
            ArrayList<InternalValue> list = new ArrayList<InternalValue>();
            for (int i = 0; i < values.length; ++i) {
                InternalValue internalValue;
                if (values[i] == null) continue;
                if (targetType != type) {
                    Value targetVal = ValueHelper.convert((Value)values[i], (int)targetType, (ValueFactory)this.valueFactory);
                    internalValue = InternalValue.create(targetVal, this.resolver, this.store);
                } else {
                    internalValue = InternalValue.create(values[i], this.resolver, this.store);
                }
                list.add(internalValue);
            }
            InternalValue[] internalValues = list.toArray(new InternalValue[list.size()]);
            EffectiveNodeType.checkSetPropertyValueConstraints(def, internalValues);
            return true;
        }
        catch (NameException be) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    public boolean canAddChildNode(String childNodeName) {
        try {
            this.ent.checkAddNodeConstraints(this.resolver.getQName(childNodeName));
            return true;
        }
        catch (NameException be) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    public boolean canAddChildNode(String childNodeName, String nodeTypeName) {
        try {
            this.ent.checkAddNodeConstraints(this.resolver.getQName(childNodeName), this.resolver.getQName(nodeTypeName), this.ntMgr.getNodeTypeRegistry());
            return true;
        }
        catch (NameException be) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    public boolean canRemoveItem(String itemName) {
        try {
            this.ent.checkRemoveItemConstraints(this.resolver.getQName(itemName));
            return true;
        }
        catch (NameException be) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    public PropertyDefinition[] getDeclaredPropertyDefinitions() {
        PropDef[] pda = this.ntd.getPropertyDefs();
        PropertyDefinition[] propDefs = new PropertyDefinition[pda.length];
        for (int i = 0; i < pda.length; ++i) {
            propDefs[i] = this.ntMgr.getPropertyDefinition(pda[i].getId());
        }
        return propDefs;
    }

    public boolean canRemoveNode(String nodeName) {
        try {
            this.ent.checkRemoveNodeConstraints(this.resolver.getQName(nodeName));
            return true;
        }
        catch (NameException be) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    public boolean canRemoveProperty(String propertyName) {
        try {
            this.ent.checkRemovePropertyConstraints(this.resolver.getQName(propertyName));
            return true;
        }
        catch (NameException be) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }
}

