/*
 * Decompiled with CFR 0.152.
 */
package org.wikiwizard.jspwiki.filters;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPWikiToCreoleTranslator {
    public static String VAR_VERSION = "1.0";
    public static String VAR_CREOLE_VERSION = "1.0";
    public static String VAR_LINEBREAK_BLOGLIKE = "bloglike";
    public static String VAR_LINEBREAK_C2LIKE = "c2like";
    private static final String CREOLE_BOLD = "**$1**$3";
    private static final String JSPWIKI_BOLD = "\\_\\_((?s:.)*?)(\\_\\_|(\n\n|\r\r|\r\n\r\n))";
    private static final String CREOLE_ITALIC = "//$1//$3";
    private static final String JSPWIKI_ITALIC = "''((?s:.)*?)(''|(\n\n|\r\r|\r\n\r\n))";
    private static final String CREOLE_SIMPLELINK = "[[$1]]";
    private static final String JSPWIKI_SIMPLELINK = "\\[([^\\]]*?)\\]";
    private static final String CREOLE_LINK = "[$2|$1]";
    private static final String JSPWIKI_LINK = "\\[([^\\]]*?)\\|([^\\[\\]]*?)\\]";
    private static final String CREOLE_HEADER_0 = "(\n|\r|\r\n|^)=([^=\\r\\n]*)={0,2}";
    private static final String JSPWIKI_HEADER_0 = "$1!!!$2";
    private static final String CREOLE_HEADER_1 = "$1=$2";
    private static final String JSPWIKI_HEADER_1 = "(\n|\r|\r\n|^)!([^!\\r\\n]*)!{0,1}";
    private static final String CREOLE_HEADER_2 = "$1==$2";
    private static final String JSPWIKI_HEADER_2 = "(\n|\r|\r\n|^)!!([^!\\r\\n]*)!{0,2}";
    private static final String CREOLE_HEADER_3 = "$1===$2";
    private static final String JSPWIKI_HEADER_3 = "(\n|\r|\r\n|^)!!!([^!\\r\\n]*)!{0,3}";
    private static final String CREOLE_HEADER_4 = "$1====$2";
    private static final String JSPWIKI_HEADER_4 = "(\n|\r|\r\n|^)!!!!([^!\\r\\n]*)!{0,4}";
    private static final String CREOLE_SIMPLEIMAGE = "{{$1}}";
    private static final String JSPWIKI_SIMPLEIMAGE = "\\[\\[\\{Image src='([^\\]]*?)'.*\\}\\]\\]";
    private static final String CREOLE_IMAGE = "{{$1}}";
    private static final String JSPWIKI_IMAGE = "\\{\\{(^\\}*?)\\|(^\\}*?)\\}\\}";
    private static final String CREOLE_IMAGE_LINK = "[{{$1}}|$2]";
    private static final String JSPWIKI_IMAGE_LINK = "\\[\\{Image src='([^\\]]*?)'.*link='([^\\]]*?)'\\}\\]";
    private static final String CREOLE_IMAGE_LINK_DESC = "[$2{{$1|$3}}";
    private static final String JSPWIKI_IMAGE_LINK_DESC = "\\[\\{Image src='([^\\]]*?)'.*link='([^\\]]*?)'.*caption='([^\\]]*?)'.*\\}\\]";
    private static final String PREFORMATTED_PROTECTED = "\\Q{{{\\E.*?\\Q}}}\\E";
    private static final String CREOLE_LINEBREAKS = "([^\\s\\\\])(\r\n|\r|\n)+(?=[^\\s\\*#])";
    private static final String JSPWIKI_LINEBREAKS = "$1\\\\\\\\$2";
    private static final String CREOLE_TABLE = "(\n|\r|\r\n|^)(\\|[^\n\r]*)\\|\\s*(\n|\r|\r\n|$)";
    private static final String CREOLE_PLUGIN = "\\<\\<((?s:.)*?)\\>\\>";
    private static final String JSPWIKI_PLUGIN = "[{$1}]";
    private static final String WWW_URL = "(\\[\\[)\\s*(www\\..*?)(\\]\\])";
    private static final String HTTP_URL = "$1http://$2$3";
    private static final String CREOLE_IMAGEPRO = "\\{\\{(.*?)((\\|)(.*?)){0,1}((\\|)(.*?)){0,1}\\}\\}";
    private static final String JSPWIKI_IMAGEPRO = "[{\u2016 src='$1' caption='$4' \u2015}]";
    private static final String CREOLE_LINK_IMAGEPRO = "\\[\\[(.*?)\\|\\{\\{(.*?)((\\|)(.*?)){0,1}((\\|)(.*?)){0,1}\\}\\}\\]\\]";
    private static final String JSPWIKI_LINK_IMAGEPRO = "[{\u2016 src='$2' link='$1' caption='$5' \u2015}]";
    private static final String JSPWIKI_TABLE = "$1$2$3";
    private static final String URL_PROTECTED = "http://|ftp://|https://";
    private static final String TABLE_HEADER_PROTECTED = "((\n|\r|\r\n|^)(\\|.*?)(\n|\r|\r\n|$))";
    private static final String SIGNATURE = "--~~~";
    private static final String SIGNATURE_AND_DATE = "--~~~~";
    private static final String DEFAULT_DATEFORMAT = "yyyy-MM-dd";
    private static final String ESCAPE_PROTECTED = "~(\\*\\*|~|//|-|#|\\{\\{|}}|\\\\|~\\[~~[|]]|----|=|\\|)";
    private static final Map protectionMap = new HashMap();
    public ArrayList hashList = new ArrayList();

    public String translate(Properties wikiProps, String content) {
        String tmp = wikiProps.getProperty("creole.blogLineBreaks");
        boolean blogLineBreaks = false;
        if (tmp != null && tmp.trim().equals("true")) {
            blogLineBreaks = true;
        }
        String imagePlugin = wikiProps.getProperty("creole.imagePlugin.name");
        String result = content;
        result = result.replace("\r\n", "\n");
        result = result.replace("\r", "\n");
        result = this.protectMarkup(result);
        result = JSPWikiToCreoleTranslator.translateLists(result, "-", "*", "Nothing");
        result = this.translateElement(result, JSPWIKI_BOLD, CREOLE_BOLD);
        result = this.translateElement(result, JSPWIKI_ITALIC, CREOLE_ITALIC);
        result = this.translateElement(result, WWW_URL, HTTP_URL);
        if (imagePlugin != null && !imagePlugin.equals("")) {
            result = this.replaceImageArea(wikiProps, result, JSPWIKI_LINK_IMAGEPRO, CREOLE_LINK_IMAGEPRO, 6, imagePlugin);
            result = this.replaceImageArea(wikiProps, result, JSPWIKI_IMAGEPRO, CREOLE_IMAGEPRO, 5, imagePlugin);
        }
        result = this.translateElement(result, JSPWIKI_IMAGE_LINK_DESC, CREOLE_IMAGE_LINK_DESC);
        result = this.translateElement(result, JSPWIKI_IMAGE_LINK, CREOLE_IMAGE_LINK);
        result = this.translateElement(result, JSPWIKI_LINK, CREOLE_LINK);
        result = this.translateElement(result, JSPWIKI_SIMPLELINK, CREOLE_SIMPLELINK);
        result = this.translateElement(result, JSPWIKI_HEADER_4, CREOLE_HEADER_4);
        result = this.translateElement(result, JSPWIKI_HEADER_3, CREOLE_HEADER_3);
        result = this.translateElement(result, JSPWIKI_HEADER_2, CREOLE_HEADER_2);
        result = this.translateElement(result, JSPWIKI_HEADER_1, CREOLE_HEADER_1);
        result = this.translateElement(result, JSPWIKI_HEADER_0, CREOLE_HEADER_0);
        result = this.translateElement(result, JSPWIKI_IMAGE, "{{$1}}");
        result = JSPWikiToCreoleTranslator.translateLists(result, "-", "*", "#");
        result = this.translateElement(result, JSPWIKI_SIMPLEIMAGE, "{{$1}}");
        if (blogLineBreaks) {
            result = this.translateElement(result, JSPWIKI_LINEBREAKS, CREOLE_LINEBREAKS);
        }
        result = this.unprotectMarkup(result);
        result = this.translateVariables(result, blogLineBreaks);
        result = result.replace("\n", System.getProperty("line.separator"));
        return result;
    }

    private static String translateLists(String content, String sourceSymbol, String targetSymbol, String sourceSymbol2) {
        String[] lines = content.split("\n");
        StringBuffer result = new StringBuffer();
        int counter = 0;
        int inList = -1;
        for (int i = 0; i < lines.length; ++i) {
            int c;
            String line = lines[i];
            String actSourceSymbol = "";
            while ((line.startsWith(sourceSymbol) || line.startsWith(sourceSymbol2)) && (actSourceSymbol.equals("") || line.substring(0, 1).equals(actSourceSymbol))) {
                actSourceSymbol = line.substring(0, 1);
                line = line.substring(1, line.length());
                ++counter;
            }
            if (inList == -1 && counter != 1 || inList != -1 && inList + 1 < counter) {
                for (c = 0; c < counter; ++c) {
                    result.append(actSourceSymbol);
                }
                inList = -1;
            } else {
                for (c = 0; c < counter; ++c) {
                    if (actSourceSymbol.equals(sourceSymbol2)) {
                        result.append(sourceSymbol2);
                        continue;
                    }
                    result.append(targetSymbol);
                }
                inList = counter;
            }
            result.append(line);
            if (i < lines.length - 1) {
                result.append("\n");
            }
            counter = 0;
        }
        return result.toString();
    }

    private String translateVariables(String result, boolean blogLineBreaks) {
        result = result.replace("[{$creolepagefilter.version}]", VAR_VERSION);
        result = result.replace("[{$creolepagefilter.creoleversion}]", VAR_CREOLE_VERSION);
        String linebreaks = blogLineBreaks ? VAR_LINEBREAK_BLOGLIKE : VAR_LINEBREAK_C2LIKE;
        result = result.replace("[{$creolepagefilter.linebreak}]", linebreaks);
        return result;
    }

    private String unprotectMarkup(String content) {
        Object[] it = this.hashList.toArray();
        for (int i = it.length - 1; i >= 0; --i) {
            String hash = (String)it[i];
            String protectedMarkup = (String)protectionMap.get(hash);
            content = content.replace(hash, protectedMarkup);
            if (protectedMarkup.length() >= 3 && (protectedMarkup.length() <= 2 || protectedMarkup.substring(0, 3).equals("{{{"))) continue;
            content = this.translateElement(content, CREOLE_PLUGIN, JSPWIKI_PLUGIN);
        }
        return content;
    }

    private String protectMarkup(String content) {
        protectionMap.clear();
        this.hashList = new ArrayList();
        content = this.protectMarkup(content, PREFORMATTED_PROTECTED, "", "");
        content = this.protectMarkup(content, URL_PROTECTED, "", "");
        content = this.protectMarkup(content, ESCAPE_PROTECTED, "", "");
        content = this.protectMarkup(content, CREOLE_PLUGIN, "", "");
        return content;
    }

    public String replaceImageArea(Properties wikiProps, String content, String markupRegex, String replaceContent, int groupPos, String imagePlugin) {
        Matcher matcher = Pattern.compile(markupRegex, 40).matcher(content);
        String contentCopy = content;
        while (matcher.find()) {
            String protectedMarkup = matcher.group(0);
            String paramsField = matcher.group(groupPos);
            String paramsString = "";
            if (paramsField != null) {
                String[] params = paramsField.split(",");
                for (int i = 0; i < params.length; ++i) {
                    if (wikiProps.getProperty("creole.imagePlugin.para." + params[i].replaceAll("\\|", "")) == null) continue;
                    paramsString = paramsString + " " + wikiProps.getProperty("creole.imagePlugin.para." + params[i].replaceAll("\\|", "")).replaceAll("^(\"|')(.*)(\"|')$", "$2");
                }
            }
            String temp = protectedMarkup;
            protectedMarkup = this.translateElement(protectedMarkup, markupRegex, replaceContent);
            protectedMarkup = protectedMarkup.replaceAll("\u2015", paramsString);
            protectedMarkup = protectedMarkup.replaceAll("\u2016", imagePlugin);
            protectedMarkup = protectedMarkup.replaceAll("caption=''", "");
            protectedMarkup = protectedMarkup.replaceAll("\\s+", " ");
            int pos = contentCopy.indexOf(temp);
            contentCopy = contentCopy.substring(0, pos) + protectedMarkup + contentCopy.substring(pos + temp.length(), contentCopy.length());
        }
        return contentCopy;
    }

    public String replaceArea(String content, String markupRegex, String replaceSource, String replaceTarget) {
        Matcher matcher = Pattern.compile(markupRegex, 40).matcher(content);
        String contentCopy = content;
        while (matcher.find()) {
            String protectedMarkup;
            String temp = protectedMarkup = matcher.group(0);
            protectedMarkup = protectedMarkup.replaceAll(replaceSource, replaceTarget);
            int pos = contentCopy.indexOf(temp);
            contentCopy = contentCopy.substring(0, pos) + protectedMarkup + contentCopy.substring(pos + temp.length(), contentCopy.length());
        }
        return contentCopy;
    }

    private String protectMarkup(String content, String markupRegex, String replaceSource, String replaceTarget) {
        Matcher matcher = Pattern.compile(markupRegex, 40).matcher(content);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String protectedMarkup = matcher.group();
            protectedMarkup = protectedMarkup.replaceAll(replaceSource, replaceTarget);
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                digest.reset();
                digest.update(protectedMarkup.getBytes());
                String hash = this.bytesToHash(digest.digest());
                matcher.appendReplacement(result, hash);
                protectionMap.put(hash, protectedMarkup);
                this.hashList.add(hash);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private String bytesToHash(byte[] b) {
        String hash = "";
        for (int i = 0; i < b.length; ++i) {
            hash = hash + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return hash;
    }

    private String translateElement(String content, String fromMarkup, String toMarkup) {
        Matcher matcher = Pattern.compile(fromMarkup, 8).matcher(content);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(result, toMarkup);
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

