/*
 * Decompiled with CFR 0.152.
 */
package JOscarLib.Packet.Received;

import JOscarLib.Core.OscarConnection;
import JOscarLib.Flap;
import JOscarLib.RawData;
import JOscarLib.Request.Event.RequestAnswerEvent;
import JOscarLib.Request.Request;
import JOscarLib.Request.RequestKeeper;
import JOscarLib.Snac;

public class ReceivedPacket
extends Flap {
    public ReceivedPacket(byte[] array, boolean hasSnac) {
        this.setChannelId(new RawData(array, 1, 1).getValue());
        this.setSequenceNumber(new RawData(array, 2, 2).getValue());
        if (hasSnac) {
            this.addSnac(new Snac(array, 6));
        } else {
            this.addRawDataToFlap(new RawData(array, 6, array.length - 6));
        }
    }

    public void execute(OscarConnection connection) throws Exception {
    }

    public void notifyEvent(OscarConnection connection) {
    }

    public void matchRequest(OscarConnection connection) {
        RequestKeeper requestKeeper = connection.getRequestKeeper();
        if (requestKeeper.containsRequest(this.getSnac().getRequestId())) {
            Request request = requestKeeper.getRequest(this.getSnac().getRequestId());
            for (int i = 0; i < request.getNbListeners(); ++i) {
                request.getRequestListener(i).onRequestAnswer(new RequestAnswerEvent(request.getMonitoredFlap(), this));
            }
            request.removeAllListener();
        }
    }
}

