/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.servlet.ServletUtil;
import jodd.servlet.UrlEncoder;

public class UrlBuilder {
    protected final StringBuilder url;
    protected final String encoding;
    protected final HttpServletResponse response;
    protected boolean hasParams;

    public UrlBuilder(String baseUrl, String encoding) {
        this(baseUrl, encoding, null, null);
    }

    public UrlBuilder(String baseUrl, String encoding, HttpServletRequest request, HttpServletResponse response) {
        if (request != null) {
            baseUrl = ServletUtil.resolveUrl(baseUrl, request);
        }
        this.url = new StringBuilder(baseUrl);
        this.hasParams = baseUrl.indexOf(63) != -1;
        this.encoding = encoding;
        this.response = response;
    }

    public UrlBuilder param(String name, Object value) {
        return this.param(name, value == null ? null : value.toString());
    }

    public UrlBuilder param(String name, String value) {
        this.url.append(this.hasParams ? (char)'&' : '?');
        this.hasParams = true;
        UrlEncoder.appendUrl(this.url, name, this.encoding);
        if (value != null && value.length() > 0) {
            this.url.append('=');
            UrlEncoder.appendUrl(this.url, value, this.encoding);
        }
        return this;
    }

    public UrlBuilder param(String nameValue) {
        String name;
        this.url.append(this.hasParams ? (char)'&' : '?');
        this.hasParams = true;
        int eqNdx = nameValue.indexOf(61);
        String value = null;
        if (eqNdx == -1) {
            name = nameValue;
        } else {
            name = nameValue.substring(0, eqNdx);
            value = nameValue.substring(eqNdx + 1);
        }
        UrlEncoder.appendUrl(this.url, name, this.encoding);
        if (value != null && value.length() > 0) {
            this.url.append('=');
            UrlEncoder.appendUrl(this.url, value, this.encoding);
        }
        return this;
    }

    public String toString() {
        String result = this.url.toString();
        return this.response != null ? this.response.encodeURL(result) : result;
    }
}

