/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet;

import java.io.IOException;
import java.lang.reflect.Method;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.servlet.DispatcherUtil;
import jodd.util.StringUtil;

public abstract class ServletAction
extends HttpServlet {
    public static final int HTTP_METHOD_UNKNOWN = 0;
    public static final int HTTP_METHOD_GET = 1;
    public static final int HTTP_METHOD_POST = 2;
    private int method = 0;

    public int getHttpMethod() {
        return this.method;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.method = 1;
        this.doRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.method = 2;
        this.doRequest(request, response);
    }

    protected void doRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
    }

    public boolean forward(HttpServletRequest request, HttpServletResponse response, String url) throws IOException, ServletException {
        return DispatcherUtil.forward((ServletRequest)request, (ServletResponse)response, url);
    }

    public boolean forwardParam(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String url = request.getParameter("forward");
        if (url != null) {
            return this.forward(request, response, url);
        }
        return false;
    }

    public boolean forwardParam(HttpServletRequest request, HttpServletResponse response, String s) throws IOException, ServletException {
        String url = request.getParameter("forward-" + s);
        if (url != null) {
            return this.forward(request, response, url);
        }
        return false;
    }

    protected static void redirect(HttpServletRequest request, HttpServletResponse response, String url) throws IOException {
        DispatcherUtil.redirect(request, response, url);
    }

    protected static boolean redirectParam(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String url = request.getParameter("redirect");
        if (url != null) {
            ServletAction.redirect(request, response, url);
            return true;
        }
        return false;
    }

    protected static boolean redirectParam(HttpServletRequest request, HttpServletResponse response, String s) throws IOException {
        String url = request.getParameter("redirect-" + s);
        if (url != null) {
            ServletAction.redirect(request, response, url);
            return true;
        }
        return false;
    }

    public String invokeActionParam(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String actionName = request.getParameter("action");
        return this.invokeActionParam((Object)this, request, response, actionName);
    }

    public String invokeActionParam(Object servlet, HttpServletRequest request, HttpServletResponse response, String actionName) throws ServletException {
        if (actionName == null) {
            return null;
        }
        try {
            Method m = servlet.getClass().getMethod(actionName, HttpServletRequest.class, HttpServletResponse.class);
            Object result = m.invoke(servlet, request, response);
            return StringUtil.toString(result);
        }
        catch (Exception ex) {
            throw new ServletException("Invocation error of action '" + actionName + "': " + ex.getMessage(), (Throwable)ex);
        }
    }

    public static boolean include(HttpServletRequest request, HttpServletResponse response, String page) throws IOException, ServletException {
        return DispatcherUtil.include((ServletRequest)request, (ServletResponse)response, page);
    }

    public static boolean includeParam(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String url = request.getParameter("include");
        if (url != null) {
            return ServletAction.include(request, response, url);
        }
        return false;
    }

    public static boolean includeParam(HttpServletRequest request, HttpServletResponse response, String includeName) throws IOException, ServletException {
        String url = request.getParameter("include-" + includeName);
        if (url != null) {
            return ServletAction.include(request, response, url);
        }
        return false;
    }
}

