/*
 * Decompiled with CFR 0.152.
 */
package nl.captcha.text.renderer;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import nl.captcha.text.renderer.WordRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWordRenderer
implements WordRenderer {
    private static final Color DEFAULT_COLOR = Color.BLACK;
    private static final List<Font> DEFAULT_FONTS = new ArrayList<Font>();
    private final Color _color;
    private final List<Font> _fonts;

    public DefaultWordRenderer() {
        this(DEFAULT_COLOR, DEFAULT_FONTS);
    }

    public DefaultWordRenderer(Color color, List<Font> list) {
        this._color = color != null ? color : DEFAULT_COLOR;
        this._fonts = list != null ? list : DEFAULT_FONTS;
    }

    @Override
    public void render(String string, BufferedImage bufferedImage) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderingHints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        graphics2D.setRenderingHints(renderingHints);
        graphics2D.setColor(this._color);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        int n = 25;
        char[] cArray = string.toCharArray();
        Random random = new Random();
        for (char c : cArray) {
            char[] cArray2 = new char[]{c};
            int n2 = random.nextInt(this._fonts.size());
            Font font = this._fonts.get(n2);
            graphics2D.setFont(font);
            GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, cArray2);
            double d = glyphVector.getVisualBounds().getWidth();
            graphics2D.drawChars(cArray2, 0, cArray2.length, n, 35);
            n += (int)d;
        }
    }

    static {
        DEFAULT_FONTS.add(new Font("Arial", 1, 40));
        DEFAULT_FONTS.add(new Font("Courier", 1, 40));
    }
}

