/*
 * Decompiled with CFR 0.152.
 */
package uk.org.primrose.test;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import uk.org.primrose.vendor.standalone.PrimroseLoader;
import uk.org.primrose.vendor.standalone.PrimroseWebConsoleLoader;

public class TestPrimroseStandalone {
    public static void main(String[] args) throws Exception, Throwable {
        if (args.length != 6) {
            System.out.println("java uk.org.primrose.test.TestPrimroseStandalone  <config file> <webconsole_username> <webconsole_password> <webconsole_port> <log file name> <log level>");
            System.out.println("EG:\njava uk.org.primrose.test.TestPrimroseStandalone /usr/primrose/conf/primrose.conf admin admin 8090 /var/log/primrose_console.log verbose,info,warn,error,crisis");
            System.exit(0);
        }
        PrimroseWebConsoleLoader.load(args[1], args[2], Integer.parseInt(args[3]), args[4], args[5]);
        List<String> loadedPoolNames = PrimroseLoader.load(args[0], true);
        String poolName = loadedPoolNames.get(0);
        new TestPrimroseStandalone().runTest(poolName);
    }

    public void runTest(String poolName) throws Throwable {
        int i = 0;
        while (i++ < 20) {
            new RunThread(poolName).run();
        }
    }

    class RunThread
    extends Thread {
        String poolName = null;

        public RunThread(String poolName) {
            this.poolName = poolName;
        }

        public void run() {
            try {
                InitialContext ctx = new InitialContext();
                DataSource ds = (DataSource)ctx.lookup("java:comp/env/" + this.poolName);
                long now = System.currentTimeMillis();
                Connection c = ds.getConnection();
                System.out.println("got connection " + c + " in " + (System.currentTimeMillis() - now) + "ms from pool " + this.poolName);
                Statement s = c.createStatement();
                ResultSet rs = s.executeQuery("select 1 from test");
                while (rs.next()) {
                    rs.getString(1);
                }
                rs.close();
                s.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

