/*
 * Decompiled with CFR 0.152.
 */
package uk.org.primrose.pool.core;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Date;
import java.util.Stack;
import java.util.Vector;
import uk.org.primrose.DebugLogger;
import uk.org.primrose.Logger;
import uk.org.primrose.Util;
import uk.org.primrose.pool.CannotConnectException;
import uk.org.primrose.pool.PoolException;
import uk.org.primrose.pool.PoolHasNoFreeConnections;
import uk.org.primrose.pool.core.ConnectionHolder;
import uk.org.primrose.pool.core.PoolConfigImpl;
import uk.org.primrose.pool.core.PoolConnection;
import uk.org.primrose.pool.core.PoolData;
import uk.org.primrose.pool.core.PoolLoader;
import uk.org.primrose.pool.core.PoolMonitor;
import uk.org.primrose.pool.core.loadrules.LoadRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pool
extends PoolData {
    public Pool() {
        this.lock = new PoolData.PoolLock(this);
        DebugLogger.log("[Pool:" + this + " ... Creating new lock object : " + this.lock);
    }

    public final Connection getConnection() throws PoolException {
        Connection c;
        long lid;
        block9: {
            lid = ++this.gid;
            if (DebugLogger.getEnabled()) {
                DebugLogger.log("[Pool@" + this.poolName + ",id=" + lid + "] getConnection() start");
            }
            if (!this.bRunPooledMode) {
                return this.getNonPooledConnection(lid);
            }
            c = null;
            try {
                c = this.internalGetConnection(lid);
            }
            catch (CannotConnectException cce) {
                if (DebugLogger.getEnabled()) {
                    DebugLogger.log("[Pool@" + this.poolName + ",id=" + lid + "] getConnection() Got exception(" + cce.getClass().getName() + ") getting connection ...");
                }
                if (!this.bWaitForConnectionIfDatabaseIsDown && this.failoverPool == null) {
                    throw cce;
                }
                if (this.failoverPool == null) break block9;
                this.notifyExceptionEvent();
            }
        }
        if (c != null) {
            if (DebugLogger.getEnabled()) {
                DebugLogger.log("[Pool@" + this.poolName + ",id=" + lid + "] getConnection() got conn OK - returning");
            }
            return c;
        }
        if (DebugLogger.getEnabled()) {
            DebugLogger.log("[Pool@" + this.poolName + ",id=" + lid + "] no connection available - waitingThreads(" + (this.numberOfWaitingThreads + 1) + ")");
        }
        ++this.numberOfWaitingThreads;
        return this.getConnectionWait(lid);
    }

    private final Connection getConnectionWait(long id) throws PoolException {
        Connection c;
        block10: {
            if (DebugLogger.getEnabled()) {
                DebugLogger.log("[Pool@" + this.poolName + ",id=" + id + "] getConnectionWait() start");
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (DebugLogger.getEnabled()) {
                DebugLogger.log("[Pool@" + this.poolName + ",id=" + id + "] After 250ms sleep, try to get connection ...");
            }
            c = null;
            try {
                c = this.internalGetConnection(id);
            }
            catch (CannotConnectException cce) {
                if (DebugLogger.getEnabled()) {
                    DebugLogger.log("[Pool@" + this.poolName + ",id=" + id + "] getConnectionWait() Got exception(" + cce.getClass().getName() + ") getting connection ...");
                }
                if (!this.bWaitForConnectionIfDatabaseIsDown && this.failoverPoolObj != null) {
                    throw cce;
                }
                if (this.failoverPoolObj != null || this.failoverPool == null) break block10;
                this.notifyExceptionEvent();
            }
        }
        if (c == null) {
            int numberOfActiveConnections = this.numberOfActiveConnections();
            this.logger.verbose("[Pool@" + this.poolName + ",id=" + id + "] getConnectionWait() Could not find a connection (" + numberOfActiveConnections + " active) - sleeping, and trying again");
            return this.getConnectionWait(id);
        }
        --this.numberOfWaitingThreads;
        if (DebugLogger.getEnabled()) {
            DebugLogger.log("[Pool@" + this.poolName + ",id=" + id + "] getConnectionWait() got connection now, returning; numberOfWaitingThreads : " + this.numberOfWaitingThreads);
        }
        return c;
    }

    private final void initializeConnection(ConnectionHolder ch, long id) {
        ++ch.numberOfOpens;
        try {
            throw new Exception();
        }
        catch (Exception e) {
            ch.callStack = e.getStackTrace();
            ch.connOpenedDate = System.currentTimeMillis();
            ch.status = 1;
            ch.id = id;
            ch.resultsetObjects = new Stack();
            ch.statementObjects = new Stack();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Connection internalGetConnection(long id) throws PoolException {
        this.logger.verbose("[Pool@" + this.poolName + ",id=" + id + "] internalGetConnection() called ...");
        if (this.poolAccessLocked) {
            this.logger.warn("[Pool@" + this.poolName + ",id=" + id + "] getConnection() Pool access is locked ...");
            throw new PoolException("Access to the pool@" + this.poolName + " is locked");
        }
        if (this.failoverPoolObj != null) {
            return this.failoverPoolObj.internalGetConnection(id);
        }
        ConnectionHolder retCH = null;
        if (DebugLogger.getEnabled()) {
            DebugLogger.log("[Pool@" + this.poolName + ",id=" + id + "] intGetConn() About to synch on lock");
        }
        PoolData.PoolLock poolLock = this.lock;
        synchronized (poolLock) {
            long now;
            block25: {
                now = System.currentTimeMillis();
                if (DebugLogger.getEnabled()) {
                    DebugLogger.log("[Pool@" + this.poolName + ",id=" + id + "] intGetConn() About to loop connections, size : " + this.connections.size());
                }
                for (ConnectionHolder ch : this.connections) {
                    if (DebugLogger.getEnabled()) {
                        DebugLogger.log("[Pool@" + this.poolName + ",id=" + id + "] intGetConn() Connection : " + ch.toString());
                    }
                    if (ch.status != 2) continue;
                    this.initializeConnection(ch, id);
                    retCH = ch;
                    if (this.iCycleConnections > -1 && ch.numberOfOpens == this.iCycleConnections) {
                        this.logger.info("[Pool@" + this.poolName + ",id=" + id + "] getConnection() Dumping " + ch.conn + " because it has executed its max number of calls (" + this.iCycleConnections + ")");
                        try {
                            ch.conn.closePhysical();
                        }
                        catch (SQLException sqle) {
                            this.logger.printStackTrace(sqle);
                        }
                        this.connections.remove(ch);
                        return this.internalGetConnection(id);
                    }
                    this.setConnectionDefaults(ch, id);
                    this.logger.verbose("[Pool@" + this.poolName + ",id=" + id + "] getConnection() using id " + ch.conn.hashCode() + ", " + this.numberOfActiveConnections() + " in use, caller : " + this.getCallerString());
                    ++this.totalConnectionsHandedOut;
                    break;
                }
                if (retCH == null) {
                    int numberOfLoadedConnections = this.connections.size();
                    if (numberOfLoadedConnections < this.iBase) {
                        ConnectionHolder ch;
                        this.logger.verbose("[Pool@" + this.poolName + ",id=" + id + "] getConnection() - No loaded connections in pool ... loaded(" + numberOfLoadedConnections + ") of base(" + this.iBase + ")");
                        this.logger.verbose("[Pool@" + this.poolName + ",id=" + id + "] getConnection() loading new connection ...");
                        ch = this.loadConnection(false, id);
                        this.initializeConnection(ch, id);
                        this.connections.addElement(ch);
                        ++this.totalConnectionsHandedOut;
                        retCH = ch;
                    } else if (numberOfLoadedConnections == this.iBase) {
                        this.logger.verbose("[Pool@" + this.poolName + ",id=" + id + "] getConnection() - All loaded conn's in use... loaded(" + numberOfLoadedConnections + ") of base(" + this.iBase + ")");
                        StringBuffer stack = new StringBuffer();
                        try {
                            throw new Exception();
                        }
                        catch (Exception e) {
                            StackTraceElement[] els;
                            for (StackTraceElement el : els = e.getStackTrace()) {
                                stack.append("\t");
                                stack.append(el.toString());
                                stack.append("\n");
                            }
                            this.logger.email("NOFREE", "Pool has no free connections - in use(" + numberOfLoadedConnections + "), base(" + this.iBase + ") : " + new Date() + "\n" + stack.toString());
                            if (this.bQueueConnectionRequests) break block25;
                            throw new PoolHasNoFreeConnections();
                        }
                    }
                }
            }
            this.logger.verbose("[Pool@" + this.poolName + ",id=" + id + "] getConnection() took " + (System.currentTimeMillis() - now) + "ms");
        }
        if (retCH == null) {
            return null;
        }
        boolean conOK = this.checkIfConnectionIsValid(retCH.conn, id);
        if (!conOK) {
            this.logger.verbose("[Pool@" + this.poolName + ",id=" + id + "] getConnection() Dumping " + retCH.conn + " because it failed validity checks.");
            try {
                retCH.conn.closePhysical();
            }
            catch (SQLException sqle) {
                this.logger.printStackTrace(sqle);
            }
            this.connections.remove(retCH);
            this.notifyExceptionEvent();
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            return this.internalGetConnection(id);
        }
        return retCH.conn;
    }

    private String getCallerString() {
        try {
            throw new Exception();
        }
        catch (Exception e) {
            int maxBacktraceCount = 5;
            StackTraceElement[] ste = e.getStackTrace();
            StringBuffer caller = new StringBuffer(100);
            boolean start = false;
            for (int i = 0; i < ste.length; ++i) {
                if (ste[i].getClassName().endsWith("PrimroseDataSource")) {
                    start = true;
                    continue;
                }
                if (!start || maxBacktraceCount <= 0) continue;
                if (--maxBacktraceCount == 0) {
                    caller.append(ste[i].getFileName() + "[method:" + ste[i].getMethodName() + ",line:" + ste[i].getLineNumber() + "]");
                    continue;
                }
                caller.append(ste[i].getFileName() + "[method:" + ste[i].getMethodName() + ",line:" + ste[i].getLineNumber() + "], ");
            }
            return caller.toString();
        }
    }

    protected final void setConnectionDefaults(ConnectionHolder ch, long id) throws PoolException {
        if (DebugLogger.getEnabled()) {
            DebugLogger.log("[Pool@" + this.poolName + ",id=" + id + "] setConnectionDefaults() start");
        }
        PoolConnection c = ch.conn;
        try {
            if (c.getAutoCommit() != this.bConnectionAutoCommit) {
                if (ch.numberOfOpens > 0) {
                    this.logger.warn("[Pool@" + this.poolName + ",id=" + id + "] setConnectionDefaults() : Checking autocommit value : Looks like someone has changed it from the default, and has not set it back. Default should be '" + this.bConnectionAutoCommit + "', but the connection value is '" + c.getAutoCommit() + "'");
                }
                c.setAutoCommit(this.bConnectionAutoCommit);
            }
        }
        catch (SQLException sqle) {
            this.logger.printStackTrace(sqle);
            ch.closeBehaviour = 14;
            ch.conn.close();
            this.connections.remove(ch);
            this.logger.warn("[Pool@" + this.poolName + ",id=" + id + "] setConnectionDefaults() : Error checking auto commit. Connection will be dumped.");
            this.notifyExceptionEvent();
            throw new CannotConnectException("Checking auto commit value errored : " + sqle.toString(), sqle);
        }
        if (this.iConnectionTransactionIsolation != -1) {
            try {
                if (c.getTransactionIsolation() != this.iConnectionTransactionIsolation) {
                    if (ch.numberOfOpens > 0) {
                        this.logger.warn("[Pool@" + this.poolName + ",id=" + id + "] setConnectionDefaults() : Checking transaction isolation level : Looks like someone has changed it from the default, and has not set it back. Default should be '" + this.getInternalConnectionTransactionIsolation() + "', but the connection value is '" + this.getInternalConnectionTransactionIsolation(c.getTransactionIsolation()) + "'");
                    }
                    c.setTransactionIsolation(this.iConnectionTransactionIsolation);
                }
            }
            catch (SQLException sqle) {
                this.logger.printStackTrace(sqle);
                ch.closeBehaviour = 14;
                ch.conn.close();
                this.connections.remove(ch);
                this.logger.warn("[Pool@" + this.poolName + ",id=" + id + "] setConnectionDefaults() : Error checking transaction isolation level. Connection will be dumped.");
                this.notifyExceptionEvent();
                throw new CannotConnectException("Checking transaction isolation level value errored : " + sqle.toString(), sqle);
            }
        }
        if (DebugLogger.getEnabled()) {
            DebugLogger.log("[Pool@" + this.poolName + ",id=" + id + "] setConnectionDefaults() leave");
        }
    }

    private final boolean checkIfConnectionIsValid(Connection c, long id) {
        if (DebugLogger.getEnabled()) {
            DebugLogger.log("[Pool@" + this.poolName + ",id=" + id + "] checkIfConnectionIsValid() start");
        }
        long now = System.currentTimeMillis();
        boolean checkret = false;
        try {
            checkret = c.isClosed();
            checkret = true;
        }
        catch (SQLException e) {
            this.logger.error("[Pool@" + this.poolName + ",id=" + id + "] checkIfConnectionIsValid() : Error calling isClosed() on connection " + c + " : " + e);
        }
        if (!checkret) {
            return false;
        }
        if (this.checkSQL != null && this.checkSQL.length() > 0) {
            this.logger.verbose("[Pool@" + this.poolName + ",id=" + id + "] checkIfConnectionIsValid() : running checkSQL : " + this.checkSQL);
            checkret = ((PoolConnection)c).runCheckSQL(this.checkSQL);
        }
        this.logger.verbose("[Pool@" + this.poolName + ",id=" + id + "] checkIfConnectionIsValid(" + checkret + ") : took " + (System.currentTimeMillis() - now) + " ms");
        return checkret;
    }

    private final Connection getNonPooledConnection(long id) throws PoolException {
        if (DebugLogger.getEnabled()) {
            DebugLogger.log("[Pool@" + this.poolName + ",id=" + id + "] getNonPooledConnection() start");
        }
        ConnectionHolder ch = this.loadConnection(false, id);
        this.initializeConnection(ch, id);
        ch.closeBehaviour = 14;
        if (DebugLogger.getEnabled()) {
            DebugLogger.log("[Pool@" + this.poolName + ",id=" + id + "] getNonPooledConnection() end : " + ch.conn);
        }
        return ch.conn;
    }

    private final ConnectionHolder loadConnection(boolean addToList, long id) throws PoolException {
        PoolConnection pc;
        if (DebugLogger.getEnabled()) {
            DebugLogger.log("[Pool@" + this.poolName + ",id=" + id + "] loadConnection() start");
        }
        Connection raw = Util.getConnection(this.logger, this.driverClass, this.driverURL, this.user, this.password);
        ConnectionHolder ch = new ConnectionHolder();
        ch.conn = pc = new PoolConnection(raw, ch);
        ch.closeBehaviour = 15;
        ch.status = 2;
        ch.lock = this.lock;
        ch.poolName = this.poolName;
        ch.bDumpConnectionOnSQLException = this.bDumpConnectionOnSQLException;
        ch.myPool = this;
        ch.logger = this.logger;
        this.setConnectionDefaults(ch, id);
        if (addToList) {
            this.connections.addElement(ch);
        }
        return ch;
    }

    public final void stop(boolean force) throws PoolException {
        if (this.bPoolHasBeenShutdown) {
            this.logger.warn("[Pool@" + this.poolName + "] stop() Pool has already been shutdown ... not doing it twice.");
            return;
        }
        this.logger.email("STOP", "Pool stopping at : " + new Date());
        this.logger.info("[Pool@" + this.poolName + "] stop() Stopping pool with force=" + force + " ...");
        this.poolAccessLocked = true;
        if (this.failoverCutBackObj != null) {
            this.failoverCutBackObj.stopIt();
        }
        for (ConnectionHolder ch : this.connections) {
            try {
                if (force) {
                    ch.conn.closePhysical();
                    continue;
                }
                if (ch.status == 2) {
                    ch.conn.closePhysical();
                    continue;
                }
                ch.closeBehaviour = 14;
            }
            catch (SQLException e) {
                this.logger.printStackTrace(e);
            }
        }
        this.connections.removeAllElements();
        this.logger.info("[Pool@" + this.poolName + "] stop() Shutting down pool monitor.");
        if (this.monitor != null) {
            this.monitor.shutdown();
        }
        this.logger.info("[Pool@" + this.poolName + "] stop() Stop Complete.");
        this.logger.close();
        this.bPoolHasBeenShutdown = true;
    }

    public final void start() throws PoolException {
        this.setUpLogger();
        this.gid = 0L;
        this.bPoolHasBeenShutdown = false;
        this.logger.info("[Pool@" + this.poolName + "] STARTING " + this.poolName + " ...");
        this.logger.verbose("[Pool@" + this.poolName + "] Checking " + this.poolName + " parameters ...");
        for (LoadRule rule : this.loadRules) {
            rule.runCheck(this, this.logger);
        }
        this.logger.email("START", "Pool starting at : " + new Date());
        Util.printGetMethodValues("[Pool@" + this.poolName + "] config item : ", this.logger, PoolConfigImpl.class, this);
        this.poolAccessLocked = true;
        this.connections = new Vector();
        this.numberOfWaitingThreads = 0;
        this.totalConnectionsHandedOut = 0;
        if (this.iNumberOfConnectionsToInitializeWith > this.iBase) {
            this.logger.warn("[Pool@" + this.poolName + "] start() The number of connections to initialise with is greater than the number of base connections ... adjusting init number to base : " + this.iBase);
            this.iNumberOfConnectionsToInitializeWith = this.iBase;
        }
        this.logger.verbose("[Pool@" + this.poolName + "] start() Loading " + this.iNumberOfConnectionsToInitializeWith + " Connection(s) on init");
        for (int i = 0; i < this.iNumberOfConnectionsToInitializeWith; ++i) {
            try {
                PoolConnection pc = this.loadConnection((boolean)true, (long)((long)i)).conn;
                if (i != 0) continue;
                DatabaseMetaData conMD = pc.getMetaData();
                this.logger.info("[Pool@" + this.poolName + "] start() Primrose version " + "3.0.14" + ", release date " + "26-July-2009");
                this.logger.info("[Pool@" + this.poolName + "] start() JDBC Driver Name: " + conMD.getDriverName());
                this.logger.info("[Pool@" + this.poolName + "] start() JDBC Driver Version: " + conMD.getDriverVersion());
                continue;
            }
            catch (Throwable t) {
                this.logger.warn("[Pool@" + this.poolName + "] start() Could not connect to db - is this OK ?");
                this.logger.printStackTrace(t);
            }
        }
        this.logger.info("[Pool@" + this.poolName + "] start() Starting new pool monitor.");
        this.monitor = new PoolMonitor(this, this.logger);
        this.monitor.start();
        this.logger.info("[Pool@" + this.poolName + "] start() Load complete.");
        this.poolAccessLocked = false;
    }

    public final Vector<ConnectionHolder> getPoolConnections() {
        return this.connections;
    }

    public final void restart(boolean forceStop) throws PoolException {
        this.logger.info("[Pool@" + this.poolName + "] restart() Restarting pool ...");
        this.stop(forceStop);
        this.start();
        this.logger.info("[Pool@" + this.poolName + "] restart() Restart Complete ...");
    }

    public Logger getLogger() {
        return this.logger;
    }

    protected void notifyExceptionEvent() {
        boolean bHasCrashed;
        if (this.emailEvents != null) {
            boolean notifyCrash;
            boolean notifyException = this.emailEvents.toUpperCase().indexOf("EXCEPTION".toUpperCase()) > -1;
            boolean bl = notifyCrash = this.emailEvents.toUpperCase().indexOf("DBCRASH".toUpperCase()) > -1;
            if (notifyException) {
                this.logger.email("EXCEPTION", "SQLException has occured in pool " + this.poolName);
            }
            if (notifyCrash) {
                boolean bHasCrashed2 = this.hasDbCrashed();
                if (notifyCrash && bHasCrashed2) {
                    this.logger.email("DBCRASH", "Database seems to have crashed ! Driver URL : " + this.driverURL);
                }
                if (this.failoverPool != null && this.failoverPoolObj == null) {
                    this.attemptFailover();
                }
            }
        }
        if (this.failoverPool != null && this.failoverPoolObj == null && (bHasCrashed = this.hasDbCrashed())) {
            this.attemptFailover();
        }
    }

    private boolean hasDbCrashed() {
        boolean bHasCrashed = false;
        this.logger.verbose("[Pool@" + this.poolName + "] About to see if DB has crashed (get new connection & run onExceptionCheckSQL)...");
        try {
            if (DebugLogger.getEnabled()) {
                DebugLogger.log("[Pool@" + this.poolName + "] hasDbCrashed() Loading connection ...");
            }
            ConnectionHolder ch = this.loadConnection(false, -7777L);
            PoolConnection c = ch.conn;
            if (DebugLogger.getEnabled()) {
                DebugLogger.log("[Pool@" + this.poolName + "] hasDbCrashed() Running onExceptionCheckSQL statement ...");
            }
            bHasCrashed = c.runCheckSQL(this.onExceptionCheckSQL);
            if (DebugLogger.getEnabled()) {
                DebugLogger.log("[Pool@" + this.poolName + "] hasDbCrashed() runCheckSQL returned " + bHasCrashed);
            }
            bHasCrashed = !bHasCrashed;
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (SQLException sqle) {}
        }
        catch (PoolException pe) {
            this.logger.printStackTrace(pe);
            bHasCrashed = true;
        }
        if (DebugLogger.getEnabled()) {
            DebugLogger.log("[Pool@" + this.poolName + "] hasDbCrashed ? : " + bHasCrashed);
        }
        return bHasCrashed;
    }

    public void cutbackFromFailoverPool() {
        this.logger.info("[Pool@" + this.poolName + "] Cutting back to this pool from failoverPool " + this.failoverPool);
        this.logger.email("CUTBACK", "Cutting back to this pool from failoverPool " + this.failoverPool);
        try {
            this.stop(false);
            this.start();
            this.failoverPoolObj = null;
            this.logger.info("[Pool@" + this.poolName + "] Cutback to original pool succeeded");
            this.logger.email("CUTBACK", "Cutback to original pool succeeded");
        }
        catch (PoolException pe) {
            this.logger.error("Cutback failed ...");
            this.logger.printStackTrace(pe);
            this.logger.email("CUTBACK", "Cutback failed : " + pe);
        }
    }

    private void attemptFailover() {
        this.logger.info("[Pool@" + this.poolName + "] Now attemping failover to pool '" + this.failoverPool + "'");
        this.logger.email("FAILOVER", "Now attemping failover to pool '" + this.failoverPool + "'");
        try {
            this.logger.info("[Pool@" + this.poolName + "] Finding failoverPool(" + this.failoverPool + ")");
            this.failoverPoolObj = PoolLoader.findExistingPool(this.failoverPool);
            if (this.failoverPoolObj == null) {
                throw new PoolException("Cannot find failoverPool(" + this.failoverPool + ") !");
            }
            this.logger.info("[Pool@" + this.poolName + "] Stopping this pool ...");
            this.stop(true);
            this.poolAccessLocked = false;
            this.logger.info("[Pool@" + this.poolName + "] Testing that can get connection from failoverPool ...");
            Connection c = this.getConnection();
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.logger.info("[Pool@" + this.poolName + "] Starting failover cutback monitor ...");
            this.failoverCutBackObj = new PoolData.FailoverCutBack(this, this, this.logger);
            this.failoverCutBackObj.start();
            this.logger.info("[Pool@" + this.poolName + "] Failover complete. Routing all requests to " + this.poolName + " to " + this.failoverPool);
            this.logger.email("FAILOVER", "Failover complete. Routing all requests to " + this.poolName + " to " + this.failoverPool);
        }
        catch (PoolException pe) {
            this.logger.error("[Pool@" + this.poolName + "] Failover failed : " + pe.toString());
            this.logger.email("FAILOVER", "Failover failed : " + pe.toString());
            this.logger.printStackTrace(pe);
        }
    }
}

