/*
 * Decompiled with CFR 0.152.
 */
package uk.org.primrose;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import uk.org.primrose.Constants;
import uk.org.primrose.DebugLogger;
import uk.org.primrose.GeneralException;
import uk.org.primrose.Logger;
import uk.org.primrose.pool.CannotConnectException;
import uk.org.primrose.pool.core.KeyValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static boolean isConfigParameterValid(String name) {
        if (name == null) {
            return false;
        }
        for (String s : Constants.POOL_CONFIG_ITEM_NAMES) {
            if (!name.equals(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean callClassMethod(Class<?> targetClass, Object targetObj, String methodNameToRun, Object[] args) throws GeneralException {
        if (targetObj == null) {
            throw new GeneralException("Target Object is null !");
        }
        Method[] publicMethods = targetClass.getMethods();
        boolean foundMethodToRun = false;
        int argsLength = 0;
        if (args != null) {
            argsLength = args.length;
        }
        for (Method element : publicMethods) {
            String methodName = element.getName();
            int numOfArgs = element.getParameterTypes().length;
            if (!methodNameToRun.equalsIgnoreCase(methodName) || numOfArgs != argsLength) continue;
            try {
                element.invoke(targetObj, args);
                foundMethodToRun = true;
                break;
            }
            catch (Exception e) {
                throw new GeneralException("Error invoking " + targetClass.getName() + "." + methodNameToRun, e);
            }
        }
        return foundMethodToRun;
    }

    public static void printGetMethodValues(String prefixData, Logger logger, Class<?> targetClass, Object targetObj) {
        Method[] publicMethods;
        if (targetObj == null) {
            return;
        }
        for (Method element : publicMethods = targetClass.getMethods()) {
            String methodName = element.getName();
            int numOfArgs = element.getParameterTypes().length;
            if (!methodName.startsWith("get") || numOfArgs != 0) continue;
            try {
                if (methodName.toLowerCase().indexOf("password".toLowerCase()) != -1 || methodName.toLowerCase().indexOf("user".toLowerCase()) != -1) continue;
                String value = (String)element.invoke(targetObj, new Object[0]);
                methodName = methodName.substring(3, methodName.length());
                String camelName = (methodName.charAt(0) + "").toLowerCase() + methodName.substring(1, methodName.length());
                logger.info(prefixData + camelName + "='" + value + "'");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static Connection getConnection(Logger logger, String driver, String url, String username, String password) throws CannotConnectException {
        try {
            DebugLogger.log("About to load driver into JVM : " + driver);
            Class.forName(driver);
            DebugLogger.log("About to get connect from db using url(" + driver + "), user(" + username + "), password(" + password + ")");
            Connection c = DriverManager.getConnection(url, username, password);
            if (c == null) {
                throw new CannotConnectException("When getting a new connection from the db, no error was thrown, but the connection was null");
            }
            return c;
        }
        catch (Exception e) {
            String message = "Cannot connect to db using driver (" + driver + "), url(" + url + "), username(" + username + ")";
            logger.error(message);
            logger.printStackTrace(e);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            e.printStackTrace(ps);
            byte[] stack = baos.toByteArray();
            try {
                baos.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            ps.close();
            logger.email("EXCEPTION", message + "\r\n" + new String(stack));
            throw new CannotConnectException(message, e);
        }
    }

    public static Properties generatePropertiesForPoolName(String configFile, String poolNameToFind) throws IOException {
        String line;
        Properties p = null;
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(configFile)));
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
            KeyValuePair keyValuePair = new KeyValuePair(line);
            keyValuePair.splitLine();
            String key = keyValuePair.getKey();
            String value = keyValuePair.getValue();
            String lastKey = null;
            if (!Util.isConfigParameterValid(key) && lastKey != null && lastKey.equalsIgnoreCase("driverURL")) {
                if (p == null) continue;
                p.setProperty(lastKey, p.getProperty(lastKey) + line);
                continue;
            }
            if (key.equals("poolName")) {
                if (p != null) break;
                if (value.equals(poolNameToFind)) {
                    p = new Properties();
                }
            }
            if (p != null) {
                p.setProperty(key, value);
            }
            lastKey = key;
        }
        br.close();
        return p;
    }
}

