/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.support;

import org.springframework.expression.TypeComparator;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;

public class StandardTypeComparator
implements TypeComparator {
    public int compare(Object left, Object right) throws SpelEvaluationException {
        if (left == null) {
            return right == null ? 0 : 1;
        }
        if (right == null) {
            return -1;
        }
        if (left instanceof Number && right instanceof Number) {
            Number leftNumber = (Number)left;
            Number rightNumber = (Number)right;
            if (leftNumber instanceof Double || rightNumber instanceof Double) {
                double d1 = leftNumber.doubleValue();
                double d2 = rightNumber.doubleValue();
                return Double.compare(d1, d2);
            }
            if (leftNumber instanceof Float || rightNumber instanceof Float) {
                float f1 = leftNumber.floatValue();
                float f2 = rightNumber.floatValue();
                return Float.compare(f1, f2);
            }
            if (leftNumber instanceof Long || rightNumber instanceof Long) {
                Long l1 = leftNumber.longValue();
                Long l2 = rightNumber.longValue();
                return l1.compareTo(l2);
            }
            Integer i1 = leftNumber.intValue();
            Integer i2 = rightNumber.intValue();
            return i1.compareTo(i2);
        }
        try {
            if (left instanceof Comparable) {
                return ((Comparable)left).compareTo(right);
            }
        }
        catch (ClassCastException cce) {
            throw new SpelEvaluationException(cce, SpelMessage.NOT_COMPARABLE, left.getClass(), right.getClass());
        }
        throw new SpelEvaluationException(SpelMessage.NOT_COMPARABLE, left.getClass(), right.getClass());
    }

    public boolean canCompare(Object left, Object right) {
        if (left == null || right == null) {
            return true;
        }
        if (left instanceof Number && right instanceof Number) {
            return true;
        }
        return left instanceof Comparable;
    }
}

