/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class PortletSessionListenerManager
implements HttpSessionListener {
    private static List<HttpSessionListener> _listeners = new ArrayList<HttpSessionListener>();

    public static void addListener(HttpSessionListener listener) {
        _listeners.add(listener);
    }

    public static void removeListener(HttpSessionListener listener) {
        _listeners.remove(listener);
    }

    public void sessionCreated(HttpSessionEvent event) {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            for (HttpSessionListener listener : _listeners) {
                ClassLoader listenerClassLoader = listener.getClass().getClassLoader();
                currentThread.setContextClassLoader(listenerClassLoader);
                listener.sessionCreated(event);
            }
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        for (HttpSessionListener listener : _listeners) {
            listener.sessionDestroyed(event);
        }
    }
}

