/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.NoSuchModelException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.TermQuery;
import com.liferay.portal.kernel.search.TermQueryFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetCategoryServiceUtil;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseIndexer
implements Indexer {
    private static final boolean _FILTER_SEARCH = false;
    public static final int INDEX_FILTER_SEARCH_LIMIT = GetterUtil.getInteger(PropsUtil.get("index.filter.search.limit"));
    private static final String[] _KEYWORDS_FIELDS = new String[]{"assetTagNames", "comments", "content", "description", "properties", "title", "url", "userName"};
    private static Log _log = LogFactoryUtil.getLog(BaseIndexer.class);

    public void delete(Object obj) throws SearchException {
        try {
            this.doDelete(obj);
        }
        catch (SearchException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    public Document getDocument(Object obj) throws SearchException {
        try {
            return this.doGetDocument(obj);
        }
        catch (SearchException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    public void reindex(Object obj) throws SearchException {
        try {
            if (SearchEngineUtil.isIndexReadOnly()) {
                return;
            }
            this.doReindex(obj);
        }
        catch (SearchException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    public void reindex(String className, long classPK) throws SearchException {
        try {
            if (SearchEngineUtil.isIndexReadOnly()) {
                return;
            }
            this.doReindex(className, classPK);
        }
        catch (NoSuchModelException noSuchModelException) {
            if (_log.isWarnEnabled()) {
                _log.warn("Unable to index " + className + " " + classPK);
            }
        }
        catch (SearchException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    public void reindex(String[] ids) throws SearchException {
        try {
            if (SearchEngineUtil.isIndexReadOnly()) {
                return;
            }
            this.doReindex(ids);
        }
        catch (SearchException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    public Hits search(SearchContext searchContext) throws SearchException {
        try {
            String className = this.getClassName(searchContext);
            BooleanQuery contextQuery = BooleanQueryFactoryUtil.create();
            this.addSearchAssetCategoryIds(contextQuery, searchContext);
            this.addSearchAssetTagNames(contextQuery, searchContext);
            this.addSearchGroupId(contextQuery, searchContext);
            this.addSearchOwnerUserId(contextQuery, searchContext);
            this.addSearchCategoryIds(contextQuery, searchContext);
            this.addSearchNodeIds(contextQuery, searchContext);
            this.addSearchFolderIds(contextQuery, searchContext);
            this.addSearchPortletIds(contextQuery, searchContext);
            BooleanQuery fullQuery = this.createFullQuery(contextQuery, searchContext);
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            int start = searchContext.getStart();
            int end = searchContext.getEnd();
            if (this.isFilterSearch() && permissionChecker != null) {
                start = 0;
                end += INDEX_FILTER_SEARCH_LIMIT;
            }
            Hits hits = SearchEngineUtil.search(searchContext.getCompanyId(), searchContext.getGroupIds(), searchContext.getUserId(), className, (Query)fullQuery, searchContext.getSorts(), start, end);
            if (this.isFilterSearch() && permissionChecker != null) {
                hits = this.filterSearch(hits, permissionChecker, searchContext);
            }
            return hits;
        }
        catch (SearchException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    protected void addSearchAssetCategoryIds(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        long[] assetCategoryIds = searchContext.getAssetCategoryIds();
        if (assetCategoryIds == null || assetCategoryIds.length == 0) {
            return;
        }
        BooleanQuery assetCategoryIdsQuery = BooleanQueryFactoryUtil.create();
        long[] lArray = assetCategoryIds;
        int n = assetCategoryIds.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                long assetCategoryId = lArray[n2];
                if (searchContext.getUserId() > 0L) {
                    try {
                        AssetCategoryServiceUtil.getCategory(assetCategoryId);
                    }
                    catch (Exception exception) {
                        break block6;
                    }
                }
                TermQuery termQuery = TermQueryFactoryUtil.create("assetCategoryIds", assetCategoryId);
                assetCategoryIdsQuery.add((Query)termQuery, BooleanClauseOccur.MUST);
            }
            ++n2;
        }
        if (!assetCategoryIdsQuery.clauses().isEmpty()) {
            contextQuery.add((Query)assetCategoryIdsQuery, BooleanClauseOccur.MUST);
        }
    }

    protected void addSearchAssetTagNames(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        String[] assetTagNames = searchContext.getAssetTagNames();
        if (assetTagNames == null || assetTagNames.length == 0) {
            return;
        }
        BooleanQuery assetTagNamesQuery = BooleanQueryFactoryUtil.create();
        String[] stringArray = assetTagNames;
        int n = assetTagNames.length;
        int n2 = 0;
        while (n2 < n) {
            String assetTagName = stringArray[n2];
            TermQuery termQuery = TermQueryFactoryUtil.create("assetTagNames", assetTagName);
            assetTagNamesQuery.add((Query)termQuery, BooleanClauseOccur.MUST);
            ++n2;
        }
        if (!assetTagNamesQuery.clauses().isEmpty()) {
            contextQuery.add((Query)assetTagNamesQuery, BooleanClauseOccur.MUST);
        }
    }

    protected void addSearchCategoryIds(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        long[] categoryIds = searchContext.getCategoryIds();
        if (categoryIds == null || categoryIds.length == 0) {
            return;
        }
        BooleanQuery categoryIdsQuery = BooleanQueryFactoryUtil.create();
        long[] lArray = categoryIds;
        int n = categoryIds.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                long categoryId = lArray[n2];
                if (searchContext.getUserId() > 0L) {
                    try {
                        this.checkSearchCategoryId(categoryId, searchContext);
                    }
                    catch (Exception exception) {
                        break block6;
                    }
                }
                TermQuery termQuery = TermQueryFactoryUtil.create("categoryId", categoryId);
                categoryIdsQuery.add((Query)termQuery, BooleanClauseOccur.SHOULD);
            }
            ++n2;
        }
        if (!categoryIdsQuery.clauses().isEmpty()) {
            contextQuery.add((Query)categoryIdsQuery, BooleanClauseOccur.MUST);
        }
    }

    protected void addSearchFolderIds(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        long[] folderIds = searchContext.getFolderIds();
        if (folderIds == null || folderIds.length == 0) {
            return;
        }
        BooleanQuery folderIdsQuery = BooleanQueryFactoryUtil.create();
        long[] lArray = folderIds;
        int n = folderIds.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                long folderId = lArray[n2];
                if (searchContext.getUserId() > 0L) {
                    try {
                        this.checkSearchFolderId(folderId, searchContext);
                    }
                    catch (Exception exception) {
                        break block6;
                    }
                }
                TermQuery termQuery = TermQueryFactoryUtil.create("folderId", folderId);
                folderIdsQuery.add((Query)termQuery, BooleanClauseOccur.SHOULD);
            }
            ++n2;
        }
        if (!folderIdsQuery.clauses().isEmpty()) {
            contextQuery.add((Query)folderIdsQuery, BooleanClauseOccur.MUST);
        }
    }

    protected void addSearchGroupId(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        long[] groupIds = searchContext.getGroupIds();
        if (groupIds == null || groupIds.length == 0 || groupIds.length == 1 && groupIds[0] == 0L) {
            return;
        }
        BooleanQuery groupIdsQuery = BooleanQueryFactoryUtil.create();
        int i = 0;
        while (i < groupIds.length) {
            long groupId = groupIds[i];
            if (groupId > 0L) {
                try {
                    Group group = GroupLocalServiceUtil.getGroup(groupId);
                    long parentGroupId = groupId;
                    if (group.isLayout() || searchContext.isScopeStrict()) {
                        contextQuery.addRequiredTerm("scopeGroupId", groupId);
                    }
                    if (group.isLayout()) {
                        parentGroupId = group.getParentGroupId();
                    }
                    groupIdsQuery.addTerm("groupId", parentGroupId);
                    groupIds[i] = parentGroupId;
                }
                catch (Exception exception) {}
            }
            ++i;
        }
        searchContext.setGroupIds(groupIds);
        if (!groupIdsQuery.clauses().isEmpty()) {
            contextQuery.add((Query)groupIdsQuery, BooleanClauseOccur.MUST);
        }
    }

    protected void addSearchKeywords(BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
        String keywords = searchContext.getKeywords();
        if (Validator.isNull(keywords)) {
            return;
        }
        searchQuery.addTerms(_KEYWORDS_FIELDS, keywords);
    }

    protected void addSearchNodeIds(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        long[] nodeIds = searchContext.getNodeIds();
        if (nodeIds == null || nodeIds.length == 0) {
            return;
        }
        BooleanQuery nodeIdsQuery = BooleanQueryFactoryUtil.create();
        long[] lArray = nodeIds;
        int n = nodeIds.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                long nodeId = lArray[n2];
                if (searchContext.getUserId() > 0L) {
                    try {
                        this.checkSearchNodeId(nodeId, searchContext);
                    }
                    catch (Exception exception) {
                        break block6;
                    }
                }
                TermQuery termQuery = TermQueryFactoryUtil.create("nodeId", nodeId);
                nodeIdsQuery.add((Query)termQuery, BooleanClauseOccur.SHOULD);
            }
            ++n2;
        }
        if (!nodeIdsQuery.clauses().isEmpty()) {
            contextQuery.add((Query)nodeIdsQuery, BooleanClauseOccur.MUST);
        }
    }

    protected void addSearchOwnerUserId(BooleanQuery contextQuery, SearchContext searchContext) {
        long ownerUserId = searchContext.getOwnerUserId();
        if (ownerUserId > 0L) {
            contextQuery.addRequiredTerm("userId", ownerUserId);
        }
    }

    protected void addSearchPortletIds(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        String[] portletIds = searchContext.getPortletIds();
        if (portletIds == null || portletIds.length == 0) {
            contextQuery.addRequiredTerm("portletId", this.getPortletId(searchContext));
        } else {
            BooleanQuery portletIdsQuery = BooleanQueryFactoryUtil.create();
            String[] stringArray = portletIds;
            int n = portletIds.length;
            int n2 = 0;
            while (n2 < n) {
                String portletId = stringArray[n2];
                if (!Validator.isNull(portletId)) {
                    TermQuery termQuery = TermQueryFactoryUtil.create("portletId", portletId);
                    portletIdsQuery.add((Query)termQuery, BooleanClauseOccur.SHOULD);
                }
                ++n2;
            }
            if (!portletIdsQuery.clauses().isEmpty()) {
                contextQuery.add((Query)portletIdsQuery, BooleanClauseOccur.MUST);
            }
        }
    }

    protected void checkSearchCategoryId(long categoryId, SearchContext searchContext) throws Exception {
    }

    protected void checkSearchFolderId(long folderId, SearchContext searchContext) throws Exception {
    }

    protected void checkSearchNodeId(long nodeId, SearchContext searchContext) throws Exception {
    }

    protected BooleanQuery createFullQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        BooleanClause[] booleanClauses;
        this.postProcessContextQuery(contextQuery, searchContext);
        BooleanQuery searchQuery = BooleanQueryFactoryUtil.create();
        this.addSearchKeywords(searchQuery, searchContext);
        this.postProcessSearchQuery(searchQuery, searchContext);
        BooleanQuery fullQuery = BooleanQueryFactoryUtil.create();
        fullQuery.add((Query)contextQuery, BooleanClauseOccur.MUST);
        if (!searchQuery.clauses().isEmpty()) {
            fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
        }
        if ((booleanClauses = searchContext.getBooleanClauses()) != null) {
            BooleanClause[] booleanClauseArray = booleanClauses;
            int n = booleanClauses.length;
            int n2 = 0;
            while (n2 < n) {
                BooleanClause booleanClause = booleanClauseArray[n2];
                fullQuery.add(booleanClause.getQuery(), booleanClause.getBooleanClauseOccur());
                ++n2;
            }
        }
        this.postProcessFullQuery(fullQuery, searchContext);
        return fullQuery;
    }

    protected abstract void doDelete(Object var1) throws Exception;

    protected abstract Document doGetDocument(Object var1) throws Exception;

    protected abstract void doReindex(Object var1) throws Exception;

    protected abstract void doReindex(String var1, long var2) throws Exception;

    protected abstract void doReindex(String[] var1) throws Exception;

    protected Hits filterSearch(Hits hits, PermissionChecker permissionChecker, SearchContext searchContext) {
        List docs = new ArrayList<Document>();
        ArrayList<Float> scores = new ArrayList<Float>();
        int i = 0;
        while (i < hits.getLength()) {
            Document doc = hits.doc(i);
            long entryClassPK = GetterUtil.getLong(doc.get("entryClassPK"));
            try {
                if (this.hasPermission(permissionChecker, entryClassPK, "VIEW")) {
                    docs.add(hits.doc(i));
                    scores.add(Float.valueOf(hits.score(i)));
                }
            }
            catch (Exception exception) {}
            ++i;
        }
        int length = docs.size();
        hits.setLength(length);
        int start = searchContext.getStart();
        int end = searchContext.getEnd();
        if (start != -1 && end != -1) {
            if (end > length) {
                end = length;
            }
            docs = docs.subList(start, end);
        }
        hits.setDocs(docs.toArray(new Document[docs.size()]));
        hits.setScores(scores.toArray(new Float[docs.size()]));
        hits.setSearchTime((float)(System.currentTimeMillis() - hits.getStart()) / 1000.0f);
        return hits;
    }

    protected String getClassName(SearchContext searchContext) {
        String[] classNames = this.getClassNames();
        if (classNames.length != 1) {
            throw new UnsupportedOperationException("Search method needs to be manually implemented for indexers with more than one class name");
        }
        return classNames[0];
    }

    protected long getParentGroupId(long groupId) {
        long parentGroupId = groupId;
        try {
            Group group = GroupLocalServiceUtil.getGroup(groupId);
            if (group.isLayout()) {
                parentGroupId = group.getParentGroupId();
            }
        }
        catch (Exception exception) {}
        return parentGroupId;
    }

    protected abstract String getPortletId(SearchContext var1);

    protected boolean hasPermission(PermissionChecker permissionChecker, long entryClassPK, String actionId) throws Exception {
        return true;
    }

    protected boolean isFilterSearch() {
        return false;
    }

    protected void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
    }

    protected void postProcessFullQuery(BooleanQuery fullQuery, SearchContext searchContext) throws Exception {
    }

    protected void postProcessSearchQuery(BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
    }
}

