/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.deploy.hot;

import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.kernel.deploy.hot.HotDeployListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.BasePortalLifecycle;
import com.liferay.portal.kernel.util.PortalLifecycleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class HotDeployUtil {
    private static Log _log = LogFactoryUtil.getLog(HotDeployUtil.class);
    private static HotDeployUtil _instance = new HotDeployUtil();
    private List<HotDeployEvent> _dependentEvents;
    private Set<String> _deployedServletContextNames;
    private List<HotDeployListener> _listeners;
    private boolean _capturePrematureEvents = true;

    public static void fireDeployEvent(HotDeployEvent event) {
        _instance._fireDeployEvent(event);
    }

    public static void fireUndeployEvent(HotDeployEvent event) {
        _instance._fireUndeployEvent(event);
    }

    public static void registerListener(HotDeployListener listener) {
        _instance._registerListener(listener);
    }

    public static void reset() {
        _instance = new HotDeployUtil();
    }

    public static void setCapturePrematureEvents(boolean capturePrematureEvents) {
        _instance._setCapturePrematureEvents(capturePrematureEvents);
    }

    public static void unregisterListener(HotDeployListener listener) {
        _instance._unregisterListener(listener);
    }

    public static void unregisterListeners() {
        _instance._unregisterListeners();
    }

    private HotDeployUtil() {
        if (_log.isInfoEnabled()) {
            _log.info("Initializing hot deploy manager " + this.hashCode());
        }
        this._dependentEvents = new ArrayList<HotDeployEvent>();
        this._deployedServletContextNames = new HashSet<String>();
        this._listeners = new CopyOnWriteArrayList<HotDeployListener>();
    }

    private void _doFireDeployEvent(HotDeployEvent event) {
        block10: {
            block11: {
                block9: {
                    if (this._deployedServletContextNames.contains(event.getServletContextName())) {
                        return;
                    }
                    boolean hasDependencies = true;
                    for (String dependentServletContextName : event.getDependentServletContextNames()) {
                        if (this._deployedServletContextNames.contains(dependentServletContextName)) continue;
                        hasDependencies = false;
                        break;
                    }
                    if (!hasDependencies) break block9;
                    if (this._dependentEvents.contains(event) && _log.isInfoEnabled()) {
                        _log.info("Deploying " + event.getServletContextName() + " from queue");
                    }
                    for (HotDeployListener listener : this._listeners) {
                        try {
                            listener.invokeDeploy(event);
                        }
                        catch (HotDeployException hde) {
                            _log.error(hde, hde);
                        }
                    }
                    this._deployedServletContextNames.add(event.getServletContextName());
                    this._dependentEvents.remove(event);
                    ArrayList<HotDeployEvent> dependentEvents = new ArrayList<HotDeployEvent>(this._dependentEvents);
                    for (HotDeployEvent dependentEvent : dependentEvents) {
                        this._doFireDeployEvent(dependentEvent);
                    }
                    break block10;
                }
                if (this._dependentEvents.contains(event)) break block11;
                if (_log.isInfoEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Queueing ");
                    sb.append(event.getServletContextName());
                    sb.append(" for deploy because it is missing ");
                    sb.append(this._getRequiredServletContextNames(event));
                    _log.info(sb.toString());
                }
                this._dependentEvents.add(event);
                break block10;
            }
            if (!_log.isInfoEnabled()) break block10;
            for (HotDeployEvent dependentEvent : this._dependentEvents) {
                StringBuilder sb = new StringBuilder();
                sb.append(dependentEvent.getServletContextName());
                sb.append(" is still in queue because it is missing ");
                sb.append(this._getRequiredServletContextNames(dependentEvent));
                _log.info(sb.toString());
            }
        }
    }

    private void _fireDeployEvent(final HotDeployEvent event) {
        if (this._capturePrematureEvents) {
            BasePortalLifecycle portalLifecycle = new BasePortalLifecycle(){

                protected void doPortalDestroy() {
                }

                protected void doPortalInit() {
                    HotDeployUtil.fireDeployEvent(event);
                }
            };
            PortalLifecycleUtil.register(portalLifecycle);
        } else {
            this._doFireDeployEvent(event);
        }
    }

    private void _fireUndeployEvent(HotDeployEvent event) {
        for (HotDeployListener listener : this._listeners) {
            try {
                listener.invokeUndeploy(event);
            }
            catch (HotDeployException hde) {
                _log.error(hde, hde);
            }
        }
        this._deployedServletContextNames.remove(event.getServletContextName());
    }

    private String _getRequiredServletContextNames(HotDeployEvent event) {
        ArrayList<String> requiredServletContextNames = new ArrayList<String>();
        for (String dependentServletContextName : event.getDependentServletContextNames()) {
            if (this._deployedServletContextNames.contains(dependentServletContextName)) continue;
            requiredServletContextNames.add(dependentServletContextName);
        }
        Collections.sort(requiredServletContextNames);
        return StringUtil.merge(requiredServletContextNames, ", ");
    }

    private void _registerListener(HotDeployListener listener) {
        this._listeners.add(listener);
    }

    private void _setCapturePrematureEvents(boolean capturePrematureEvents) {
        this._capturePrematureEvents = capturePrematureEvents;
    }

    private void _unregisterListener(HotDeployListener listener) {
        this._listeners.remove(listener);
    }

    private void _unregisterListeners() {
        this._listeners.clear();
    }
}

