/*
 * Decompiled with CFR 0.152.
 */
package javax.ccpp;

import javax.ccpp.RationalComparator;

public class Rational
extends Number
implements Comparable {
    private static RationalComparator comparator = RationalComparator.getInstance();
    private int denominator = 1;
    private int numerator = 0;

    public Rational(int numerator, int denominator) throws IllegalArgumentException {
        if (denominator == 0) {
            throw new IllegalArgumentException();
        }
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public Rational(String str) throws NumberFormatException {
        int slash = 0;
        if (str == null) {
            throw new NumberFormatException();
        }
        slash = str.indexOf(47);
        if (slash == -1) {
            this.numerator = new Integer(str);
            this.denominator = 1;
        } else {
            this.numerator = new Integer(str.substring(0, slash));
            this.denominator = new Integer(str.substring(slash + 1));
        }
        if (this.denominator == 0) {
            throw new NumberFormatException();
        }
    }

    public int compareTo(Object o) throws ClassCastException {
        return comparator.compare(this, o);
    }

    public boolean equals(Object o) {
        return o instanceof Rational && comparator.compare(this, o) == 0;
    }

    public int getDenominator() {
        return this.denominator;
    }

    public int getNumerator() {
        return this.numerator;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getNumerator());
        buf.append('/');
        buf.append(this.getDenominator());
        return buf.toString();
    }

    public double doubleValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    public float floatValue() {
        return (float)this.numerator / (float)this.denominator;
    }

    public int intValue() {
        return this.numerator / this.denominator;
    }

    public long longValue() {
        return (long)this.numerator / (long)this.denominator;
    }
}

