/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.util.Util;

public class Metronome
implements Runnable {
    private final Set<Thread> threads = new HashSet<Thread>();
    private int tick = 0;
    private volatile Thread worker = null;
    private int interval = 10;
    private final Lock lock = new ReentrantLock();
    private final Condition cond = this.lock.newCondition();

    public Metronome(int interval) {
        this.interval = interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Thread ... thread) {
        Set<Thread> set = this.threads;
        synchronized (set) {
            this.threads.addAll(Arrays.asList(thread));
            if (this.worker == null || !this.worker.isAlive()) {
                this.worker = new Thread((Runnable)this, "MetronomeThread");
                this.worker.setDaemon(true);
                this.worker.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Thread thread) {
        Set<Thread> set = this.threads;
        synchronized (set) {
            this.threads.remove(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTick() {
        this.lock.lock();
        try {
            int n = this.tick;
            Object var3_2 = null;
            this.lock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor(int tick) {
        this.add(Thread.currentThread());
        while (true) {
            Object var4_3;
            this.lock.lock();
            try {
                if (tick > this.tick) {
                    try {
                        this.cond.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                } else {
                    var4_3 = null;
                    this.lock.unlock();
                    return;
                }
                var4_3 = null;
                this.lock.unlock();
            }
            catch (Throwable throwable) {
                var4_3 = null;
                this.lock.unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.worker = null;
        Set<Thread> set = this.threads;
        synchronized (set) {
            this.threads.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.worker != null && Thread.currentThread().equals(this.worker)) {
            boolean all_blocked = true;
            Set<Thread> set = this.threads;
            synchronized (set) {
                if (this.threads.isEmpty()) {
                    break;
                }
                for (Thread tmp : this.threads) {
                    Thread.State state = tmp.getState();
                    if (state == Thread.State.WAITING || state == Thread.State.BLOCKED) continue;
                    all_blocked = false;
                    break;
                }
            }
            if (all_blocked) {
                Object var8_6;
                this.lock.lock();
                try {
                    ++this.tick;
                    this.cond.signalAll();
                    var8_6 = null;
                    this.lock.unlock();
                }
                catch (Throwable throwable) {
                    var8_6 = null;
                    this.lock.unlock();
                    throw throwable;
                }
            }
            Util.sleep(this.interval);
        }
        this.worker = null;
    }
}

