/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.diff.html.ancestor;

import java.util.Locale;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.outerj.daisy.diff.html.ancestor.AncestorComparator;
import org.outerj.daisy.diff.html.ancestor.ChangeText;
import org.outerj.daisy.diff.html.ancestor.tagtostring.TagToStringFactory;
import org.outerj.daisy.diff.html.dom.TagNode;

public class ChangeTextGenerator {
    private AncestorComparator ancestorComparator;
    private AncestorComparator other;
    private TagToStringFactory factory;
    private Locale locale;

    public ChangeTextGenerator(AncestorComparator ancestorComparator, AncestorComparator other, Locale locale) {
        this.ancestorComparator = ancestorComparator;
        this.other = other;
        this.factory = new TagToStringFactory();
        this.locale = locale;
    }

    public ChangeText getChanged(RangeDifference ... differences) {
        ChangeText txt = new ChangeText(55);
        boolean rootlistopened = false;
        if (differences.length > 1) {
            txt.addHtml("<ul class='changelist'>");
            rootlistopened = true;
        }
        for (int j = 0; j < differences.length; ++j) {
            int i;
            RangeDifference d = differences[j];
            boolean lvl1listopened = false;
            if (rootlistopened) {
                txt.addHtml("<li>");
            }
            if (d.leftLength() + d.rightLength() > 1) {
                txt.addHtml("<ul class='changelist'>");
                lvl1listopened = true;
            }
            for (i = d.leftStart(); i < d.leftEnd(); ++i) {
                if (lvl1listopened) {
                    txt.addHtml("<li>");
                }
                this.addTagOld(txt, this.other.getAncestor(i));
                if (!lvl1listopened) continue;
                txt.addHtml("</li>");
            }
            for (i = d.rightStart(); i < d.rightEnd(); ++i) {
                if (lvl1listopened) {
                    txt.addHtml("<li>");
                }
                this.addTagNew(txt, this.getAncestor(i));
                if (!lvl1listopened) continue;
                txt.addHtml("</li>");
            }
            if (lvl1listopened) {
                txt.addHtml("</ul>");
            }
            if (!rootlistopened) continue;
            txt.addHtml("</li>");
        }
        if (rootlistopened) {
            txt.addHtml("</ul>");
        }
        return txt;
    }

    private void addTagOld(ChangeText txt, TagNode ancestor) {
        this.factory.create(ancestor, this.locale).getRemovedDescription(txt);
    }

    private void addTagNew(ChangeText txt, TagNode ancestor) {
        this.factory.create(ancestor, this.locale).getAddedDescription(txt);
    }

    private TagNode getAncestor(int i) {
        return this.ancestorComparator.getAncestor(i);
    }
}

