/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.custom.communitymanager.components;

import java.util.List;
import org.gcube.portal.custom.communitymanager.components.GCUBEPortlet;
import org.gcube.portal.custom.communitymanager.types.GCUBELayoutType;

public class GCUBELayoutTab {
    String caption;
    String description;
    String friendlyURL;
    boolean hidden;
    private GCUBELayoutType type;
    private List<GCUBEPortlet> portlets;

    public GCUBELayoutTab(String caption, GCUBELayoutType type, List<GCUBEPortlet> portlets) {
        this.caption = caption;
        this.friendlyURL = "/" + caption.replaceAll(" ", "-");
        this.portlets = portlets;
        this.type = type;
    }

    public GCUBELayoutTab(String caption, String description, GCUBELayoutType type, List<GCUBEPortlet> portlets) {
        this.caption = caption;
        this.description = description;
        this.friendlyURL = "/" + caption;
        this.portlets = portlets;
        this.type = type;
    }

    public GCUBELayoutType getType() {
        return this.type;
    }

    public List<GCUBEPortlet> getPortlets() {
        return this.portlets;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getFriendlyURL() {
        return this.friendlyURL;
    }

    public void setFriendlyURL(String friendlyURL) {
        this.friendlyURL = friendlyURL;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public String getLayoutTypeSettings() {
        String typeSettings = "";
        switch (this.getType()) {
            case ONE_COL: {
                typeSettings = "layout-template-id=1_column\n";
                break;
            }
            case TWO_COL_5050: {
                typeSettings = "layout-template-id=2_columns_i\n";
                break;
            }
            case TWO_COL_3070: {
                typeSettings = "layout-template-id=2_columns_ii\n";
                break;
            }
            case TWO_COL_7030: {
                typeSettings = "layout-template-id=2_columns_iii\n";
                break;
            }
            case THREE_COL: {
                typeSettings = "layout-template-id=3_columns\n";
                break;
            }
            case TWO_ROWS_1_2_3070: {
                typeSettings = "layout-template-id=1_2_columns_i\n";
                break;
            }
            case TWO_ROWS_1_2_7030: {
                typeSettings = "layout-template-id=1_2_columns_ii\n";
                break;
            }
            case TWO_ROWS_2_7030_2_3070: {
                typeSettings = "layout-template-id=2_2_columns\n";
                break;
            }
            case THREE_ROWS_1_2_5050_1: {
                typeSettings = "layout-template-id=1_2_1_columns\n";
            }
        }
        int i = 1;
        while (i <= this.portlets.size()) {
            typeSettings = String.valueOf(typeSettings) + "column-" + i + "=" + this.portlets.get(i - 1).getPortletId() + ",\n";
            ++i;
        }
        return typeSettings;
    }
}

