/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mozilla.javascript;

import com.liferay.mozilla.javascript.Context;
import com.liferay.mozilla.javascript.ContextFactory;
import com.liferay.mozilla.javascript.InterfaceAdapter;
import com.liferay.mozilla.javascript.Kit;
import com.liferay.mozilla.javascript.Scriptable;
import java.lang.reflect.Member;

public abstract class VMBridge {
    static final VMBridge instance = VMBridge.makeInstance();

    private static VMBridge makeInstance() {
        String[] classNames = new String[]{"com.liferay.mozilla.javascript.VMBridge_custom", "com.liferay.mozilla.javascript.jdk15.VMBridge_jdk15", "com.liferay.mozilla.javascript.jdk13.VMBridge_jdk13", "com.liferay.mozilla.javascript.jdk11.VMBridge_jdk11"};
        for (int i = 0; i != classNames.length; ++i) {
            VMBridge bridge;
            String className = classNames[i];
            Class cl = Kit.classOrNull(className);
            if (cl == null || (bridge = (VMBridge)Kit.newInstanceOrNull(cl)) == null) continue;
            return bridge;
        }
        throw new IllegalStateException("Failed to create VMBridge instance");
    }

    protected abstract Object getThreadContextHelper();

    protected abstract Context getContext(Object var1);

    protected abstract void setContext(Object var1, Context var2);

    protected abstract ClassLoader getCurrentThreadClassLoader();

    protected abstract boolean tryToMakeAccessible(Object var1);

    protected Object getInterfaceProxyHelper(ContextFactory cf, Class[] interfaces) {
        throw Context.reportRuntimeError("VMBridge.getInterfaceProxyHelper is not supported");
    }

    protected Object newInterfaceProxy(Object proxyHelper, ContextFactory cf, InterfaceAdapter adapter, Object target, Scriptable topScope) {
        throw Context.reportRuntimeError("VMBridge.newInterfaceProxy is not supported");
    }

    protected abstract boolean isVarArgs(Member var1);
}

