/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.binary;

import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.concurrent.BlockingQueue;
import net.spy.memcached.ops.CASOperation;
import net.spy.memcached.ops.GetOperation;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.StoreOperation;
import net.spy.memcached.protocol.ProxyCallback;
import net.spy.memcached.protocol.TCPMemcachedNodeImpl;
import net.spy.memcached.protocol.binary.OptimizedGetImpl;
import net.spy.memcached.protocol.binary.OptimizedSetImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryMemcachedNodeImpl
extends TCPMemcachedNodeImpl {
    private final int MAX_SET_OPTIMIZATION_COUNT = 65535;
    private final int MAX_SET_OPTIMIZATION_BYTES = 0x200000;

    public BinaryMemcachedNodeImpl(SocketAddress sa, SocketChannel c, int bufSize, BlockingQueue<Operation> rq, BlockingQueue<Operation> wq, BlockingQueue<Operation> iq, Long opQueueMaxBlockTimeNs, boolean waitForAuth) {
        super(sa, c, bufSize, rq, wq, iq, opQueueMaxBlockTimeNs, waitForAuth);
    }

    @Override
    protected void optimize() {
        Operation firstOp = (Operation)this.writeQ.peek();
        if (firstOp instanceof GetOperation) {
            this.optimizeGets();
        } else if (firstOp instanceof CASOperation) {
            this.optimizeSets();
        }
    }

    private void optimizeGets() {
        this.optimizedOp = (Operation)this.writeQ.remove();
        if (this.writeQ.peek() instanceof GetOperation) {
            OptimizedGetImpl og = new OptimizedGetImpl((GetOperation)this.optimizedOp);
            this.optimizedOp = og;
            while (this.writeQ.peek() instanceof GetOperation) {
                GetOperation o = (GetOperation)this.writeQ.remove();
                if (o.isCancelled()) continue;
                og.addOperation(o);
            }
            this.optimizedOp.initialize();
            assert (this.optimizedOp.getState() == OperationState.WRITING);
            ProxyCallback pcb = (ProxyCallback)og.getCallback();
            this.getLogger().debug("Set up %s with %s keys and %s callbacks", this, pcb.numKeys(), pcb.numCallbacks());
        }
    }

    private void optimizeSets() {
        this.optimizedOp = (Operation)this.writeQ.remove();
        if (this.writeQ.peek() instanceof CASOperation) {
            OptimizedSetImpl og = new OptimizedSetImpl((CASOperation)this.optimizedOp);
            this.optimizedOp = og;
            while (this.writeQ.peek() instanceof StoreOperation && og.size() < 65535 && og.bytes() < 0x200000) {
                CASOperation o = (CASOperation)this.writeQ.remove();
                if (o.isCancelled()) continue;
                og.addOperation(o);
            }
            this.optimizedOp.initialize();
            assert (this.optimizedOp.getState() == OperationState.WRITING);
        }
    }
}

