/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channel;
import org.jruby.Ruby;
import org.jruby.util.ByteList;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.DirectoryAsFileException;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.PipeException;
import org.jruby.util.io.Stream;

public class CRLFStreamWrapper
implements Stream {
    private final Stream stream;
    private boolean binmode = false;
    private static final int CR = 13;
    private static final int LF = 10;

    public CRLFStreamWrapper(Stream stream) {
        this.stream = stream;
    }

    public ChannelDescriptor getDescriptor() {
        return this.stream.getDescriptor();
    }

    public void clearerr() {
        this.stream.clearerr();
    }

    public ModeFlags getModes() {
        return this.stream.getModes();
    }

    public boolean isSync() {
        return this.stream.isSync();
    }

    public void setSync(boolean sync2) {
        this.stream.setSync(sync2);
    }

    public void setBinmode() {
        this.binmode = true;
        this.stream.setBinmode();
    }

    public ByteList fgets(ByteList separatorString) throws IOException, BadDescriptorException, EOFException {
        return this.convertCRLFToLF(this.stream.fgets(separatorString));
    }

    public ByteList readall() throws IOException, BadDescriptorException, EOFException {
        return this.convertCRLFToLF(this.stream.readall());
    }

    public int getline(ByteList dst, byte terminator) throws IOException, BadDescriptorException {
        if (this.binmode) {
            return this.stream.getline(dst, terminator);
        }
        ByteList intermediate = new ByteList();
        int result = this.stream.getline(intermediate, terminator);
        this.convertCRLFToLF(intermediate, dst);
        return result;
    }

    public int getline(ByteList dst, byte terminator, long limit2) throws IOException, BadDescriptorException {
        if (this.binmode) {
            return this.stream.getline(dst, terminator, limit2);
        }
        ByteList intermediate = new ByteList();
        int result = this.stream.getline(intermediate, terminator, limit2);
        this.convertCRLFToLF(intermediate, dst);
        return result;
    }

    public ByteList fread(int number) throws IOException, BadDescriptorException, EOFException {
        int c;
        if (number == 0) {
            if (this.stream.feof()) {
                return null;
            }
            return new ByteList(0);
        }
        ByteList bl = new ByteList(number > 4096 ? 4096 : number);
        for (int i = 0; i < number && (c = this.fgetc()) != -1; ++i) {
            bl.append(c);
        }
        return bl;
    }

    public int fwrite(ByteList string2) throws IOException, BadDescriptorException {
        return this.stream.fwrite(this.convertLFToCRLF(string2));
    }

    public int fgetc() throws IOException, BadDescriptorException, EOFException {
        int c = this.stream.fgetc();
        if (!this.binmode && c == 13 && (c = this.stream.fgetc()) != 10) {
            this.stream.ungetc(c);
            return 13;
        }
        return c;
    }

    public int ungetc(int c) {
        return this.stream.ungetc(c);
    }

    public void fputc(int c) throws IOException, BadDescriptorException {
        if (!this.binmode && c == 10) {
            this.stream.fputc(13);
        }
        this.stream.fputc(c);
    }

    public ByteList read(int number) throws IOException, BadDescriptorException, EOFException {
        return this.convertCRLFToLF(this.stream.read(number));
    }

    public void fclose() throws IOException, BadDescriptorException {
        this.stream.fclose();
    }

    public int fflush() throws IOException, BadDescriptorException {
        return this.stream.fflush();
    }

    public void sync() throws IOException, BadDescriptorException {
        this.stream.sync();
    }

    public boolean feof() throws IOException, BadDescriptorException {
        return this.stream.feof();
    }

    public long fgetpos() throws IOException, PipeException, BadDescriptorException, InvalidValueException {
        return this.stream.fgetpos();
    }

    public void lseek(long offset2, int type2) throws IOException, InvalidValueException, PipeException, BadDescriptorException {
        this.stream.lseek(offset2, type2);
    }

    public void ftruncate(long newLength) throws IOException, PipeException, InvalidValueException, BadDescriptorException {
        this.stream.ftruncate(newLength);
    }

    public int ready() throws IOException {
        return this.stream.ready();
    }

    public void waitUntilReady() throws IOException, InterruptedException {
        this.stream.waitUntilReady();
    }

    public boolean readDataBuffered() {
        return this.stream.readDataBuffered();
    }

    public boolean writeDataBuffered() {
        return this.stream.writeDataBuffered();
    }

    public InputStream newInputStream() {
        return this.stream.newInputStream();
    }

    public OutputStream newOutputStream() {
        return this.stream.newOutputStream();
    }

    public boolean isBlocking() {
        return this.stream.isBlocking();
    }

    public void setBlocking(boolean blocking) throws IOException {
        this.stream.setBlocking(blocking);
    }

    public void freopen(Ruby runtime2, String path2, ModeFlags modes) throws DirectoryAsFileException, IOException, InvalidValueException, PipeException, BadDescriptorException {
        this.stream.freopen(runtime2, path2, modes);
    }

    private ByteList convertCRLFToLF(ByteList input) {
        if (input == null) {
            return null;
        }
        if (this.binmode) {
            return input;
        }
        ByteList result = new ByteList();
        this.convertCRLFToLF(input, result);
        return result;
    }

    private void convertCRLFToLF(ByteList src, ByteList dst) {
        for (int i = 0; i < src.length(); ++i) {
            int b = src.get(i);
            if (b == 13 && i + 1 < src.length() && src.get(i + 1) == 10) continue;
            dst.append(b);
        }
    }

    private ByteList convertLFToCRLF(ByteList input) {
        if (input == null) {
            return null;
        }
        if (this.binmode) {
            return input;
        }
        ByteList result = new ByteList();
        for (int i = 0; i < input.length(); ++i) {
            int b = input.get(i);
            if (b == 10) {
                result.append(13);
            }
            result.append(b);
        }
        return result;
    }

    public Channel getChannel() {
        return this.stream.getChannel();
    }
}

