/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import org.jruby.ast.AssignableNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Node;
import org.jruby.ast.VCallNode;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.BlockStaticScope;
import org.jruby.parser.StaticScope;

public class LocalStaticScope
extends StaticScope {
    private static final long serialVersionUID = 2204064248888411628L;
    private static final String[] NO_NAMES = new String[0];

    public LocalStaticScope(StaticScope enclosingScope) {
        this(enclosingScope, NO_NAMES);
    }

    public LocalStaticScope(StaticScope enclosingScope, String[] names2) {
        super(enclosingScope, names2);
        this.setArgumentScope(true);
        this.setBackrefLastlineScope(true);
    }

    public StaticScope getLocalScope() {
        return this;
    }

    public int isDefined(String name2, int depth) {
        return depth << 16 | this.exists(name2);
    }

    public String[] getAllNamesInScope() {
        return this.getVariables();
    }

    public AssignableNode assign(ISourcePosition position, String name2, Node value2, StaticScope topScope, int depth) {
        int slot = this.exists(name2);
        if (slot >= 0) {
            if (depth > 0) {
                this.capture(slot);
            }
            return new LocalAsgnNode(position, name2, depth << 16 | slot, value2);
        }
        if (topScope == this) {
            slot = this.addVariable(name2);
            return new LocalAsgnNode(position, name2, slot, value2);
        }
        return ((BlockStaticScope)topScope).addAssign(position, name2, value2);
    }

    public Node declare(ISourcePosition position, String name2, int depth) {
        int slot = this.exists(name2);
        if (slot >= 0) {
            if (depth > 0) {
                this.capture(slot);
            }
            return new LocalVarNode(position, depth << 16 | slot, name2);
        }
        return new VCallNode(position, name2);
    }

    public String toString() {
        return "LocalScope: " + super.toString();
    }
}

