/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider;

import com.kenai.jaffl.Address;
import com.kenai.jaffl.MemoryIO;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.provider.AbstractMemoryIO;
import com.kenai.jaffl.provider.DelegatingMemoryIO;
import java.nio.charset.Charset;

public class BoundedMemoryIO
extends AbstractMemoryIO
implements DelegatingMemoryIO {
    private final long base;
    private final long size;
    private final MemoryIO io;

    public BoundedMemoryIO(MemoryIO parent, long offset2, long size2) {
        this.io = parent;
        this.base = offset2;
        this.size = size2;
    }

    public boolean isDirect() {
        return this.getDelegatedMemoryIO().isDirect();
    }

    public long address() {
        return this.getDelegatedMemoryIO().address();
    }

    public MemoryIO getDelegatedMemoryIO() {
        return this.io;
    }

    public byte getByte(long offset2) {
        BoundedMemoryIO.checkBounds(this.size, offset2, 1L);
        return this.io.getByte(this.base + offset2);
    }

    public short getShort(long offset2) {
        BoundedMemoryIO.checkBounds(this.size, offset2, 2L);
        return this.io.getShort(this.base + offset2);
    }

    public int getInt(long offset2) {
        BoundedMemoryIO.checkBounds(this.size, offset2, 4L);
        return this.io.getInt(this.base + offset2);
    }

    public long getLong(long offset2) {
        BoundedMemoryIO.checkBounds(this.size, offset2, 8L);
        return this.io.getLong(this.base + offset2);
    }

    public float getFloat(long offset2) {
        BoundedMemoryIO.checkBounds(this.size, offset2, 4L);
        return this.io.getFloat(this.base + offset2);
    }

    public double getDouble(long offset2) {
        BoundedMemoryIO.checkBounds(this.size, offset2, 8L);
        return this.io.getDouble(this.base + offset2);
    }

    public Pointer getPointer(long offset2) {
        BoundedMemoryIO.checkBounds(this.size, offset2, Address.SIZE / 8);
        return this.io.getPointer(this.base + offset2);
    }

    public MemoryIO getMemoryIO(long offset2) {
        BoundedMemoryIO.checkBounds(this.size, this.base + offset2, Address.SIZE / 8);
        return this.io.getMemoryIO(this.base + offset2);
    }

    public MemoryIO getMemoryIO(long offset2, long size2) {
        BoundedMemoryIO.checkBounds(this.size, this.base + offset2, Address.SIZE / 8);
        return this.io.getMemoryIO(this.base + offset2, size2);
    }

    public void putByte(long offset2, byte value2) {
        BoundedMemoryIO.checkBounds(this.size, offset2, 1L);
        this.io.putByte(this.base + offset2, value2);
    }

    public void putShort(long offset2, short value2) {
        BoundedMemoryIO.checkBounds(this.size, offset2, 2L);
        this.io.putShort(this.base + offset2, value2);
    }

    public void putInt(long offset2, int value2) {
        BoundedMemoryIO.checkBounds(this.size, offset2, 4L);
        this.io.putInt(this.base + offset2, value2);
    }

    public void putLong(long offset2, long value2) {
        BoundedMemoryIO.checkBounds(this.size, offset2, 8L);
        this.io.putLong(this.base + offset2, value2);
    }

    public void putFloat(long offset2, float value2) {
        BoundedMemoryIO.checkBounds(this.size, offset2, 4L);
        this.io.putFloat(this.base + offset2, value2);
    }

    public void putDouble(long offset2, double value2) {
        BoundedMemoryIO.checkBounds(this.size, offset2, 8L);
        this.io.putDouble(this.base + offset2, value2);
    }

    public void putPointer(long offset2, Pointer value2) {
        BoundedMemoryIO.checkBounds(this.size, offset2, Address.SIZE / 8);
        this.io.putPointer(this.base + offset2, value2);
    }

    public void get(long offset2, byte[] dst, int off, int len) {
        BoundedMemoryIO.checkBounds(this.size, offset2, len);
        this.io.get(this.base + offset2, dst, off, len);
    }

    public void put(long offset2, byte[] dst, int off, int len) {
        BoundedMemoryIO.checkBounds(this.size, offset2, len);
        this.io.put(this.base + offset2, dst, off, len);
    }

    public void get(long offset2, short[] dst, int off, int len) {
        BoundedMemoryIO.checkBounds(this.size, offset2, len * 16 / 8);
        this.io.get(this.base + offset2, dst, off, len);
    }

    public void put(long offset2, short[] dst, int off, int len) {
        BoundedMemoryIO.checkBounds(this.size, offset2, len * 16 / 8);
        this.io.put(this.base + offset2, dst, off, len);
    }

    public void get(long offset2, int[] dst, int off, int len) {
        BoundedMemoryIO.checkBounds(this.size, offset2, len * 32 / 8);
        this.io.get(this.base + offset2, dst, off, len);
    }

    public void put(long offset2, int[] dst, int off, int len) {
        BoundedMemoryIO.checkBounds(this.size, offset2, len * 32 / 8);
        this.io.put(this.base + offset2, dst, off, len);
    }

    public void get(long offset2, long[] dst, int off, int len) {
        BoundedMemoryIO.checkBounds(this.size, offset2, len * 64 / 8);
        this.io.get(this.base + offset2, dst, off, len);
    }

    public void put(long offset2, long[] dst, int off, int len) {
        BoundedMemoryIO.checkBounds(this.size, offset2, len * 64 / 8);
        this.io.put(this.base + offset2, dst, off, len);
    }

    public void get(long offset2, float[] dst, int off, int len) {
        BoundedMemoryIO.checkBounds(this.size, offset2, len * 32 / 8);
        this.io.get(this.base + offset2, dst, off, len);
    }

    public void put(long offset2, float[] dst, int off, int len) {
        BoundedMemoryIO.checkBounds(this.size, offset2, len * 32 / 8);
        this.io.put(this.base + offset2, dst, off, len);
    }

    public void get(long offset2, double[] dst, int off, int len) {
        BoundedMemoryIO.checkBounds(this.size, offset2, len * 64 / 8);
        this.io.get(this.base + offset2, dst, off, len);
    }

    public void put(long offset2, double[] dst, int off, int len) {
        BoundedMemoryIO.checkBounds(this.size, offset2, len * 64 / 8);
        this.io.put(this.base + offset2, dst, off, len);
    }

    public long getAddress(long offset2) {
        BoundedMemoryIO.checkBounds(this.size, offset2, Address.SIZE >> 3);
        return this.io.getAddress(this.base + offset2);
    }

    public String getString(long offset2, int maxLength, Charset cs) {
        BoundedMemoryIO.checkBounds(this.size, offset2, maxLength);
        return this.io.getString(this.base + offset2, maxLength, cs);
    }

    public String getString(long offset2) {
        return this.io.getString(this.base + offset2, (int)this.size, Charset.defaultCharset());
    }

    public void putAddress(long offset2, long value2) {
        BoundedMemoryIO.checkBounds(this.size, offset2, Address.SIZE >> 3);
        this.io.putAddress(this.base + offset2, value2);
    }

    public void putAddress(long offset2, Address value2) {
        BoundedMemoryIO.checkBounds(this.size, offset2, Address.SIZE >> 3);
        this.io.putAddress(this.base + offset2, value2);
    }

    public void putString(long offset2, String string2, int maxLength, Charset cs) {
        BoundedMemoryIO.checkBounds(this.size, offset2, maxLength);
        this.io.putString(this.base + offset2, string2, maxLength, cs);
    }

    public int indexOf(long offset2, byte value2) {
        return this.io.indexOf(this.base + offset2, value2, (int)this.size);
    }

    public int indexOf(long offset2, byte value2, int maxlen) {
        BoundedMemoryIO.checkBounds(this.size, offset2, maxlen);
        return this.io.indexOf(this.base + offset2, value2, maxlen);
    }

    public void setMemory(long offset2, long size2, byte value2) {
        BoundedMemoryIO.checkBounds(this.size, this.base + offset2, size2);
        this.io.setMemory(this.base + offset2, size2, value2);
    }
}

