/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.log4j;

import com.liferay.portal.kernel.util.ServerDetector;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.log4j.LogManager;
import org.apache.log4j.xml.DOMConfigurator;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class Log4JUtil {
    public static void configureLog4J(URL url) {
        if (url == null) {
            return;
        }
        if (!ServerDetector.isJBoss()) {
            DOMConfigurator.configure((URL)url);
        }
        HashSet<String> currentLoggerNames = new HashSet<String>();
        Enumeration enu = LogManager.getCurrentLoggers();
        while (enu.hasMoreElements()) {
            org.apache.log4j.Logger logger = (org.apache.log4j.Logger)enu.nextElement();
            currentLoggerNames.add(logger.getName());
        }
        try {
            SAXReader reader = new SAXReader();
            Document doc = reader.read(url);
            Element root = doc.getRootElement();
            for (Element category : root.elements("category")) {
                String name = category.attributeValue("name");
                String priority = category.element("priority").attributeValue("value");
                Log4JUtil.setLevel(name, priority);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setLevel(String name, String priority) {
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)name);
        logger.setLevel(org.apache.log4j.Level.toLevel((String)priority));
        Logger jdkLogger = Logger.getLogger(name);
        jdkLogger.setLevel(Log4JUtil._getJdkLevel(priority));
    }

    private static Level _getJdkLevel(String priority) {
        if (priority.equalsIgnoreCase(org.apache.log4j.Level.DEBUG.toString())) {
            return Level.FINE;
        }
        if (priority.equalsIgnoreCase(org.apache.log4j.Level.ERROR.toString())) {
            return Level.SEVERE;
        }
        if (priority.equalsIgnoreCase(org.apache.log4j.Level.WARN.toString())) {
            return Level.WARNING;
        }
        return Level.INFO;
    }
}

