/*
 * Decompiled with CFR 0.152.
 */
package uk.org.primrose.pool.core;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import uk.org.primrose.pool.core.ConnectionHolder;
import uk.org.primrose.pool.core.PoolResultSet;
import uk.org.primrose.pool.core.PoolStatement;

public class PoolPreparedStatement
extends PoolStatement
implements PreparedStatement {
    PreparedStatement ps = null;

    public PoolPreparedStatement(PreparedStatement ps, ConnectionHolder connHolder) {
        super(ps, connHolder);
        this.ps = ps;
    }

    public PoolPreparedStatement() {
    }

    public ResultSet executeQuery() throws SQLException {
        if (this.connHolder.bDumpConnectionOnSQLException) {
            try {
                PoolResultSet prs = new PoolResultSet(this.ps.executeQuery(), this.connHolder, this);
                return prs;
            }
            catch (SQLException sqle) {
                this.connHolder.closeBehaviour = 14;
                this.connHolder.logger.warn("Closing connection due to SQLException on execute");
                this.connHolder.myPool.notifyExceptionEvent();
                throw sqle;
            }
        }
        PoolResultSet prs = new PoolResultSet(this.ps.executeQuery(), this.connHolder, this);
        return prs;
    }

    public int executeUpdate() throws SQLException {
        if (this.connHolder.bDumpConnectionOnSQLException) {
            try {
                return this.ps.executeUpdate();
            }
            catch (SQLException sqle) {
                this.connHolder.closeBehaviour = 14;
                this.connHolder.logger.warn("Closing connection due to SQLException on execute");
                this.connHolder.myPool.notifyExceptionEvent();
                throw sqle;
            }
        }
        return this.ps.executeUpdate();
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.connHolder.sql = this.connHolder.sql + " " + parameterIndex + "(" + sqlType + ")";
        this.ps.setNull(parameterIndex, sqlType);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.connHolder.sql = this.connHolder.sql + " " + parameterIndex + "(" + x + ")";
        this.ps.setBoolean(parameterIndex, x);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.connHolder.sql = this.connHolder.sql + " " + parameterIndex + "(" + x + ")";
        this.ps.setByte(parameterIndex, x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.connHolder.sql = this.connHolder.sql + " " + parameterIndex + "(" + x + ")";
        this.ps.setShort(parameterIndex, x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.connHolder.sql = this.connHolder.sql + " " + parameterIndex + "(" + x + ")";
        this.ps.setInt(parameterIndex, x);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.connHolder.sql = this.connHolder.sql + " " + parameterIndex + "(" + x + ")";
        this.ps.setLong(parameterIndex, x);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.connHolder.sql = this.connHolder.sql + " " + parameterIndex + "(" + x + ")";
        this.ps.setFloat(parameterIndex, x);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.connHolder.sql = this.connHolder.sql + " " + parameterIndex + "(" + x + ")";
        this.ps.setDouble(parameterIndex, x);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.connHolder.sql = this.connHolder.sql + " " + parameterIndex + "(" + x + ")";
        this.ps.setBigDecimal(parameterIndex, x);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.connHolder.sql = this.connHolder.sql + " " + parameterIndex + "(" + x + ")";
        this.ps.setString(parameterIndex, x);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.connHolder.sql = this.connHolder.sql + " " + parameterIndex + "(" + x + ")";
        this.ps.setBytes(parameterIndex, x);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.connHolder.sql = this.connHolder.sql + " " + parameterIndex + "(" + x + ")";
        this.ps.setDate(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.connHolder.sql = this.connHolder.sql + " " + parameterIndex + "(" + x + ")";
        this.ps.setTime(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.connHolder.sql = this.connHolder.sql + " " + parameterIndex + "(" + x + ")";
        this.ps.setTimestamp(parameterIndex, x);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.connHolder.sql = this.connHolder.sql + " " + parameterIndex + "(" + x + ")";
        this.ps.setAsciiStream(parameterIndex, x, length);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.connHolder.sql = this.connHolder.sql + " " + parameterIndex + "(" + x + ")";
        this.ps.setUnicodeStream(parameterIndex, x, length);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.connHolder.sql = this.connHolder.sql + " " + parameterIndex + "(" + x + ")";
        this.ps.setBinaryStream(parameterIndex, x, length);
    }

    public void clearParameters() throws SQLException {
        this.ps.clearParameters();
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.connHolder.sql = this.connHolder.sql + " " + parameterIndex + "(" + x + ")";
        this.ps.setObject(parameterIndex, x, targetSqlType, scale);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.connHolder.sql = this.connHolder.sql + " " + parameterIndex + "(" + x + ")";
        this.ps.setObject(parameterIndex, x, targetSqlType);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.connHolder.sql = this.connHolder.sql + " " + parameterIndex + "(" + x + ")";
        this.ps.setObject(parameterIndex, x);
    }

    public boolean execute() throws SQLException {
        return this.ps.execute();
    }

    public void addBatch() throws SQLException {
        this.ps.addBatch();
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.connHolder.sql = this.connHolder.sql + " " + parameterIndex + "(" + reader + ")";
        this.ps.setCharacterStream(parameterIndex, reader, length);
    }

    public void setRef(int i, Ref x) throws SQLException {
        this.connHolder.sql = this.connHolder.sql + " " + i + "(" + x + ")";
        this.ps.setRef(i, x);
    }

    public void setBlob(int i, Blob x) throws SQLException {
        this.connHolder.sql = this.connHolder.sql + " " + i + "(" + x + ")";
        this.ps.setBlob(i, x);
    }

    public void setClob(int i, Clob x) throws SQLException {
        this.connHolder.sql = this.connHolder.sql + " " + i + "(" + x + ")";
        this.ps.setClob(i, x);
    }

    public void setArray(int i, Array x) throws SQLException {
        this.connHolder.sql = this.connHolder.sql + " " + i + "(" + x + ")";
        this.ps.setArray(i, x);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.ps.getMetaData();
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.connHolder.sql = this.connHolder.sql + " " + parameterIndex + "(" + x + ")";
        this.ps.setDate(parameterIndex, x, cal);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.connHolder.sql = this.connHolder.sql + " " + parameterIndex + "(" + x + ")";
        this.ps.setTime(parameterIndex, x, cal);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.connHolder.sql = this.connHolder.sql + " " + parameterIndex + "(" + x + ")";
        this.ps.setTimestamp(parameterIndex, x, cal);
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.connHolder.sql = this.connHolder.sql + " " + parameterIndex + "(" + typeName + ")";
        this.ps.setNull(parameterIndex, sqlType, typeName);
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.connHolder.sql = this.connHolder.sql + " " + parameterIndex + "(" + x + ")";
        this.ps.setURL(parameterIndex, x);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.ps.getParameterMetaData();
    }

    public void setAsciiStream(int arg0, InputStream arg1) throws SQLException {
        this.ps.setAsciiStream(arg0, arg1);
    }

    public void setAsciiStream(int arg0, InputStream arg1, long arg2) throws SQLException {
        this.ps.setAsciiStream(arg0, arg1, arg2);
    }

    public void setBinaryStream(int arg0, InputStream arg1) throws SQLException {
        this.ps.setBinaryStream(arg0, arg1);
    }

    public void setBinaryStream(int arg0, InputStream arg1, long arg2) throws SQLException {
        this.ps.setBinaryStream(arg0, arg1, arg2);
    }

    public void setBlob(int arg0, InputStream arg1) throws SQLException {
        this.ps.setBlob(arg0, arg1);
    }

    public void setBlob(int arg0, InputStream arg1, long arg2) throws SQLException {
        this.ps.setBlob(arg0, arg1, arg2);
    }

    public void setCharacterStream(int arg0, Reader arg1) throws SQLException {
        this.ps.setCharacterStream(arg0, arg1);
    }

    public void setCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
        this.ps.setCharacterStream(arg0, arg1, arg2);
    }

    public void setClob(int arg0, Reader arg1) throws SQLException {
        this.ps.setClob(arg0, arg1);
    }

    public void setClob(int arg0, Reader arg1, long arg2) throws SQLException {
        this.ps.setClob(arg0, arg1, arg2);
    }

    public void setNCharacterStream(int arg0, Reader arg1) throws SQLException {
        this.ps.setNCharacterStream(arg0, arg1);
    }

    public void setNCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
        this.ps.setNCharacterStream(arg0, arg1, arg2);
    }

    public void setNClob(int arg0, NClob arg1) throws SQLException {
        this.ps.setNClob(arg0, arg1);
    }

    public void setNClob(int arg0, Reader arg1) throws SQLException {
        this.ps.setNClob(arg0, arg1);
    }

    public void setNClob(int arg0, Reader arg1, long arg2) throws SQLException {
        this.ps.setNClob(arg0, arg1, arg2);
    }

    public void setNString(int arg0, String arg1) throws SQLException {
        this.ps.setNString(arg0, arg1);
    }

    public void setRowId(int arg0, RowId arg1) throws SQLException {
        this.ps.setRowId(arg0, arg1);
    }

    public void setSQLXML(int arg0, SQLXML arg1) throws SQLException {
        this.ps.setSQLXML(arg0, arg1);
    }
}

