/*
 * Decompiled with CFR 0.152.
 */
package uk.org.primrose.pool.core;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import uk.org.primrose.ConfigEncrypter;
import uk.org.primrose.Constants;
import uk.org.primrose.DebugLogger;
import uk.org.primrose.GeneralException;
import uk.org.primrose.Util;
import uk.org.primrose.pool.PoolException;
import uk.org.primrose.pool.core.ExternalPoolConfigProvider;
import uk.org.primrose.pool.core.KeyValuePair;
import uk.org.primrose.pool.core.Pool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoolLoader {
    private static List<Pool> loadedPools = new ArrayList<Pool>();
    private static PoolLoader singleton = new PoolLoader();
    private static boolean alreadyStarted = false;

    public static List<String> loadPool(String configFile, boolean createNewPools) throws GeneralException, IOException {
        String line;
        Properties p = null;
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(configFile)));
        ArrayList<String> loadedPoolNames = new ArrayList<String>();
        String lastKey = null;
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
            KeyValuePair keyValuePair = new KeyValuePair(line);
            keyValuePair.splitLine();
            String key = keyValuePair.getKey();
            String value = keyValuePair.getValue();
            if (!Util.isConfigParameterValid(key) && lastKey != null && lastKey.equalsIgnoreCase("driverURL")) {
                if (p == null) continue;
                p.setProperty(lastKey, p.getProperty(lastKey) + line);
                continue;
            }
            if (key.equals("poolName")) {
                if (p != null) {
                    String poolName = PoolLoader.loadPool(p, createNewPools);
                    loadedPoolNames.add(poolName);
                }
                p = new Properties();
            }
            if (p != null) {
                if (key.equals("=")) {
                    key = "";
                }
                if (value.equals("=")) {
                    value = "";
                }
                p.setProperty(key, value);
            }
            lastKey = key;
        }
        if (p != null) {
            String poolName = PoolLoader.loadPool(p, createNewPools);
            loadedPoolNames.add(poolName);
        }
        br.close();
        return loadedPoolNames;
    }

    public static void decryptPassword(Properties p) throws GeneralException {
        Object encKeyFileObj = p.get("encryptionFileKey");
        if (encKeyFileObj != null) {
            String encKeyFile = (String)encKeyFileObj;
            String encPassword = (String)p.get("password");
            String password = null;
            DebugLogger.log("About to decrypt password (" + encPassword + ")");
            DebugLogger.log("Using keyfile (" + encKeyFile + ")");
            try {
                password = ConfigEncrypter.getDecryptedString(encPassword, encKeyFile);
                DebugLogger.log("Decrypt OK : (" + password + ")");
            }
            catch (Exception e) {
                DebugLogger.log("Got error decrpyting : " + e);
                throw new GeneralException("Error decrypting password String for pool : " + p.getProperty("poolName"), e.getCause());
            }
            p.setProperty("password", password);
        } else {
            DebugLogger.log("envKeyFileObj is null ... not decrpyting passwords");
        }
    }

    public static List<Pool> getLoadedPools() {
        return loadedPools;
    }

    public static void stopAllPools() throws PoolException {
        for (Pool p : loadedPools) {
            p.stop(true);
        }
    }

    public static void stopPool(String name) throws PoolException {
        Pool p = PoolLoader.findExistingPool(name);
        if (p != null) {
            p.stop(true);
        }
    }

    public static String loadPool(Properties config, boolean createNewPool) throws GeneralException {
        Pool pool = null;
        String poolName = config.getProperty("poolName");
        if (poolName == null) {
            throw new GeneralException("Cannot load pool without a poolName property");
        }
        pool = PoolLoader.findExistingPool(poolName.trim());
        if (createNewPool) {
            if (pool != null) {
                pool.stop(false);
                loadedPools.remove(pool);
            }
            pool = new Pool();
        } else if (pool == null) {
            throw new GeneralException("Cannot locate pool under name '" + poolName + "'");
        }
        String configClassName = (String)config.get("externalConfigProvider");
        DebugLogger.log("Seeing if we need to decrpyt the passwords");
        PoolLoader.decryptPassword(config);
        if (configClassName != null) {
            Object o = null;
            try {
                o = Class.forName(configClassName).newInstance();
            }
            catch (Exception e) {
                throw new GeneralException("Error loading externalConfigProvider class", e.getCause());
            }
            ExternalPoolConfigProvider configProvider = o;
            pool.setPoolName(poolName);
            for (String itemName : Constants.POOL_CONFIG_ITEM_NAMES) {
                String value = configProvider.getConfigItem(poolName, itemName);
                if (value == null || value.equals("null") || value.length() <= 0) continue;
                String camelItemName = (itemName.charAt(0) + "").toUpperCase() + itemName.substring(1, itemName.length());
                Util.callClassMethod(pool.getClass(), pool, "set" + camelItemName, new Object[]{value});
            }
        } else {
            Enumeration<?> e = config.propertyNames();
            while (e.hasMoreElements()) {
                String name = ((String)e.nextElement()).trim();
                String value = config.getProperty(name);
                if (value == null) continue;
                value = value.trim();
                String camelName = (name.charAt(0) + "").toUpperCase() + name.substring(1, name.length());
                Util.callClassMethod(pool.getClass(), pool, "set" + camelName, new Object[]{value});
            }
        }
        if (createNewPool) {
            pool.start();
            loadedPools.add(pool);
        } else {
            pool.restart(false);
        }
        return poolName;
    }

    public static Pool findExistingPool(String poolName) {
        for (Pool pool : loadedPools) {
            if (!pool.getPoolName().equals(poolName)) continue;
            return pool;
        }
        return null;
    }

    public static boolean havePoolsBeenLoaded() {
        return loadedPools.size() > 0;
    }

    public static PoolLoader getInstance() {
        return singleton;
    }

    static {
        if (!alreadyStarted) {
            alreadyStarted = true;
            Runtime.getRuntime().addShutdownHook(new PoolStopper());
        }
    }

    static class PoolStopper
    extends Thread {
        PoolStopper() {
        }

        public void run() {
            try {
                PoolLoader.stopAllPools();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

