/*
 * Decompiled with CFR 0.152.
 */
package uk.org.primrose.console;

import java.net.URLDecoder;
import java.util.HashMap;
import uk.org.primrose.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequest {
    protected String szMethod;
    protected String szResource;
    protected String szResponseMimeType;
    protected String szVersion;
    HashMap<String, String> headers = new HashMap();
    HashMap<String, String> parameters = new HashMap();
    Logger logger = null;

    public HttpRequest(Logger logger) {
        this.logger = logger;
    }

    public String getMethod() {
        return this.szMethod;
    }

    public void setMethod(String szMethod) {
        this.szMethod = szMethod;
    }

    public String getResource() {
        return this.szResource;
    }

    public void setResource(String szResource) {
        this.szResource = szResource;
    }

    public String getResponseMimeType() {
        return this.szResponseMimeType;
    }

    public void setResponseMimeType(String szResponseMimeType) {
        this.szResponseMimeType = szResponseMimeType;
    }

    public String getVersion() {
        return this.szVersion;
    }

    public void setVersion(String szVersion) {
        this.szVersion = szVersion;
    }

    public HashMap<String, String> getHeaders() {
        return this.headers;
    }

    public HashMap<String, String> getParameters() {
        return this.parameters;
    }

    public void printDetails() {
        this.logger.info("szMethod=" + this.szMethod);
        this.logger.info("szResource=" + this.szResource);
        this.logger.info("szResponseMimeType=" + this.szResponseMimeType);
        this.logger.info("szVersion=" + this.szVersion);
        this.logger.info("\n\nHeaders : ");
        for (String key : this.headers.keySet()) {
            this.logger.info(key + "=" + this.headers.get(key));
        }
        this.logger.info("\n\nParameters : ");
        for (String key : this.parameters.keySet()) {
            this.logger.info(key + "=" + this.parameters.get(key));
        }
    }

    boolean parseRequest(String szRequestData) {
        if (szRequestData != null && szRequestData.length() == 0) {
            return false;
        }
        String[] t = szRequestData.split("\n");
        boolean bFirstLine = true;
        for (int i = 0; i < t.length; ++i) {
            String szTok = t[i];
            if (bFirstLine) {
                bFirstLine = false;
                int j = 0;
                String[] t2 = szTok.split(" ");
                String szTok2 = t2[j++];
                if (szTok2 != null) {
                    this.szMethod = szTok2;
                }
                if ((szTok2 = t2[j++]) != null) {
                    String[] t3;
                    this.szResource = szTok2;
                    this.szResponseMimeType = this.szResource.indexOf(".htm") != -1 ? "text/html" : (this.szResource.indexOf(".svg") != -1 ? "image/svg+xml" : (this.szResource.indexOf(".png") != -1 ? "image/png" : (this.szResource.indexOf(".gif") != -1 ? "image/gif" : (this.szResource.indexOf(".jpeg") != -1 || this.szResource.indexOf(".jpg") != -1 ? "image/jpeg" : (this.szResource.indexOf(".txt") != -1 ? "text/plain" : (this.szResource.indexOf(".log") != -1 ? "text/plain" : "text/html"))))));
                    if (this.szMethod.indexOf("GET") != -1 && (t3 = this.szResource.split("\\?")).length > 1) {
                        String szToken = t3[1];
                        String[] t4 = szToken.split("&");
                        for (int l = 0; l < t4.length; ++l) {
                            String szToken2 = t4[l];
                            String[] t5 = szToken2.split("=");
                            if (t5.length != 2) continue;
                            this.parameters.put(URLDecoder.decode(t5[0].trim()), URLDecoder.decode(t5[1].trim()));
                        }
                    }
                }
                if ((szTok2 = t2[j++]) == null) continue;
                this.szVersion = szTok2;
                continue;
            }
            String[] t2 = szTok.split(":");
            String szHeaderName = t2[0];
            String szHeaderValue = t2[1];
            if (szHeaderName == null || szHeaderValue == null) continue;
            this.headers.put(szHeaderName.trim(), szHeaderValue.trim());
        }
        return true;
    }
}

