/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.velocity.tools.view.context.ViewContext;

public abstract class AbstractPagerTool {
    public static final int DEFAULT_ITEMS_PER_PAGE = 10;
    public static final int DEFAULT_SLIP_SIZE = 20;
    protected static final String STORED_ITEMS_KEY = AbstractPagerTool.class.getName();
    private List items;
    private int index = 0;
    private int slipSize = 20;
    private int itemsPerPage = 10;
    protected HttpSession session;

    public void init(Object obj) {
        ViewContext context = (ViewContext)obj;
        HttpServletRequest request = context.getRequest();
        this.session = request.getSession(false);
        this.setup(request);
    }

    public abstract void setup(HttpServletRequest var1);

    public void reset() {
        this.items = null;
        this.index = 0;
        this.itemsPerPage = 10;
    }

    public void setItems(List items) {
        this.items = items;
        this.setStoredItems(items);
    }

    public void setIndex(int index) {
        if (index < 0) {
            index = 0;
        }
        this.index = index;
    }

    public void setItemsPerPage(int itemsPerPage) {
        if (itemsPerPage < 1) {
            itemsPerPage = 10;
        }
        this.itemsPerPage = itemsPerPage;
    }

    public void setSlipSize(int slipSize) {
        if (slipSize < 2) {
            slipSize = 20;
        }
        this.slipSize = slipSize;
    }

    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    public int getSlipSize() {
        return this.slipSize;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean hasItems() {
        return !this.getItems().isEmpty();
    }

    public List getItems() {
        if (this.items == null) {
            this.items = this.getStoredItems();
        }
        return this.items != null ? this.items : Collections.EMPTY_LIST;
    }

    public Integer getLastIndex() {
        if (!this.hasItems()) {
            return null;
        }
        return new Integer(Math.min(this.getTotal() - 1, this.index + this.itemsPerPage - 1));
    }

    public Integer getNextIndex() {
        int next = this.index + this.itemsPerPage;
        if (next < this.getTotal()) {
            return new Integer(next);
        }
        return null;
    }

    public Integer getFirstIndex() {
        if (!this.hasItems()) {
            return null;
        }
        return new Integer(Math.min(this.getTotal() - 1, this.index));
    }

    public Integer getPrevIndex() {
        int prev = Math.min(this.index, this.getTotal()) - this.itemsPerPage;
        if (this.index > 0) {
            return new Integer(Math.max(0, prev));
        }
        return null;
    }

    public int getPagesAvailable() {
        return (int)Math.ceil((double)this.getTotal() / (double)this.itemsPerPage);
    }

    public List getPage() {
        if (!this.hasItems()) {
            return null;
        }
        int start = this.getFirstIndex();
        int end = this.getLastIndex() + 1;
        return this.getItems().subList(start, end);
    }

    public Integer getPageNumber(int i) {
        if (!this.hasItems()) {
            return null;
        }
        return new Integer(1 + i / this.itemsPerPage);
    }

    public Integer getPageNumber() {
        return this.getPageNumber(this.index);
    }

    public int getTotal() {
        if (!this.hasItems()) {
            return 0;
        }
        return this.getItems().size();
    }

    public String getPageDescription() {
        int total;
        if (!this.hasItems()) {
            return "0 of 0";
        }
        StringBuffer out = new StringBuffer();
        int first = this.getFirstIndex() + 1;
        if (first >= (total = this.getTotal())) {
            out.append(total);
            out.append(" of ");
            out.append(total);
        } else {
            int last = this.getLastIndex() + 1;
            out.append(first);
            out.append(" - ");
            out.append(last);
            out.append(" of ");
            out.append(total);
        }
        return out.toString();
    }

    public List getSlip() {
        int totalPgs = this.getPagesAvailable();
        if (totalPgs <= 1) {
            return Collections.EMPTY_LIST;
        }
        int curPg = this.getPageNumber() - 1;
        int slipStart = Math.max(0, curPg - this.slipSize / 2);
        int slipEnd = Math.min(totalPgs, slipStart + this.slipSize);
        if (slipEnd - slipStart < this.slipSize) {
            slipStart = Math.max(0, slipEnd - this.slipSize);
        }
        ArrayList<Integer> slip = new ArrayList<Integer>(slipEnd - slipStart);
        for (int i = slipStart; i < slipEnd; ++i) {
            slip.add(new Integer(i * this.itemsPerPage));
        }
        return slip;
    }

    protected List getStoredItems() {
        if (this.session != null) {
            return (List)this.session.getAttribute(STORED_ITEMS_KEY);
        }
        return null;
    }

    protected void setStoredItems(List items) {
        if (this.session != null) {
            this.session.setAttribute(STORED_ITEMS_KEY, (Object)items);
        }
    }
}

