/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.documentlibrary.model.FileModel;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import java.util.Date;
import java.util.List;
import javax.portlet.PortletURL;
import javax.portlet.WindowStateException;

public class DLIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{DLFileEntry.class.getName()};
    public static final String PORTLET_ID = "20";
    private static final boolean _FILTER_SEARCH = true;

    public DLIndexer() {
        IndexerRegistryUtil.register((Indexer)new com.liferay.documentlibrary.util.DLIndexer());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public Summary getSummary(Document document, String snippet, PortletURL portletURL) {
        String fileName;
        LiferayPortletURL liferayPortletURL = (LiferayPortletURL)portletURL;
        liferayPortletURL.setLifecycle("ACTION_PHASE");
        try {
            liferayPortletURL.setWindowState(LiferayWindowState.EXCLUSIVE);
        }
        catch (WindowStateException windowStateException) {}
        String groupId = document.get("scopeGroupId");
        String folderId = document.get("folderId");
        String title = fileName = document.get("path");
        String content = snippet;
        if (Validator.isNull((String)snippet)) {
            content = StringUtil.shorten((String)document.get("content"), (int)200);
        }
        portletURL.setParameter("struts_action", "/document_library/get_file");
        portletURL.setParameter("groupId", groupId);
        portletURL.setParameter("folderId", folderId);
        portletURL.setParameter("name", fileName);
        return new Summary(title, content, portletURL);
    }

    protected void doDelete(Object obj) throws Exception {
        DLFileEntry fileEntry = (DLFileEntry)obj;
        FileModel fileModel = new FileModel();
        fileModel.setCompanyId(fileEntry.getCompanyId());
        fileModel.setFileName(fileEntry.getName());
        fileModel.setPortletId(PORTLET_ID);
        fileModel.setRepositoryId(fileEntry.getRepositoryId());
        Indexer indexer = IndexerRegistryUtil.getIndexer(FileModel.class);
        indexer.delete((Object)fileModel);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexFolders(companyId);
        this.reindexRoot(companyId);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        DLFileEntry fileEntry = DLFileEntryLocalServiceUtil.getFileEntry((long)classPK);
        this.doReindex(fileEntry);
    }

    protected void doReindex(Object obj) throws Exception {
        DLFileEntry fileEntry = (DLFileEntry)obj;
        Document document = this.getDocument(fileEntry);
        if (document != null) {
            SearchEngineUtil.updateDocument((long)fileEntry.getCompanyId(), (Document)document);
        }
    }

    protected Document doGetDocument(Object obj) throws Exception {
        DLFileEntry fileEntry = (DLFileEntry)obj;
        long companyId = fileEntry.getCompanyId();
        long groupId = fileEntry.getGroupId();
        long userId = fileEntry.getUserId();
        long repositoryId = fileEntry.getRepositoryId();
        String fileName = fileEntry.getName();
        long fileEntryId = fileEntry.getFileEntryId();
        String properties = fileEntry.getLuceneProperties();
        Date modifiedDate = fileEntry.getModifiedDate();
        long[] assetCategoryIds = AssetCategoryLocalServiceUtil.getCategoryIds((String)DLFileEntry.class.getName(), (long)fileEntryId);
        String[] assetTagNames = AssetTagLocalServiceUtil.getTagNames((String)DLFileEntry.class.getName(), (long)fileEntryId);
        FileModel fileModel = new FileModel();
        fileModel.setAssetCategoryIds(assetCategoryIds);
        fileModel.setAssetTagNames(assetTagNames);
        fileModel.setCompanyId(companyId);
        fileModel.setFileEntryId(fileEntryId);
        fileModel.setFileName(fileName);
        fileModel.setGroupId(groupId);
        fileModel.setUserId(userId);
        fileModel.setModifiedDate(modifiedDate);
        fileModel.setPortletId(PORTLET_ID);
        fileModel.setProperties(properties);
        fileModel.setRepositoryId(repositoryId);
        Indexer indexer = IndexerRegistryUtil.getIndexer(FileModel.class);
        return indexer.getDocument((Object)fileModel);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected boolean hasPermission(PermissionChecker permissionChecker, long entryClassPK, String actionId) throws Exception {
        return DLFileEntryPermission.contains(permissionChecker, entryClassPK, "VIEW");
    }

    protected boolean isFilterSearch() {
        return true;
    }

    protected void reindexFolders(long companyId) throws Exception {
        int folderCount = DLFolderLocalServiceUtil.getCompanyFoldersCount((long)companyId);
        int folderPages = folderCount / 1000;
        int i = 0;
        while (i <= folderPages) {
            int folderStart = i * 1000;
            int folderEnd = folderStart + 1000;
            this.reindexFolders(companyId, folderStart, folderEnd);
            ++i;
        }
    }

    protected void reindexFolders(long companyId, int folderStart, int folderEnd) throws Exception {
        List folders = DLFolderLocalServiceUtil.getCompanyFolders((long)companyId, (int)folderStart, (int)folderEnd);
        for (DLFolder folder : folders) {
            String portletId = PORTLET_ID;
            long groupId = folder.getGroupId();
            long folderId = folder.getFolderId();
            String[] newIds = new String[]{String.valueOf(companyId), portletId, String.valueOf(groupId), String.valueOf(folderId)};
            Indexer indexer = IndexerRegistryUtil.getIndexer(FileModel.class);
            indexer.reindex(newIds);
        }
    }

    protected void reindexRoot(long companyId) throws Exception {
        int groupCount = GroupLocalServiceUtil.getCompanyGroupsCount((long)companyId);
        int groupPages = groupCount / 1000;
        int i = 0;
        while (i <= groupPages) {
            int groupStart = i * 1000;
            int groupEnd = groupStart + 1000;
            this.reindexRoot(companyId, groupStart, groupEnd);
            ++i;
        }
    }

    protected void reindexRoot(long companyId, int groupStart, int groupEnd) throws Exception {
        List groups = GroupLocalServiceUtil.getCompanyGroups((long)companyId, (int)groupStart, (int)groupEnd);
        for (Group group : groups) {
            long groupId;
            String portletId = PORTLET_ID;
            long folderId = groupId = group.getGroupId();
            String[] newIds = new String[]{String.valueOf(companyId), portletId, String.valueOf(groupId), String.valueOf(folderId)};
            Indexer indexer = IndexerRegistryUtil.getIndexer(FileModel.class);
            indexer.reindex(newIds);
        }
    }
}

