/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.kernel.workflow.permission.WorkflowPermissionUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileVersionLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.permission.DLFolderPermission;

public class DLFileEntryPermission {
    public static void check(PermissionChecker permissionChecker, DLFileEntry fileEntry, String actionId) throws PortalException, SystemException {
        if (!DLFileEntryPermission.contains(permissionChecker, fileEntry, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long groupId, long folderId, String name, String actionId) throws PortalException, SystemException {
        if (!DLFileEntryPermission.contains(permissionChecker, groupId, folderId, name, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long fileEntryId, String actionId) throws PortalException, SystemException {
        if (!DLFileEntryPermission.contains(permissionChecker, fileEntryId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, DLFileEntry fileEntry, String actionId) throws PortalException, SystemException {
        DLFolder folder;
        Boolean hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)fileEntry.getGroupId(), (String)DLFileEntry.class.getName(), (long)fileEntry.getFileEntryId(), (String)"20", (String)actionId);
        if (hasPermission != null) {
            return hasPermission;
        }
        DLFileVersion latestFileVersion = DLFileVersionLocalServiceUtil.getLatestFileVersion((long)fileEntry.getGroupId(), (long)fileEntry.getFolderId(), (String)fileEntry.getName());
        if (latestFileVersion.isPending() && (hasPermission = WorkflowPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)fileEntry.getGroupId(), (String)DLFileEntry.class.getName(), (long)fileEntry.getFileEntryId(), (String)actionId)) != null) {
            return hasPermission;
        }
        if (PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE && fileEntry.getFolderId() != 0L && !DLFolderPermission.contains(permissionChecker, folder = DLFolderLocalServiceUtil.getFolder((long)fileEntry.getFolderId()), "ACCESS") && !DLFolderPermission.contains(permissionChecker, folder, "VIEW")) {
            return false;
        }
        if (permissionChecker.hasOwnerPermission(fileEntry.getCompanyId(), DLFileEntry.class.getName(), fileEntry.getFileEntryId(), fileEntry.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(fileEntry.getGroupId(), DLFileEntry.class.getName(), fileEntry.getFileEntryId(), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, long folderId, String name, String actionId) throws PortalException, SystemException {
        DLFileEntry fileEntry = DLFileEntryLocalServiceUtil.getFileEntry((long)groupId, (long)folderId, (String)name);
        return DLFileEntryPermission.contains(permissionChecker, fileEntry, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long fileEntryId, String actionId) throws PortalException, SystemException {
        DLFileEntry fileEntry = DLFileEntryLocalServiceUtil.getFileEntry((long)fileEntryId);
        return DLFileEntryPermission.contains(permissionChecker, fileEntry, actionId);
    }
}

