/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.action;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.service.SubscriptionLocalServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.AssetTagException;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.blogs.EntryContentException;
import com.liferay.portlet.blogs.EntryDisplayDateException;
import com.liferay.portlet.blogs.EntryTitleException;
import com.liferay.portlet.blogs.NoSuchEntryException;
import com.liferay.portlet.blogs.action.ActionUtil;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.BlogsEntryLocalServiceUtil;
import com.liferay.portlet.blogs.service.BlogsEntryServiceUtil;
import com.liferay.portlet.blogs.service.permission.BlogsPermission;
import com.liferay.util.servlet.ServletResponseUtil;
import java.io.InputStream;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditEntryAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            BlogsEntry entry = null;
            String oldUrlTitle = "";
            if (cmd.equals("add") || cmd.equals("update")) {
                Object[] returnValue = this.updateEntry(actionRequest);
                entry = (BlogsEntry)returnValue[0];
                oldUrlTitle = (String)returnValue[1];
            } else if (cmd.equals("delete")) {
                this.deleteEntry(actionRequest);
            } else if (cmd.equals("subscribe")) {
                this.subscribe(actionRequest);
            } else if (cmd.equals("unsubscribe")) {
                this.unsubscribe(actionRequest);
            }
            String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
            boolean updateRedirect = false;
            if (redirect.indexOf("/blogs/" + oldUrlTitle + "/maximized") != -1) {
                oldUrlTitle = String.valueOf(oldUrlTitle) + "/maximized";
            }
            if (entry != null && Validator.isNotNull((String)oldUrlTitle) && (redirect.endsWith("/blogs/" + oldUrlTitle) || redirect.indexOf("/blogs/" + oldUrlTitle + "?") != -1)) {
                int pos = redirect.indexOf("?");
                if (pos == -1) {
                    pos = redirect.length();
                }
                String newRedirect = redirect.substring(0, pos - oldUrlTitle.length());
                newRedirect = String.valueOf(newRedirect) + entry.getUrlTitle();
                if (oldUrlTitle.indexOf("/maximized") != -1) {
                    newRedirect = String.valueOf(newRedirect) + "/maximized";
                }
                if (pos < redirect.length()) {
                    newRedirect = String.valueOf(newRedirect) + "?" + redirect.substring(pos + 1, redirect.length());
                }
                redirect = newRedirect;
                updateRedirect = true;
            }
            int workflowAction = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"workflowAction");
            if (entry != null && workflowAction == 2) {
                JSONObject jsonObj = JSONFactoryUtil.createJSONObject();
                jsonObj.put("entryId", entry.getEntryId());
                jsonObj.put("redirect", redirect);
                jsonObj.put("updateRedirect", updateRedirect);
                HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
                HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
                UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(jsonObj.toString().getBytes());
                String contentType = "text/javascript";
                ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, null, (InputStream)is, (String)contentType);
                this.setForward((PortletRequest)actionRequest, "/common/null.jsp");
            } else {
                ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
                LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
                if (layoutTypePortlet.hasPortletId(portletConfig.getPortletName())) {
                    this.sendRedirect(actionRequest, actionResponse, redirect);
                } else {
                    actionResponse.sendRedirect(redirect);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchEntryException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.blogs.error");
            }
            if (e instanceof EntryContentException || e instanceof EntryDisplayDateException || e instanceof EntryTitleException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
            }
            if (e instanceof AssetTagException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName(), (Object)e);
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            BlogsEntry entry;
            ActionUtil.getEntry((PortletRequest)renderRequest);
            if (PropsValues.BLOGS_PINGBACK_ENABLED && (entry = (BlogsEntry)renderRequest.getAttribute("BLOGS_ENTRY")) != null && entry.isAllowPingbacks()) {
                HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)renderResponse);
                response.addHeader("X-Pingback", String.valueOf(PortalUtil.getPortalURL((PortletRequest)renderRequest)) + "/xmlrpc/pingback");
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchEntryException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.blogs.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.blogs.edit_entry"));
    }

    protected void deleteEntry(ActionRequest actionRequest) throws Exception {
        long entryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"entryId");
        BlogsEntryServiceUtil.deleteEntry((long)entryId);
    }

    protected void subscribe(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (BlogsPermission.contains(permissionChecker, themeDisplay.getScopeGroupId(), "SUBSCRIBE")) {
            SubscriptionLocalServiceUtil.addSubscription((long)themeDisplay.getUserId(), (String)BlogsEntry.class.getName(), (long)themeDisplay.getScopeGroupId());
        }
    }

    protected void unsubscribe(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (BlogsPermission.contains(permissionChecker, themeDisplay.getScopeGroupId(), "SUBSCRIBE")) {
            SubscriptionLocalServiceUtil.deleteSubscription((long)themeDisplay.getUserId(), (String)BlogsEntry.class.getName(), (long)themeDisplay.getScopeGroupId());
        }
    }

    protected Object[] updateEntry(ActionRequest actionRequest) throws Exception {
        long entryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"entryId");
        String title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
        String content = ParamUtil.getString((PortletRequest)actionRequest, (String)"content");
        int displayDateMonth = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"displayDateMonth");
        int displayDateDay = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"displayDateDay");
        int displayDateYear = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"displayDateYear");
        int displayDateHour = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"displayDateHour");
        int displayDateMinute = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"displayDateMinute");
        int displayDateAmPm = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"displayDateAmPm");
        if (displayDateAmPm == 1) {
            displayDateHour += 12;
        }
        boolean allowPingbacks = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"allowPingbacks");
        boolean allowTrackbacks = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"allowTrackbacks");
        String[] trackbacks = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"trackbacks"));
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)BlogsEntry.class.getName(), (PortletRequest)actionRequest);
        BlogsEntry entry = null;
        String oldUrlTitle = "";
        if (entryId <= 0L) {
            entry = BlogsEntryServiceUtil.addEntry((String)title, (String)content, (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (boolean)allowPingbacks, (boolean)allowTrackbacks, (String[])trackbacks, (ServiceContext)serviceContext);
            AssetPublisherUtil.addAndStoreSelection(actionRequest, BlogsEntry.class.getName(), entry.getEntryId(), -1);
        } else {
            entry = BlogsEntryLocalServiceUtil.getEntry((long)entryId);
            String tempOldUrlTitle = entry.getUrlTitle();
            if (!tempOldUrlTitle.equals((entry = BlogsEntryServiceUtil.updateEntry((long)entryId, (String)title, (String)content, (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (boolean)allowPingbacks, (boolean)allowTrackbacks, (String[])trackbacks, (ServiceContext)serviceContext)).getUrlTitle())) {
                oldUrlTitle = tempOldUrlTitle;
            }
            AssetPublisherUtil.addAndStoreSelection(actionRequest, BlogsEntry.class.getName(), entry.getEntryId(), -1);
        }
        return new Object[]{entry, oldUrlTitle};
    }
}

