/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav.methods;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.webdav.methods.CopyMethodImpl;
import com.liferay.portal.webdav.methods.DeleteMethodImpl;
import com.liferay.portal.webdav.methods.GetMethodImpl;
import com.liferay.portal.webdav.methods.HeadMethodImpl;
import com.liferay.portal.webdav.methods.LockMethodImpl;
import com.liferay.portal.webdav.methods.Method;
import com.liferay.portal.webdav.methods.MkcolMethodImpl;
import com.liferay.portal.webdav.methods.MoveMethodImpl;
import com.liferay.portal.webdav.methods.OptionsMethodImpl;
import com.liferay.portal.webdav.methods.PropfindMethodImpl;
import com.liferay.portal.webdav.methods.ProppatchMethodImpl;
import com.liferay.portal.webdav.methods.PutMethodImpl;
import com.liferay.portal.webdav.methods.UnlockMethodImpl;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class MethodFactory {
    private static final String _COPY_METHOD_IMPL = GetterUtil.getString((String)PropsUtil.get(String.valueOf(MethodFactory.class.getName()) + ".COPY"), (String)CopyMethodImpl.class.getName());
    private static final String _DELETE_METHOD_IMPL = GetterUtil.getString((String)PropsUtil.get(String.valueOf(MethodFactory.class.getName()) + ".DELETE"), (String)DeleteMethodImpl.class.getName());
    private static final String _GET_METHOD_IMPL = GetterUtil.getString((String)PropsUtil.get(String.valueOf(MethodFactory.class.getName()) + ".GET"), (String)GetMethodImpl.class.getName());
    private static final String _HEAD_METHOD_IMPL = GetterUtil.getString((String)PropsUtil.get(String.valueOf(MethodFactory.class.getName()) + ".HEAD"), (String)HeadMethodImpl.class.getName());
    private static final String _LOCK_METHOD_IMPL = GetterUtil.getString((String)PropsUtil.get(String.valueOf(MethodFactory.class.getName()) + ".LOCK"), (String)LockMethodImpl.class.getName());
    private static final String _MKCOL_METHOD_IMPL = GetterUtil.getString((String)PropsUtil.get(String.valueOf(MethodFactory.class.getName()) + ".MKCOL"), (String)MkcolMethodImpl.class.getName());
    private static final String _MOVE_METHOD_IMPL = GetterUtil.getString((String)PropsUtil.get(String.valueOf(MethodFactory.class.getName()) + ".MOVE"), (String)MoveMethodImpl.class.getName());
    private static final String _OPTIONS_METHOD_IMPL = GetterUtil.getString((String)PropsUtil.get(String.valueOf(MethodFactory.class.getName()) + ".OPTIONS"), (String)OptionsMethodImpl.class.getName());
    private static final String _PROPFIND_METHOD_IMPL = GetterUtil.getString((String)PropsUtil.get(String.valueOf(MethodFactory.class.getName()) + ".PROPFIND"), (String)PropfindMethodImpl.class.getName());
    private static final String _PROPPATCH_METHOD_IMPL = GetterUtil.getString((String)PropsUtil.get(String.valueOf(MethodFactory.class.getName()) + ".PROPPATCH"), (String)ProppatchMethodImpl.class.getName());
    private static final String _PUT_METHOD_IMPL = GetterUtil.getString((String)PropsUtil.get(String.valueOf(MethodFactory.class.getName()) + ".PUT"), (String)PutMethodImpl.class.getName());
    private static final String _UNLOCK_METHOD_IMPL = GetterUtil.getString((String)PropsUtil.get(String.valueOf(MethodFactory.class.getName()) + ".UNLOCK"), (String)UnlockMethodImpl.class.getName());
    private static MethodFactory _instance = new MethodFactory();
    private Map<String, Object> _methods = new HashMap<String, Object>();

    public static Method create(HttpServletRequest request) throws WebDAVException {
        return _instance._create(request);
    }

    private MethodFactory() {
        this._methods.put("COPY", InstancePool.get((String)_COPY_METHOD_IMPL));
        this._methods.put("DELETE", InstancePool.get((String)_DELETE_METHOD_IMPL));
        this._methods.put("GET", InstancePool.get((String)_GET_METHOD_IMPL));
        this._methods.put("HEAD", InstancePool.get((String)_HEAD_METHOD_IMPL));
        this._methods.put("LOCK", InstancePool.get((String)_LOCK_METHOD_IMPL));
        this._methods.put("MKCOL", InstancePool.get((String)_MKCOL_METHOD_IMPL));
        this._methods.put("MOVE", InstancePool.get((String)_MOVE_METHOD_IMPL));
        this._methods.put("OPTIONS", InstancePool.get((String)_OPTIONS_METHOD_IMPL));
        this._methods.put("PROPFIND", InstancePool.get((String)_PROPFIND_METHOD_IMPL));
        this._methods.put("PROPPATCH", InstancePool.get((String)_PROPPATCH_METHOD_IMPL));
        this._methods.put("PUT", InstancePool.get((String)_PUT_METHOD_IMPL));
        this._methods.put("UNLOCK", InstancePool.get((String)_UNLOCK_METHOD_IMPL));
    }

    private Method _create(HttpServletRequest request) throws WebDAVException {
        String method = request.getMethod();
        Method methodImpl = (Method)this._methods.get(method.toUpperCase());
        if (methodImpl == null) {
            throw new WebDAVException("Method " + method + " is not implemented");
        }
        return methodImpl;
    }
}

