/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.util.Normalizer;

public class FriendlyURLNormalizer {
    private static final char[] _REPLACE_CHARS = new char[]{' ', ',', '\\', '\'', '\"', '(', ')', '{', '}', '?', '#', '@', '+', '~', ';', '$', '%'};

    public static String normalize(String friendlyURL) {
        return FriendlyURLNormalizer.normalize(friendlyURL, null);
    }

    public static String normalize(String friendlyURL, char[] replaceChars) {
        if (Validator.isNull((String)friendlyURL)) {
            return friendlyURL;
        }
        friendlyURL = GetterUtil.getString((String)friendlyURL);
        friendlyURL = friendlyURL.toLowerCase();
        friendlyURL = Normalizer.normalizeToAscii((String)friendlyURL);
        char[] charArray = friendlyURL.toCharArray();
        int i = 0;
        while (i < charArray.length) {
            char oldChar;
            char newChar = oldChar = charArray[i];
            if (ArrayUtil.contains((char[])_REPLACE_CHARS, (char)oldChar) || replaceChars != null && ArrayUtil.contains((char[])replaceChars, (char)oldChar)) {
                newChar = '-';
            }
            if (oldChar != newChar) {
                charArray[i] = newChar;
            }
            ++i;
        }
        friendlyURL = new String(charArray);
        while (friendlyURL.contains("--")) {
            friendlyURL = StringUtil.replace((String)friendlyURL, (String)"--", (String)"-");
        }
        if (friendlyURL.startsWith("-")) {
            friendlyURL = friendlyURL.substring(1, friendlyURL.length());
        }
        if (friendlyURL.endsWith("-")) {
            friendlyURL = friendlyURL.substring(0, friendlyURL.length() - 1);
        }
        return friendlyURL;
    }
}

