/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.i18n;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.util.CookieKeys;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class I18nFilter
extends BasePortalFilter {
    public static final String SKIP_FILTER = String.valueOf(I18nFilter.class.getName()) + "SKIP_FILTER";
    private static Log _log = LogFactoryUtil.getLog(I18nFilter.class);
    private static final String _PRIVATE_GROUP_SERVLET_MAPPING = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING;
    private static final String _PRIVATE_USER_SERVLET_MAPPING = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_USER_SERVLET_MAPPING;
    private static final String _PUBLIC_GROUP_SERVLET_MAPPING = PropsValues.LAYOUT_FRIENDLY_URL_PUBLIC_SERVLET_MAPPING;
    private static Set<String> _languageIds = new HashSet<String>();

    public static Set<String> getLanguageIds() {
        return _languageIds;
    }

    public static void setLanguageIds(Set<String> languageIds) {
        for (String languageId : languageIds) {
            languageId = languageId.substring(1);
            _languageIds.add(languageId);
        }
        _languageIds = Collections.unmodifiableSet(_languageIds);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getRedirect(HttpServletRequest request) throws Exception {
        String queryString;
        if (PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE == 0) {
            return null;
        }
        String contextPath = PortalUtil.getPathContext();
        String requestURI = request.getRequestURI();
        if (Validator.isNotNull((String)contextPath) && requestURI.indexOf(contextPath) != -1) {
            requestURI = requestURI.substring(contextPath.length());
        }
        requestURI = StringUtil.replace((String)requestURI, (String)"//", (String)"/");
        String i18nLanguageId = requestURI.substring(1);
        int pos = requestURI.indexOf(47, 1);
        if (pos != -1) {
            i18nLanguageId = i18nLanguageId.substring(0, pos - 1);
        }
        if (_languageIds.contains(i18nLanguageId)) {
            return null;
        }
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault());
        String guestLanguageId = CookieKeys.getCookie(request, "GUEST_LANGUAGE_ID");
        if (Validator.isNull((String)guestLanguageId)) {
            guestLanguageId = defaultLanguageId;
        }
        if (PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE == 1) {
            if (defaultLanguageId.equals(guestLanguageId)) return null;
            i18nLanguageId = guestLanguageId;
        } else if (PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE == 2) {
            i18nLanguageId = guestLanguageId;
        }
        if (i18nLanguageId == null) {
            return null;
        }
        String i18nPath = "/" + i18nLanguageId;
        Locale locale = LocaleUtil.fromLanguageId((String)i18nLanguageId);
        if (!LanguageUtil.isDuplicateLanguageCode((String)locale.getLanguage())) {
            i18nPath = "/" + locale.getLanguage();
        } else {
            Locale priorityLocale = LanguageUtil.getLocale((String)locale.getLanguage());
            if (locale.equals(priorityLocale)) {
                i18nPath = "/" + locale.getLanguage();
            }
        }
        String redirect = String.valueOf(contextPath) + i18nPath + requestURI;
        LayoutSet layoutSet = (LayoutSet)request.getAttribute("VIRTUAL_HOST_LAYOUT_SET");
        if (layoutSet != null && (requestURI.startsWith(_PRIVATE_GROUP_SERVLET_MAPPING) || requestURI.startsWith(_PRIVATE_USER_SERVLET_MAPPING) || requestURI.startsWith(_PUBLIC_GROUP_SERVLET_MAPPING))) {
            int y;
            int x = requestURI.indexOf("/", 1);
            if (x == -1) {
                requestURI = String.valueOf(requestURI) + "/";
                x = requestURI.indexOf(47, 1);
            }
            if ((y = requestURI.indexOf(47, x + 1)) == -1) {
                requestURI = String.valueOf(requestURI) + "/";
                y = requestURI.indexOf(47, x + 1);
            }
            String groupFriendlyURL = requestURI.substring(x, y);
            Group group = layoutSet.getGroup();
            if (group.getFriendlyURL().equals(groupFriendlyURL)) {
                redirect = String.valueOf(contextPath) + i18nPath + requestURI.substring(y);
            }
        }
        if (!Validator.isNotNull((String)(queryString = request.getQueryString()))) return redirect;
        return String.valueOf(redirect) + "?" + request.getQueryString();
    }

    protected boolean isAlreadyFiltered(HttpServletRequest request) {
        return request.getAttribute(SKIP_FILTER) != null;
    }

    protected boolean isForwardedByI18nServlet(HttpServletRequest request) {
        return request.getAttribute("I18N_LANGUAGE_ID") != null || request.getAttribute("I18N_PATH") != null;
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        if (this.isAlreadyFiltered(request) || this.isForwardedByI18nServlet(request)) {
            this.processFilter(I18nFilter.class, request, response, filterChain);
            return;
        }
        request.setAttribute(SKIP_FILTER, (Object)Boolean.TRUE);
        String redirect = this.getRedirect(request);
        if (redirect == null) {
            this.processFilter(I18nFilter.class, request, response, filterChain);
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Redirect " + redirect));
        }
        response.sendRedirect(redirect);
    }
}

