/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletVersionDetector;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.servlet.SharedSessionAttributeCache;
import com.liferay.portal.util.PropsValues;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedSessionUtil {
    private static Log _log = LogFactoryUtil.getLog(SharedSessionUtil.class);

    public static Map<String, Object> getSharedSessionAttributes(HttpServletRequest request) {
        HttpSession session = request.getSession();
        if (ServletVersionDetector.is2_5()) {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            Enumeration enu = session.getAttributeNames();
            block0: while (enu.hasMoreElements()) {
                String name = (String)enu.nextElement();
                Object value = session.getAttribute(name);
                if (value == null || ArrayUtil.contains((Object[])PropsValues.SHARED_SESSION_ATTRIBUTES_EXCLUDES, (Object)name)) continue;
                String[] stringArray = PropsValues.SHARED_SESSION_ATTRIBUTES;
                int n = PropsValues.SHARED_SESSION_ATTRIBUTES.length;
                int n2 = 0;
                while (n2 < n) {
                    String sharedName = stringArray[n2];
                    if (name.startsWith(sharedName)) {
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)("Sharing " + name));
                        }
                        attributes.put(name, value);
                        continue block0;
                    }
                    ++n2;
                }
            }
            return attributes;
        }
        SharedSessionAttributeCache sharedSessionAttributeCache = SharedSessionAttributeCache.getInstance(session);
        Map<String, Object> values = sharedSessionAttributeCache.getValues();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Shared session attributes " + values));
        }
        return values;
    }
}

