/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.annotation.Propagation;
import com.liferay.portal.kernel.annotation.Transactional;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.ResourceCode;
import com.liferay.portal.service.base.ResourceCodeLocalServiceBaseImpl;
import com.liferay.portal.util.PropsValues;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ResourceCodeLocalServiceImpl
extends ResourceCodeLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(ResourceCodeLocalServiceImpl.class);
    private static Map<String, ResourceCode> _resourceCodes = new ConcurrentHashMap<String, ResourceCode>();

    public ResourceCode addResourceCode(long companyId, String name, int scope) throws SystemException {
        ResourceCode resourceCode;
        block3: {
            long codeId = this.counterLocalService.increment(ResourceCode.class.getName());
            resourceCode = this.resourceCodePersistence.create(codeId);
            resourceCode.setCompanyId(companyId);
            resourceCode.setName(name);
            resourceCode.setScope(scope);
            try {
                this.resourceCodePersistence.update((BaseModel)resourceCode, false);
            }
            catch (SystemException se) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Add failed, fetch {companyId=" + companyId + ", name=" + name + ", scope=" + scope + "}"));
                }
                if ((resourceCode = this.resourceCodePersistence.fetchByC_N_S(companyId, name, scope, false)) != null) break block3;
                throw se;
            }
        }
        return resourceCode;
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void checkResourceCodes() throws SystemException {
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
            return;
        }
        if (_resourceCodes.isEmpty()) {
            List resourceCodes = this.resourceCodePersistence.findAll();
            for (ResourceCode resourceCode : resourceCodes) {
                String key = this.encodeKey(resourceCode.getCompanyId(), resourceCode.getName(), resourceCode.getScope());
                _resourceCodes.put(key, resourceCode);
            }
        }
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void checkResourceCodes(long companyId, String name) throws SystemException {
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
            return;
        }
        this.getResourceCode(companyId, name, 1);
        this.getResourceCode(companyId, name, 2);
        this.getResourceCode(companyId, name, 3);
        this.getResourceCode(companyId, name, 4);
    }

    public ResourceCode getResourceCode(long codeId) throws PortalException, SystemException {
        return this.resourceCodePersistence.findByPrimaryKey(codeId);
    }

    public ResourceCode getResourceCode(long companyId, String name, int scope) throws SystemException {
        String key;
        ResourceCode resourceCode;
        if (Validator.isNull((String)name)) {
            name = "";
        }
        if ((resourceCode = _resourceCodes.get(key = this.encodeKey(companyId, name, scope))) == null) {
            resourceCode = this.resourceCodePersistence.fetchByC_N_S(companyId, name, scope);
            if (resourceCode == null) {
                resourceCode = this.resourceCodeLocalService.addResourceCode(companyId, name, scope);
            }
            _resourceCodes.put(key, resourceCode);
        }
        return resourceCode;
    }

    protected String encodeKey(long companyId, String name, int scope) {
        StringBundler sb = new StringBundler(5);
        sb.append(companyId);
        sb.append("#");
        sb.append(name);
        sb.append("#");
        sb.append(scope);
        return sb.toString();
    }
}

